/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.operator.PageAssertions;
import com.facebook.presto.operator.PagesHashStrategy;
import com.facebook.presto.operator.SimplePagesHashStrategy;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.type.TypeUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestJoinCompiler {
    @Test
    public void testSingleChannel() throws Exception {
        JoinCompiler joinCompiler = new JoinCompiler();
        JoinCompiler.PagesHashStrategyFactory pagesHashStrategyFactory = joinCompiler.compilePagesHashStrategyFactory((List)ImmutableList.of((Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{0}));
        ImmutableList channel = ImmutableList.of((Object)BlockAssertions.createStringSequenceBlock(10, 20), (Object)BlockAssertions.createStringSequenceBlock(20, 30), (Object)BlockAssertions.createStringSequenceBlock(15, 25));
        PagesHashStrategy hashStrategy = pagesHashStrategyFactory.createPagesHashStrategy((List)ImmutableList.of((Object)channel));
        Assert.assertEquals((int)hashStrategy.getChannelCount(), (int)1);
        for (int leftBlockIndex = 0; leftBlockIndex < channel.size(); ++leftBlockIndex) {
            Block leftBlock = (Block)channel.get(leftBlockIndex);
            PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)VarcharType.VARCHAR));
            for (int leftBlockPosition = 0; leftBlockPosition < leftBlock.getPositionCount(); ++leftBlockPosition) {
                Assert.assertEquals((int)hashStrategy.hashPosition(leftBlockIndex, leftBlockPosition), (int)TypeUtils.hashPosition((Type)VarcharType.VARCHAR, (Block)leftBlock, (int)leftBlockPosition));
                Assert.assertTrue((boolean)hashStrategy.positionEqualsPosition(leftBlockIndex, leftBlockPosition, leftBlockIndex, leftBlockPosition));
                for (int rightBlockIndex = 0; rightBlockIndex < channel.size(); ++rightBlockIndex) {
                    Block rightBlock = (Block)channel.get(rightBlockIndex);
                    for (int rightBlockPosition = 0; rightBlockPosition < rightBlock.getPositionCount(); ++rightBlockPosition) {
                        Assert.assertEquals((boolean)hashStrategy.positionEqualsPosition(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition), (boolean)TypeUtils.positionEqualsPosition((Type)VarcharType.VARCHAR, (Block)leftBlock, (int)leftBlockPosition, (Block)rightBlock, (int)rightBlockPosition));
                    }
                }
                for (Block rightBlock : channel) {
                    for (int position = 0; position < rightBlock.getPositionCount(); ++position) {
                        Assert.assertEquals((boolean)hashStrategy.positionEqualsRow(leftBlockIndex, leftBlockPosition, position, new Block[]{rightBlock}), (boolean)TypeUtils.positionEqualsPosition((Type)VarcharType.VARCHAR, (Block)leftBlock, (int)leftBlockPosition, (Block)rightBlock, (int)position));
                    }
                }
                hashStrategy.appendTo(leftBlockIndex, leftBlockPosition, pageBuilder, 0);
            }
            BlockAssertions.assertBlockEquals((Type)VarcharType.VARCHAR, pageBuilder.build().getBlock(0), leftBlock);
        }
    }

    @Test
    public void testMultiChannel() throws Exception {
        JoinCompiler joinCompiler = new JoinCompiler();
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)BooleanType.BOOLEAN);
        JoinCompiler.PagesHashStrategyFactory pagesHashStrategyFactory = joinCompiler.compilePagesHashStrategyFactory((List)types, Ints.asList((int[])new int[]{1, 2, 3, 4}));
        ImmutableList extraChannel = ImmutableList.of((Object)BlockAssertions.createStringSequenceBlock(10, 20), (Object)BlockAssertions.createStringSequenceBlock(20, 30), (Object)BlockAssertions.createStringSequenceBlock(15, 25));
        ImmutableList varcharChannel = ImmutableList.of((Object)BlockAssertions.createStringSequenceBlock(10, 20), (Object)BlockAssertions.createStringSequenceBlock(20, 30), (Object)BlockAssertions.createStringSequenceBlock(15, 25));
        ImmutableList longChannel = ImmutableList.of((Object)BlockAssertions.createLongSequenceBlock(10, 20), (Object)BlockAssertions.createLongSequenceBlock(20, 30), (Object)BlockAssertions.createLongSequenceBlock(15, 25));
        ImmutableList doubleChannel = ImmutableList.of((Object)BlockAssertions.createDoubleSequenceBlock(10, 20), (Object)BlockAssertions.createDoubleSequenceBlock(20, 30), (Object)BlockAssertions.createDoubleSequenceBlock(15, 25));
        ImmutableList booleanChannel = ImmutableList.of((Object)BlockAssertions.createBooleanSequenceBlock(10, 20), (Object)BlockAssertions.createBooleanSequenceBlock(20, 30), (Object)BlockAssertions.createBooleanSequenceBlock(15, 25));
        ImmutableList channels = ImmutableList.of((Object)extraChannel, (Object)varcharChannel, (Object)longChannel, (Object)doubleChannel, (Object)booleanChannel);
        PagesHashStrategy hashStrategy = pagesHashStrategyFactory.createPagesHashStrategy((List)channels);
        Assert.assertEquals((int)hashStrategy.getChannelCount(), (int)5);
        SimplePagesHashStrategy expectedHashStrategy = new SimplePagesHashStrategy((List)types, (List)channels, Ints.asList((int[])new int[]{1, 2, 3, 4}));
        for (int leftBlockIndex = 0; leftBlockIndex < varcharChannel.size(); ++leftBlockIndex) {
            PageBuilder pageBuilder = new PageBuilder((List)types);
            int leftPositionCount = ((Block)varcharChannel.get(leftBlockIndex)).getPositionCount();
            for (int leftBlockPosition = 0; leftBlockPosition < leftPositionCount; ++leftBlockPosition) {
                int rightBlockIndex;
                Assert.assertEquals((int)hashStrategy.hashPosition(leftBlockIndex, leftBlockPosition), (int)expectedHashStrategy.hashPosition(leftBlockIndex, leftBlockPosition));
                Assert.assertTrue((boolean)hashStrategy.positionEqualsPosition(leftBlockIndex, leftBlockPosition, leftBlockIndex, leftBlockPosition));
                for (rightBlockIndex = 0; rightBlockIndex < varcharChannel.size(); ++rightBlockIndex) {
                    Block rightBlock = (Block)varcharChannel.get(rightBlockIndex);
                    for (int rightBlockPosition = 0; rightBlockPosition < rightBlock.getPositionCount(); ++rightBlockPosition) {
                        Assert.assertEquals((boolean)hashStrategy.positionEqualsPosition(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition), (boolean)expectedHashStrategy.positionEqualsPosition(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition));
                    }
                }
                for (rightBlockIndex = 0; rightBlockIndex < varcharChannel.size(); ++rightBlockIndex) {
                    Block[] rightBlocks = new Block[]{(Block)varcharChannel.get(rightBlockIndex), (Block)longChannel.get(rightBlockIndex), (Block)doubleChannel.get(rightBlockIndex), (Block)booleanChannel.get(rightBlockIndex)};
                    int rightPositionCount = ((Block)varcharChannel.get(rightBlockIndex)).getPositionCount();
                    for (int rightPosition = 0; rightPosition < rightPositionCount; ++rightPosition) {
                        Assert.assertEquals((boolean)hashStrategy.positionEqualsRow(leftBlockIndex, leftBlockPosition, rightPosition, rightBlocks), (boolean)expectedHashStrategy.positionEqualsRow(leftBlockIndex, leftBlockPosition, rightPosition, rightBlocks));
                    }
                }
                hashStrategy.appendTo(leftBlockIndex, leftBlockPosition, pageBuilder, 0);
            }
            Page page = pageBuilder.build();
            PageAssertions.assertPageEquals((List<? extends Type>)types, page, new Page(new Block[]{(Block)extraChannel.get(leftBlockIndex), (Block)varcharChannel.get(leftBlockIndex), (Block)longChannel.get(leftBlockIndex), (Block)doubleChannel.get(leftBlockIndex), (Block)booleanChannel.get(leftBlockIndex)}));
        }
    }
}

