/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.JoinProbe;
import com.facebook.presto.operator.JoinProbeFactory;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.PageAssertions;
import com.facebook.presto.operator.SequencePageBuilder;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.ValuesOperator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.sql.gen.JoinProbeCompiler;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.concurrent.Threads;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestJoinProbeCompiler {
    private ExecutorService executor;
    private TaskContext taskContext;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test"));
        this.taskContext = new TaskContext(new TaskId("query", "stage", "task"), (Executor)this.executor, SessionTestUtils.TEST_SESSION);
    }

    @AfterMethod
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testSingleChannel() throws Exception {
        DriverContext driverContext = this.taskContext.addPipelineContext(true, true).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, ValuesOperator.class.getSimpleName());
        JoinCompiler joinCompiler = new JoinCompiler();
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR);
        JoinCompiler.LookupSourceFactory lookupSourceFactoryFactory = joinCompiler.compileLookupSourceFactory((List)types, Ints.asList((int[])new int[]{0}));
        ImmutableList channel = ImmutableList.of((Object)BlockAssertions.createStringSequenceBlock(10, 20), (Object)BlockAssertions.createStringSequenceBlock(20, 30), (Object)BlockAssertions.createStringSequenceBlock(15, 25));
        LongArrayList addresses = new LongArrayList();
        for (int blockIndex = 0; blockIndex < channel.size(); ++blockIndex) {
            Block block = (Block)channel.get(blockIndex);
            for (int positionIndex = 0; positionIndex < block.getPositionCount(); ++positionIndex) {
                addresses.add(SyntheticAddress.encodeSyntheticAddress((int)blockIndex, (int)positionIndex));
            }
        }
        LookupSource lookupSource = lookupSourceFactoryFactory.createLookupSource(addresses, (List)types, (List)ImmutableList.of((Object)channel), operatorContext);
        JoinProbeCompiler joinProbeCompiler = new JoinProbeCompiler();
        JoinProbeFactory probeFactory = joinProbeCompiler.internalCompileJoinProbe((List)types, Ints.asList((int[])new int[]{0}));
        Page page = SequencePageBuilder.createSequencePage((List<? extends Type>)types, 10, 10);
        JoinProbe joinProbe = probeFactory.createJoinProbe(lookupSource, page);
        Assert.assertEquals((int)joinProbe.getChannelCount(), (int)1);
        Block probeBlock = page.getBlock(0);
        PageBuilder pageBuilder = new PageBuilder((List)types);
        for (int position = 0; position < page.getPositionCount(); ++position) {
            Assert.assertTrue((boolean)joinProbe.advanceNextPosition());
            joinProbe.appendTo(pageBuilder);
            Assert.assertEquals((long)joinProbe.getCurrentJoinPosition(), (long)lookupSource.getJoinPosition(position, new Block[]{probeBlock}));
        }
        Assert.assertFalse((boolean)joinProbe.advanceNextPosition());
        PageAssertions.assertPageEquals((List<? extends Type>)types, pageBuilder.build(), page);
    }
}

