/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.block.BlockUtils;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.InterpretedProjectionFunction;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.ArithmeticExpression;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestInterpretedProjectionFunction {
    private static final SqlParser SQL_PARSER = new SqlParser();
    private static final Metadata METADATA = new MetadataManager();

    @Test
    public void testBooleanExpression() {
        TestInterpretedProjectionFunction.assertProjection("true", true);
        TestInterpretedProjectionFunction.assertProjection("false", false);
        TestInterpretedProjectionFunction.assertProjection("1 = 1", true);
        TestInterpretedProjectionFunction.assertProjection("1 = 0", false);
        TestInterpretedProjectionFunction.assertProjection("true and false", false);
    }

    @Test
    public void testArithmeticExpression() {
        TestInterpretedProjectionFunction.assertProjection("42 + 87", 129L);
        TestInterpretedProjectionFunction.assertProjection("42 + 22.2", 64.2);
        TestInterpretedProjectionFunction.assertProjection("11.1 + 22.2", 33.3);
        TestInterpretedProjectionFunction.assertProjection("42 - 87", -45L);
        TestInterpretedProjectionFunction.assertProjection("42 - 22.2", 19.8);
        TestInterpretedProjectionFunction.assertProjection("11.1 - 22.2", -11.1);
        TestInterpretedProjectionFunction.assertProjection("42 * 87", 3654L);
        TestInterpretedProjectionFunction.assertProjection("42 * 22.2", 932.4);
        TestInterpretedProjectionFunction.assertProjection("11.1 * 22.2", 246.42);
        TestInterpretedProjectionFunction.assertProjection("42 / 87", 0L);
        TestInterpretedProjectionFunction.assertProjection("42 / 22.2", 1.8918918918918919);
        TestInterpretedProjectionFunction.assertProjection("11.1 / 22.2", 0.5);
        TestInterpretedProjectionFunction.assertProjection("42 % 87", 42L);
        TestInterpretedProjectionFunction.assertProjection("42 % 22.2", 19.8);
        TestInterpretedProjectionFunction.assertProjection("11.1 % 22.2", 11.1);
    }

    @Test
    public void testArithmeticExpressionWithNulls() {
        for (ArithmeticExpression.Type type : ArithmeticExpression.Type.values()) {
            TestInterpretedProjectionFunction.assertProjection("NULL " + type.getValue() + " NULL", null);
            TestInterpretedProjectionFunction.assertProjection("42 " + type.getValue() + " NULL", null);
            TestInterpretedProjectionFunction.assertProjection("NULL " + type.getValue() + " 42", null);
            TestInterpretedProjectionFunction.assertProjection("11.1 " + type.getValue() + " NULL", null);
            TestInterpretedProjectionFunction.assertProjection("NULL " + type.getValue() + " 11.1", null);
        }
    }

    @Test
    public void testCoalesceExpression() {
        TestInterpretedProjectionFunction.assertProjection("COALESCE(42, 87, 100)", 42L);
        TestInterpretedProjectionFunction.assertProjection("COALESCE(NULL, 87, 100)", 87L);
        TestInterpretedProjectionFunction.assertProjection("COALESCE(42, NULL, 100)", 42L);
        TestInterpretedProjectionFunction.assertProjection("COALESCE(NULL, NULL, 100)", 100L);
        TestInterpretedProjectionFunction.assertProjection("COALESCE(42.2, 87.2, 100.2)", 42.2);
        TestInterpretedProjectionFunction.assertProjection("COALESCE(NULL, 87.2, 100.2)", 87.2);
        TestInterpretedProjectionFunction.assertProjection("COALESCE(42.2, NULL, 100.2)", 42.2);
        TestInterpretedProjectionFunction.assertProjection("COALESCE(NULL, NULL, 100.2)", 100.2);
        TestInterpretedProjectionFunction.assertProjection("COALESCE('foo', 'bar', 'zah')", "foo");
        TestInterpretedProjectionFunction.assertProjection("COALESCE(NULL, 'bar', 'zah')", "bar");
        TestInterpretedProjectionFunction.assertProjection("COALESCE('foo', NULL, 'zah')", "foo");
        TestInterpretedProjectionFunction.assertProjection("COALESCE(NULL, NULL, 'zah')", "zah");
        TestInterpretedProjectionFunction.assertProjection("COALESCE(NULL, NULL, NULL)", null);
    }

    @Test
    public void testNullIf() {
        TestInterpretedProjectionFunction.assertProjection("NULLIF(42, 42)", null);
        TestInterpretedProjectionFunction.assertProjection("NULLIF(42, 42.0)", null);
        TestInterpretedProjectionFunction.assertProjection("NULLIF(42.42, 42.42)", null);
        TestInterpretedProjectionFunction.assertProjection("NULLIF('foo', 'foo')", null);
        TestInterpretedProjectionFunction.assertProjection("NULLIF(42, 87)", 42L);
        TestInterpretedProjectionFunction.assertProjection("NULLIF(42, 22.2)", 42L);
        TestInterpretedProjectionFunction.assertProjection("NULLIF(42.42, 22.2)", 42.42);
        TestInterpretedProjectionFunction.assertProjection("NULLIF('foo', 'bar')", "foo");
        TestInterpretedProjectionFunction.assertProjection("NULLIF(NULL, NULL)", null);
        TestInterpretedProjectionFunction.assertProjection("NULLIF(42, NULL)", 42L);
        TestInterpretedProjectionFunction.assertProjection("NULLIF(NULL, 42)", null);
        TestInterpretedProjectionFunction.assertProjection("NULLIF(11.1, NULL)", 11.1);
        TestInterpretedProjectionFunction.assertProjection("NULLIF(NULL, 11.1)", null);
    }

    @Test
    public void testSymbolReference() {
        Symbol symbol = new Symbol("symbol");
        ImmutableMap symbolToInputMappings = ImmutableMap.of((Object)symbol, (Object)0);
        TestInterpretedProjectionFunction.assertProjection("symbol", true, (Map<Symbol, Integer>)symbolToInputMappings, (Map<Symbol, Type>)ImmutableMap.of((Object)symbol, (Object)BooleanType.BOOLEAN), 0, TestInterpretedProjectionFunction.createBlock((Type)BooleanType.BOOLEAN, true));
        TestInterpretedProjectionFunction.assertProjection("symbol", null, (Map<Symbol, Integer>)symbolToInputMappings, (Map<Symbol, Type>)ImmutableMap.of((Object)symbol, (Object)BooleanType.BOOLEAN), 0, TestInterpretedProjectionFunction.createBlock((Type)BooleanType.BOOLEAN, null));
        TestInterpretedProjectionFunction.assertProjection("symbol", 42L, (Map<Symbol, Integer>)symbolToInputMappings, (Map<Symbol, Type>)ImmutableMap.of((Object)symbol, (Object)BigintType.BIGINT), 0, TestInterpretedProjectionFunction.createBlock((Type)BigintType.BIGINT, 42));
        TestInterpretedProjectionFunction.assertProjection("symbol", null, (Map<Symbol, Integer>)symbolToInputMappings, (Map<Symbol, Type>)ImmutableMap.of((Object)symbol, (Object)BigintType.BIGINT), 0, TestInterpretedProjectionFunction.createBlock((Type)BigintType.BIGINT, null));
        TestInterpretedProjectionFunction.assertProjection("symbol", 11.1, (Map<Symbol, Integer>)symbolToInputMappings, (Map<Symbol, Type>)ImmutableMap.of((Object)symbol, (Object)DoubleType.DOUBLE), 0, TestInterpretedProjectionFunction.createBlock((Type)DoubleType.DOUBLE, 11.1));
        TestInterpretedProjectionFunction.assertProjection("symbol", null, (Map<Symbol, Integer>)symbolToInputMappings, (Map<Symbol, Type>)ImmutableMap.of((Object)symbol, (Object)DoubleType.DOUBLE), 0, TestInterpretedProjectionFunction.createBlock((Type)DoubleType.DOUBLE, null));
        TestInterpretedProjectionFunction.assertProjection("symbol", "foo", (Map<Symbol, Integer>)symbolToInputMappings, (Map<Symbol, Type>)ImmutableMap.of((Object)symbol, (Object)VarcharType.VARCHAR), 0, TestInterpretedProjectionFunction.createBlock((Type)VarcharType.VARCHAR, "foo"));
        TestInterpretedProjectionFunction.assertProjection("symbol", null, (Map<Symbol, Integer>)symbolToInputMappings, (Map<Symbol, Type>)ImmutableMap.of((Object)symbol, (Object)VarcharType.VARCHAR), 0, TestInterpretedProjectionFunction.createBlock((Type)VarcharType.VARCHAR, null));
    }

    public static void assertProjection(String expression, @Nullable Object expectedValue) {
        TestInterpretedProjectionFunction.assertProjection(expression, expectedValue, (Map<Symbol, Integer>)ImmutableMap.of(), (Map<Symbol, Type>)ImmutableMap.of(), 0, new Block[0]);
    }

    private static void assertProjection(String expression, @Nullable Object expectedValue, Map<Symbol, Integer> symbolToInputMappings, Map<Symbol, Type> symbolTypes, int position, Block ... blocks) {
        InterpretedProjectionFunction projectionFunction = new InterpretedProjectionFunction(FunctionAssertions.createExpression(expression, METADATA, symbolTypes), symbolTypes, symbolToInputMappings, METADATA, SQL_PARSER, SessionTestUtils.TEST_SESSION);
        Type type = projectionFunction.getType();
        BlockBuilder builder = type.createBlockBuilder(new BlockBuilderStatus());
        projectionFunction.project(position, blocks, builder);
        Object actualValue = BlockAssertions.getOnlyValue(type, builder.build());
        Assert.assertEquals((Object)actualValue, (Object)expectedValue);
    }

    private static Block createBlock(Type type, Object value) {
        BlockBuilder blockBuilder = type.createBlockBuilder(new BlockBuilderStatus());
        BlockUtils.appendObject((Type)type, (BlockBuilder)blockBuilder, (Object)value);
        return blockBuilder.build();
    }
}

