/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.type.SqlTimestamp;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.type.ArrayType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestArrayOperators {
    private FunctionAssertions functionAssertions;

    @BeforeClass
    public void setUp() {
        this.functionAssertions = new FunctionAssertions();
    }

    private void assertFunction(String projection, Object expected) {
        this.functionAssertions.assertFunction(projection, expected);
    }

    @Test
    public void testStackRepresentation() throws Exception {
        Slice slice = ArrayType.rawSlicesToStackRepresentation((List)ImmutableList.of((Object)ArrayType.toStackRepresentation((List)ImmutableList.of((Object)1L, (Object)2L)), (Object)ArrayType.toStackRepresentation((List)ImmutableList.of((Object)3L))));
        Assert.assertEquals((Object)slice, (Object)Slices.utf8Slice((String)"[[1,2],[3]]"));
    }

    @Test
    public void testArrayToJson() throws Exception {
        this.assertFunction("CAST(ARRAY [1, 2, 3] AS JSON)", "[1,2,3]");
        this.assertFunction("CAST(ARRAY [1, NULL, 3] AS JSON)", "[1,null,3]");
        this.assertFunction("CAST(ARRAY [1, 2.0, 3] AS JSON)", "[1.0,2.0,3.0]");
        this.assertFunction("CAST(ARRAY [1.0, 2.5, 3.0] AS JSON)", "[1.0,2.5,3.0]");
        this.assertFunction("CAST(ARRAY ['puppies', 'kittens'] AS JSON)", "[\"puppies\",\"kittens\"]");
        this.assertFunction("CAST(ARRAY [TRUE, FALSE] AS JSON)", "[true,false]");
        this.assertFunction("CAST(ARRAY [from_unixtime(1)] AS JSON)", "[\"" + new SqlTimestamp(1000L, SessionTestUtils.TEST_SESSION.getTimeZoneKey()).toString() + "\"]");
    }

    @Test
    public void testConstructor() throws Exception {
        this.assertFunction("ARRAY []", ImmutableList.of());
        this.assertFunction("ARRAY [NULL]", Lists.newArrayList((Object[])new Object[]{null}));
        this.assertFunction("ARRAY [1, 2, 3]", ImmutableList.of((Object)1L, (Object)2L, (Object)3L));
        this.assertFunction("ARRAY [1, NULL, 3]", Lists.newArrayList((Object[])new Long[]{1L, null, 3L}));
        this.assertFunction("ARRAY [NULL, 2, 3]", Lists.newArrayList((Object[])new Long[]{null, 2L, 3L}));
        this.assertFunction("ARRAY [1, 2.0, 3]", ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0));
        this.assertFunction("ARRAY [ARRAY[1, 2], ARRAY[3]]", ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)2L), (Object)ImmutableList.of((Object)3L)));
        this.assertFunction("ARRAY [ARRAY[1, 2], NULL, ARRAY[3]]", Lists.newArrayList((Object[])new ImmutableList[]{ImmutableList.of((Object)1L, (Object)2L), null, ImmutableList.of((Object)3L)}));
        this.assertFunction("ARRAY [1.0, 2.5, 3.0]", ImmutableList.of((Object)1.0, (Object)2.5, (Object)3.0));
        this.assertFunction("ARRAY ['puppies', 'kittens']", ImmutableList.of((Object)"puppies", (Object)"kittens"));
        this.assertFunction("ARRAY [TRUE, FALSE]", ImmutableList.of((Object)true, (Object)false));
        this.assertFunction("ARRAY [from_unixtime(1), from_unixtime(100)]", ImmutableList.of((Object)new SqlTimestamp(1000L, SessionTestUtils.TEST_SESSION.getTimeZoneKey()), (Object)new SqlTimestamp(100000L, SessionTestUtils.TEST_SESSION.getTimeZoneKey())));
    }

    @Test
    public void testArrayContains() throws Exception {
        this.assertFunction("CONTAINS(ARRAY [1, 2, 3], 2)", true);
        this.assertFunction("CONTAINS(ARRAY [1, 2, 3], 5)", false);
        this.assertFunction("CONTAINS(ARRAY [1, NULL, 3], 1)", true);
        this.assertFunction("CONTAINS(ARRAY [1, 2.0, 3], 3.0)", true);
        this.assertFunction("CONTAINS(ARRAY [1.0, 2.5, 3.0], 2.2)", false);
        this.assertFunction("CONTAINS(ARRAY ['puppies', 'kittens'], 'kittens')", true);
        this.assertFunction("CONTAINS(ARRAY ['puppies', 'kittens'], 'lizards')", false);
        this.assertFunction("CONTAINS(ARRAY [TRUE, FALSE], TRUE)", true);
        this.assertFunction("CONTAINS(ARRAY [FALSE], TRUE)", false);
    }

    @Test
    public void testCardinality() throws Exception {
        this.assertFunction("CARDINALITY(ARRAY [])", 0);
        this.assertFunction("CARDINALITY(ARRAY [NULL])", 1);
        this.assertFunction("CARDINALITY(ARRAY [1, 2, 3])", 3);
        this.assertFunction("CARDINALITY(ARRAY [1, NULL, 3])", 3);
        this.assertFunction("CARDINALITY(ARRAY [1, 2.0, 3])", 3);
        this.assertFunction("CARDINALITY(ARRAY [ARRAY[1, 2], ARRAY[3]])", 2);
        this.assertFunction("CARDINALITY(ARRAY [1.0, 2.5, 3.0])", 3);
        this.assertFunction("CARDINALITY(ARRAY ['puppies', 'kittens'])", 2);
        this.assertFunction("CARDINALITY(ARRAY [TRUE, FALSE])", 2);
    }

    @Test
    public void testSubscript() throws Exception {
        try {
            this.assertFunction("ARRAY [1, 2, 3][0]", null);
            Assert.fail((String)"Access to array element zero should fail");
        }
        catch (PrestoException e) {
            // empty catch block
        }
        try {
            this.assertFunction("ARRAY [1, 2, 3][-1]", null);
            Assert.fail((String)"Access to negative array element should fail");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            this.assertFunction("ARRAY [1, 2, 3][4]", null);
            Assert.fail((String)"Access to out of bounds array element should fail");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            this.assertFunction("ARRAY [1, 2, 3][1.1]", null);
            Assert.fail((String)"Access to array with double subscript should fail");
        }
        catch (SemanticException e) {
            Assert.assertTrue((e.getCode() == SemanticErrorCode.TYPE_MISMATCH ? 1 : 0) != 0);
        }
        this.assertFunction("1 + ARRAY [2, 1, 3][2]", 2);
        this.assertFunction("ARRAY [2, 1, 3][2]", 1);
        this.assertFunction("ARRAY [2, NULL, 3][2]", null);
        this.assertFunction("ARRAY [1.0, 2.5, 3.5][3]", 3.5);
        this.assertFunction("ARRAY [ARRAY[1, 2], ARRAY[3]][2]", ImmutableList.of((Object)3L));
        this.assertFunction("ARRAY [ARRAY[1, 2], NULL, ARRAY[3]][2]", null);
        this.assertFunction("ARRAY [ARRAY[1, 2], ARRAY[3]][2][1]", 3);
        this.assertFunction("ARRAY ['puppies', 'kittens'][2]", "kittens");
        this.assertFunction("ARRAY ['puppies', 'kittens', NULL][3]", null);
        this.assertFunction("ARRAY [TRUE, FALSE][2]", false);
        this.assertFunction("ARRAY [from_unixtime(1), from_unixtime(100)][1]", new SqlTimestamp(1000L, SessionTestUtils.TEST_SESSION.getTimeZoneKey()));
    }

    @Test
    public void testSort() throws Exception {
        this.assertFunction("ARRAY_SORT(ARRAY[2, 3, 4, 1])", ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)4L));
        this.assertFunction("ARRAY_SORT(ARRAY['z', 'f', 's', 'd', 'g'])", ImmutableList.of((Object)"d", (Object)"f", (Object)"g", (Object)"s", (Object)"z"));
        this.assertFunction("ARRAY_SORT(ARRAY[TRUE, FALSE])", ImmutableList.of((Object)false, (Object)true));
        this.assertFunction("ARRAY_SORT(ARRAY[22.1, 11.1, 1.1, 44.1])", ImmutableList.of((Object)1.1, (Object)11.1, (Object)22.1, (Object)44.1));
        this.assertFunction("ARRAY_SORT(ARRAY [from_unixtime(100), from_unixtime(1), from_unixtime(200)])", ImmutableList.of((Object)new SqlTimestamp(1000L, SessionTestUtils.TEST_SESSION.getTimeZoneKey()), (Object)new SqlTimestamp(100000L, SessionTestUtils.TEST_SESSION.getTimeZoneKey()), (Object)new SqlTimestamp(200000L, SessionTestUtils.TEST_SESSION.getTimeZoneKey())));
        try {
            this.assertFunction("ARRAY_SORT(ARRAY [ARRAY [1], ARRAY [2]])", null);
            Assert.fail((String)"ARRAY_SORT is not supported for arrays with incomparable elements");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            this.assertFunction("ARRAY_SORT(ARRAY[NULL, NULL, NULL])", null);
            Assert.fail((String)"ARRAY_SORT is not supported for arrays with incomparable elements");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

