/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.util.DelimitedRecordSet;
import com.google.common.base.Splitter;
import com.google.common.io.CharSource;
import io.airlift.slice.Slices;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDelimitedRecordIterable {
    @Test
    public void testExtraction() throws Exception {
        DelimitedRecordSet recordIterable = new DelimitedRecordSet(CharSource.wrap((CharSequence)"apple,fuu,123\nbanana,bar,456"), Splitter.on((char)','), new ColumnMetadata[]{new ColumnMetadata("fruit", (Type)VarcharType.VARCHAR, 0, false), new ColumnMetadata("foo", (Type)VarcharType.VARCHAR, 1, false), new ColumnMetadata("value", (Type)VarcharType.VARCHAR, 2, false)});
        RecordCursor cursor = recordIterable.cursor();
        Assert.assertTrue((boolean)cursor.advanceNextPosition());
        Assert.assertEquals((Object)cursor.getSlice(0), (Object)Slices.utf8Slice((String)"apple"));
        Assert.assertEquals((Object)cursor.getSlice(1), (Object)Slices.utf8Slice((String)"fuu"));
        Assert.assertEquals((Object)cursor.getSlice(2), (Object)Slices.utf8Slice((String)"123"));
        Assert.assertEquals((long)cursor.getLong(2), (long)123L);
        Assert.assertEquals((Object)cursor.getDouble(2), (Object)123.0);
        Assert.assertTrue((boolean)cursor.advanceNextPosition());
        Assert.assertEquals((Object)cursor.getSlice(0), (Object)Slices.utf8Slice((String)"banana"));
        Assert.assertEquals((Object)cursor.getSlice(1), (Object)Slices.utf8Slice((String)"bar"));
        Assert.assertEquals((Object)cursor.getSlice(2), (Object)Slices.utf8Slice((String)"456"));
        Assert.assertEquals((long)cursor.getLong(2), (long)456L);
        Assert.assertEquals((Object)cursor.getDouble(2), (Object)456.0);
        Assert.assertFalse((boolean)cursor.advanceNextPosition());
    }
}

