/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.TypeRegistry;
import com.facebook.presto.util.Types;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTypes {
    @Test
    public void testCheckType() throws Exception {
        Long number = 123L;
        Types.checkType((Object)number, Long.class, (String)"number");
        Integer integer = 123;
        Types.checkType((Object)integer, Integer.class, (String)"integer");
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="number must be of type java.lang.Long, not java.lang.String")
    public void testCheckTypeFails() throws Exception {
        String number = "hello";
        Types.checkType((Object)number, Long.class, (String)"number");
    }

    @Test
    public void testNonexistentType() {
        TypeRegistry typeManager = new TypeRegistry();
        Assert.assertNull((Object)typeManager.getType(TypeSignature.parseTypeSignature((String)"not a real type")));
    }
}

