/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.ClassInfoLoader;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.DynamicClassLoader;
import com.facebook.presto.byteCode.NamedParameterDefinition;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.SmartClassWriter;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.sql.gen.Bootstrap;
import com.facebook.presto.sql.gen.CompilerUtils;
import com.google.common.collect.ImmutableList;
import org.objectweb.asm.ClassVisitor;
import org.testng.Assert;

public final class ByteCodeExpressionAssertions {
    private static final boolean DUMP_BYTE_CODE_TREE = false;

    private ByteCodeExpressionAssertions() {
    }

    public static void assertByteCodeExpression(ByteCodeExpression expression, Object expected, String expectedRendering) throws Exception {
        Assert.assertEquals((String)expression.toString(), (String)expectedRendering);
        ByteCodeExpressionAssertions.assertByteCodeNode((ByteCodeNode)expression.ret(), expression.getType(), expected);
    }

    public static void assertByteCodeNode(ByteCodeNode node, ParameterizedType returnType, Object expected) throws Exception {
        Assert.assertEquals((Object)ByteCodeExpressionAssertions.execute(node, returnType), (Object)expected);
    }

    public static Object execute(ByteCodeNode node, ParameterizedType returnType) throws Exception {
        ClassDefinition classDefinition = new ClassDefinition(new CompilerContext(Bootstrap.BOOTSTRAP_METHOD), Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName((String)"Test"), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        classDefinition.declareMethod(new CompilerContext(Bootstrap.BOOTSTRAP_METHOD), Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "test", returnType, new NamedParameterDefinition[0]).getBody().append(node);
        DynamicClassLoader classLoader = new DynamicClassLoader();
        SmartClassWriter cw = new SmartClassWriter(ClassInfoLoader.createClassInfoLoader((Iterable)ImmutableList.of((Object)classDefinition), (ClassLoader)classLoader));
        classDefinition.visit((ClassVisitor)cw);
        Class clazz = classLoader.defineClass(classDefinition.getType().getJavaClassName(), cw.toByteArray());
        return clazz.getMethod("test", new Class[0]).invoke(null, new Object[0]);
    }
}

