/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.RemoteTaskFactory;
import com.facebook.presto.execution.SharedBuffer;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.TestingColumnHandle;
import com.facebook.presto.sql.planner.TestingTableHandle;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.util.Failures;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.GuardedBy;
import org.joda.time.DateTime;

public class MockRemoteTaskFactory
implements RemoteTaskFactory {
    private final Executor executor;

    MockRemoteTaskFactory(Executor executor) {
        this.executor = executor;
    }

    public RemoteTask createTableScanTask(Node newNode, List<Split> splits) {
        TaskId taskId = new TaskId(new StageId("test", "1"), "1");
        Symbol symbol = new Symbol("column");
        PlanNodeId tableScanNodeId = new PlanNodeId("test");
        PlanNodeId sourceId = new PlanNodeId("sourceId");
        PlanFragment testFragment = new PlanFragment(new PlanFragmentId("test"), (PlanNode)new TableScanNode(new PlanNodeId("test"), new TableHandle("test", (ConnectorTableHandle)new TestingTableHandle()), (List)ImmutableList.of((Object)symbol), (Map)ImmutableMap.of((Object)symbol, (Object)new ColumnHandle("test", (ConnectorColumnHandle)new TestingColumnHandle("column"))), null, Optional.absent()), (Map)ImmutableMap.of((Object)symbol, (Object)VarcharType.VARCHAR), PlanFragment.PlanDistribution.SOURCE, tableScanNodeId, PlanFragment.OutputPartitioning.NONE, (List)ImmutableList.of());
        ImmutableMultimap.Builder initialSplits = ImmutableMultimap.builder();
        for (Split sourceSplit : splits) {
            initialSplits.put((Object)sourceId, (Object)sourceSplit);
        }
        return this.createRemoteTask(SessionTestUtils.TEST_SESSION, taskId, newNode, testFragment, (Multimap<PlanNodeId, Split>)initialSplits.build(), OutputBuffers.INITIAL_EMPTY_OUTPUT_BUFFERS);
    }

    public RemoteTask createRemoteTask(Session session, TaskId taskId, Node node, PlanFragment fragment, Multimap<PlanNodeId, Split> initialSplits, OutputBuffers outputBuffers) {
        return new MockRemoteTask(taskId, fragment, node.getNodeIdentifier(), this.executor, initialSplits);
    }

    private class MockRemoteTask
    implements RemoteTask {
        private final AtomicLong nextTaskInfoVersion = new AtomicLong(1L);
        private final URI location;
        private final TaskStateMachine taskStateMachine;
        private final TaskContext taskContext;
        private final SharedBuffer sharedBuffer;
        private final String nodeId;
        private final PlanFragment fragment;
        @GuardedBy(value="this")
        private final Set<PlanNodeId> noMoreSplits = new HashSet<PlanNodeId>();
        @GuardedBy(value="this")
        private final Multimap<PlanNodeId, Split> splits = HashMultimap.create();

        public MockRemoteTask(TaskId taskId, PlanFragment fragment, String nodeId, Executor executor, Multimap<PlanNodeId, Split> initialSplits) {
            this.taskStateMachine = new TaskStateMachine((TaskId)Preconditions.checkNotNull((Object)taskId, (Object)"taskId is null"), (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor is null"));
            this.taskContext = new TaskContext(this.taskStateMachine, executor, SessionTestUtils.TEST_SESSION, new DataSize(256.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), true, true);
            this.location = URI.create("fake://task/" + taskId);
            this.sharedBuffer = new SharedBuffer(taskId, executor, (DataSize)Preconditions.checkNotNull((Object)new DataSize(1.0, DataSize.Unit.BYTE), (Object)"maxBufferSize is null"));
            this.fragment = (PlanFragment)Preconditions.checkNotNull((Object)fragment, (Object)"fragment is null");
            this.nodeId = (String)Preconditions.checkNotNull((Object)nodeId, (Object)"nodeId is null");
            this.splits.putAll(initialSplits);
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public TaskInfo getTaskInfo() {
            TaskState state = this.taskStateMachine.getState();
            Object failures = ImmutableList.of();
            if (state == TaskState.FAILED) {
                failures = Failures.toFailures((Iterable)this.taskStateMachine.getFailureCauses());
            }
            return new TaskInfo(this.taskStateMachine.getTaskId(), this.nextTaskInfoVersion.getAndIncrement(), state, this.location, DateTime.now(), this.sharedBuffer.getInfo(), (Set)ImmutableSet.of(), this.taskContext.getTaskStats(), (List)failures);
        }

        public void start() {
        }

        public void addSplits(PlanNodeId sourceId, Iterable<Split> splits) {
            Preconditions.checkNotNull(splits, (Object)"splits is null");
            for (Split split : splits) {
                this.splits.put((Object)sourceId, (Object)split);
            }
        }

        public void noMoreSplits(PlanNodeId sourceId) {
            this.noMoreSplits.add(sourceId);
            if (this.noMoreSplits.containsAll(this.fragment.getSourceIds())) {
                this.taskStateMachine.finished();
            }
        }

        public void setOutputBuffers(OutputBuffers outputBuffers) {
            this.sharedBuffer.setOutputBuffers(outputBuffers);
        }

        public void addStateChangeListener(final StateMachine.StateChangeListener<TaskInfo> stateChangeListener) {
            this.taskStateMachine.addStateChangeListener((StateMachine.StateChangeListener)new StateMachine.StateChangeListener<TaskState>(){

                public void stateChanged(TaskState newValue) {
                    stateChangeListener.stateChanged((Object)MockRemoteTask.this.getTaskInfo());
                }
            });
        }

        public void cancel() {
            this.taskStateMachine.cancel();
        }

        public int getPartitionedSplitCount() {
            if (this.taskStateMachine.getState().isDone()) {
                return 0;
            }
            return this.splits.size();
        }

        public int getQueuedPartitionedSplitCount() {
            if (this.taskStateMachine.getState().isDone()) {
                return 0;
            }
            return this.splits.size();
        }

        public Duration waitForTaskToFinish(Duration maxWait) throws InterruptedException {
            while (true) {
                TaskState currentState = this.taskStateMachine.getState();
                if (maxWait.toMillis() <= 1L || currentState.isDone()) {
                    return maxWait;
                }
                maxWait = this.taskStateMachine.waitForStateChange(currentState, maxWait);
            }
        }
    }
}

