/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.SplitRunner;
import com.facebook.presto.execution.TaskExecutor;
import com.facebook.presto.execution.TaskId;
import com.google.common.base.Throwables;
import com.google.common.base.Ticker;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.Threads;
import io.airlift.stats.Distribution;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class TaskExecutorSimulator
implements Closeable {
    private static final boolean PRINT_TASK_COMPLETION = false;
    private static final boolean PRINT_SPLIT_COMPLETION = false;
    private ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(Threads.threadsNamed((String)(this.getClass().getSimpleName() + "-%d"))));
    private TaskExecutor taskExecutor = new TaskExecutor(24, new Ticker(){
        private final long start = System.nanoTime();

        public long read() {
            long now = System.nanoTime();
            return (now - this.start) * 100L;
        }
    });

    public static void main(String[] args) throws Exception {
        try (TaskExecutorSimulator simulator = new TaskExecutorSimulator();){
            simulator.run();
        }
    }

    public TaskExecutorSimulator() {
        this.taskExecutor.start();
    }

    @Override
    public void close() {
        this.taskExecutor.stop();
        this.executor.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        TreeMap middleTasks;
        int i;
        ListenableFuture<?> future;
        int userId;
        ListenableFuture<?> tasks = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
        Set finishFutures = Sets.newSetFromMap(new ConcurrentHashMap());
        AtomicBoolean done = new AtomicBoolean();
        long start = System.nanoTime();
        for (userId = 0; userId < 2; ++userId) {
            future = this.createUser("large_" + userId, 100, this.taskExecutor, done, (Multimap<Integer, SimulationTask>)tasks);
            finishFutures.add(future);
        }
        for (userId = 0; userId < 4; ++userId) {
            future = this.createUser("small_" + userId, 5, this.taskExecutor, done, (Multimap<Integer, SimulationTask>)tasks);
            finishFutures.add(future);
        }
        for (userId = 0; userId < 1; ++userId) {
            future = this.createUser("tiny_" + userId, 1, this.taskExecutor, done, (Multimap<Integer, SimulationTask>)tasks);
            finishFutures.add(future);
        }
        for (i = 0; i < 30; ++i) {
            TimeUnit.MILLISECONDS.sleep(1000L);
            System.out.println(this.taskExecutor);
        }
        tasks.clear();
        for (i = 0; i < 60; ++i) {
            TimeUnit.MILLISECONDS.sleep(1000L);
            System.out.println(this.taskExecutor);
        }
        future = tasks;
        synchronized (future) {
            middleTasks = new TreeMap(tasks.asMap());
        }
        done.set(true);
        Futures.allAsList((Iterable)finishFutures).get(1L, TimeUnit.MINUTES);
        Duration runtime = Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit();
        TaskExecutorSimulator taskExecutorSimulator = this;
        synchronized (taskExecutorSimulator) {
            System.out.println();
            System.out.println("Simulation finished in  " + runtime);
            System.out.println();
            for (Map.Entry entry : middleTasks.entrySet()) {
                Distribution durationDistribution = new Distribution();
                Distribution taskParallelismDistribution = new Distribution();
                for (SimulationTask task : (Collection)entry.getValue()) {
                    long taskStart = Long.MAX_VALUE;
                    long taskEnd = 0L;
                    long totalCpuTime = 0L;
                    for (SimulationSplit split : task.getSplits()) {
                        taskStart = Math.min(taskStart, split.getStartNanos());
                        taskEnd = Math.max(taskEnd, split.getDoneNanos());
                        totalCpuTime += TimeUnit.MILLISECONDS.toNanos(split.getRequiredProcessMillis());
                    }
                    Duration taskDuration = new Duration((double)(taskEnd - taskStart), TimeUnit.NANOSECONDS).convertTo(TimeUnit.MILLISECONDS);
                    durationDistribution.add(taskDuration.toMillis());
                    double taskParallelism = 1.0 * (double)totalCpuTime / (double)(taskEnd - taskStart);
                    taskParallelismDistribution.add((long)(taskParallelism * 100.0));
                }
                System.out.println("Splits " + entry.getKey() + ": Completed " + ((Collection)entry.getValue()).size());
                Map durationPercentiles = durationDistribution.getPercentiles();
                System.out.printf("   wall time ms :: p01 %4s :: p05 %4s :: p10 %4s :: p97 %4s :: p50 %4s :: p75 %4s :: p90 %4s :: p95 %4s :: p99 %4s\n", durationPercentiles.get(0.01), durationPercentiles.get(0.05), durationPercentiles.get(0.1), durationPercentiles.get(0.25), durationPercentiles.get(0.5), durationPercentiles.get(0.75), durationPercentiles.get(0.9), durationPercentiles.get(0.95), durationPercentiles.get(0.99));
                Map parallelismPercentiles = taskParallelismDistribution.getPercentiles();
                System.out.printf("    parallelism :: p99 %4.2f :: p95 %4.2f :: p90 %4.2f :: p75 %4.2f :: p50 %4.2f :: p25 %4.2f :: p10 %4.2f :: p05 %4.2f :: p01 %4.2f\n", (double)((Long)parallelismPercentiles.get(0.99)).longValue() / 100.0, (double)((Long)parallelismPercentiles.get(0.95)).longValue() / 100.0, (double)((Long)parallelismPercentiles.get(0.9)).longValue() / 100.0, (double)((Long)parallelismPercentiles.get(0.75)).longValue() / 100.0, (double)((Long)parallelismPercentiles.get(0.5)).longValue() / 100.0, (double)((Long)parallelismPercentiles.get(0.25)).longValue() / 100.0, (double)((Long)parallelismPercentiles.get(0.1)).longValue() / 100.0, (double)((Long)parallelismPercentiles.get(0.05)).longValue() / 100.0, (double)((Long)parallelismPercentiles.get(0.01)).longValue() / 100.0);
            }
        }
        Thread.sleep(10L);
    }

    private ListenableFuture<?> createUser(final String userId, final int splitsPerTask, final TaskExecutor taskExecutor, final AtomicBoolean done, final Multimap<Integer, SimulationTask> tasks) {
        return this.executor.submit((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                long taskId = 0L;
                while (!done.get()) {
                    SimulationTask task = new SimulationTask(taskExecutor, new TaskId(userId, "0", String.valueOf(taskId++)));
                    task.schedule(splitsPerTask, (ExecutorService)TaskExecutorSimulator.this.executor, new Duration(0.0, TimeUnit.MILLISECONDS)).get();
                    task.destroy();
                    TaskExecutorSimulator.this.printTaskCompletion(task);
                    tasks.put((Object)splitsPerTask, (Object)task);
                }
                return null;
            }
        });
    }

    private synchronized void printTaskCompletion(SimulationTask task) {
    }

    private static class SimulationSplit
    implements SplitRunner {
        private final long requiredProcessMillis;
        private final long processMillisPerCall;
        private final AtomicLong completedProcessMillis = new AtomicLong();
        private final AtomicInteger calls = new AtomicInteger(0);
        private final long createdNanos = System.nanoTime();
        private final AtomicLong startNanos = new AtomicLong(-1L);
        private final AtomicLong doneNanos = new AtomicLong(-1L);
        private final AtomicLong queuedNanos = new AtomicLong();
        private long lastCallNanos = this.createdNanos;

        private SimulationSplit(Duration requiredProcessTime, Duration processTimePerCall) {
            this.requiredProcessMillis = requiredProcessTime.toMillis();
            this.processMillisPerCall = processTimePerCall.toMillis();
        }

        private long getRequiredProcessMillis() {
            return this.requiredProcessMillis;
        }

        private long getCreatedNanos() {
            return this.createdNanos;
        }

        private long getStartNanos() {
            return this.startNanos.get();
        }

        private long getDoneNanos() {
            return this.doneNanos.get();
        }

        private long getQueuedNanos() {
            return this.queuedNanos.get();
        }

        public boolean isFinished() {
            return this.doneNanos.get() >= 0L;
        }

        public void close() {
        }

        public ListenableFuture<?> processFor(Duration duration) throws Exception {
            long callEnd;
            long callStart = System.nanoTime();
            this.startNanos.compareAndSet(-1L, callStart);
            this.calls.incrementAndGet();
            this.queuedNanos.addAndGet(callStart - this.lastCallNanos);
            long processMillis = Math.min(this.requiredProcessMillis - this.completedProcessMillis.get(), this.processMillisPerCall);
            TimeUnit.MILLISECONDS.sleep(processMillis);
            long completedMillis = this.completedProcessMillis.addAndGet(processMillis);
            boolean isFinished = completedMillis >= this.requiredProcessMillis;
            this.lastCallNanos = callEnd = System.nanoTime();
            if (isFinished) {
                this.doneNanos.compareAndSet(-1L, callEnd);
            }
            return Futures.immediateCheckedFuture(null);
        }

        static /* synthetic */ long access$700(SimulationSplit x0) {
            return x0.getQueuedNanos();
        }
    }

    private static class SimulationTask {
        private final long createdNanos = System.nanoTime();
        private final TaskExecutor taskExecutor;
        private final Object taskId;
        private final List<SimulationSplit> splits = new ArrayList<SimulationSplit>();
        private final List<ListenableFuture<?>> splitFutures = new ArrayList();
        private final TaskExecutor.TaskHandle taskHandle;

        private SimulationTask(TaskExecutor taskExecutor, TaskId taskId) {
            this.taskExecutor = taskExecutor;
            this.taskId = taskId;
            this.taskHandle = taskExecutor.addTask(taskId);
        }

        public void destroy() {
            this.taskExecutor.removeTask(this.taskHandle);
        }

        public ListenableFuture<?> schedule(final int splits, ExecutorService executor, final Duration entryDelay) {
            final SettableFuture future = SettableFuture.create();
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (int splitId = 0; splitId < splits; ++splitId) {
                            SimulationSplit split = new SimulationSplit(new Duration(80.0, TimeUnit.MILLISECONDS), new Duration(1.0, TimeUnit.MILLISECONDS));
                            SimulationTask.this.splits.add(split);
                            SimulationTask.this.splitFutures.addAll(SimulationTask.this.taskExecutor.enqueueSplits(SimulationTask.this.taskHandle, false, (List)ImmutableList.of((Object)split)));
                            Thread.sleep(entryDelay.toMillis());
                        }
                        Futures.allAsList((Iterable)SimulationTask.this.splitFutures).get();
                        future.set(null);
                    }
                    catch (Throwable e) {
                        future.setException(e);
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            });
            return future;
        }

        private Object getTaskId() {
            return this.taskId;
        }

        private long getCreatedNanos() {
            return this.createdNanos;
        }

        private List<SimulationSplit> getSplits() {
            return this.splits;
        }

        static /* synthetic */ Object access$800(SimulationTask x0) {
            return x0.getTaskId();
        }
    }
}

