/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.ScheduledSplit;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.TaskSource;
import com.facebook.presto.connector.system.SystemRecordSetProvider;
import com.facebook.presto.execution.SqlTask;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.TestSqlTaskManager;
import com.facebook.presto.execution.TestingPageSourceProvider;
import com.facebook.presto.execution.TestingSplit;
import com.facebook.presto.index.IndexManager;
import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.operator.RecordSinkManager;
import com.facebook.presto.operator.index.IndexJoinLookupStats;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorPageSourceProvider;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.split.PageSourceManager;
import com.facebook.presto.split.PageSourceProvider;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.CompilerConfig;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.TestingColumnHandle;
import com.facebook.presto.sql.planner.TestingTableHandle;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public final class TaskTestUtils {
    public static final ScheduledSplit SPLIT = new ScheduledSplit(0L, new Split("test", (ConnectorSplit)new TestingSplit()));
    public static final PlanNodeId TABLE_SCAN_NODE_ID = new PlanNodeId("tableScan");
    public static final ImmutableList<TaskSource> EMPTY_SOURCES = ImmutableList.of();
    public static final Symbol SYMBOL = new Symbol("column");
    public static final PlanFragment PLAN_FRAGMENT = new PlanFragment(new PlanFragmentId("fragment"), (PlanNode)new TableScanNode(TABLE_SCAN_NODE_ID, new TableHandle("test", (ConnectorTableHandle)new TestingTableHandle()), (List)ImmutableList.of((Object)SYMBOL), (Map)ImmutableMap.of((Object)SYMBOL, (Object)new ColumnHandle("test", (ConnectorColumnHandle)new TestingColumnHandle("column"))), null, Optional.absent()), (Map)ImmutableMap.of((Object)SYMBOL, (Object)VarcharType.VARCHAR), PlanFragment.PlanDistribution.SOURCE, TABLE_SCAN_NODE_ID, PlanFragment.OutputPartitioning.NONE, (List)ImmutableList.of());

    private TaskTestUtils() {
    }

    public static LocalExecutionPlanner createTestingPlanner() {
        MetadataManager metadata = new MetadataManager();
        PageSourceManager pageSourceManager = new PageSourceManager(new SystemRecordSetProvider());
        pageSourceManager.addConnectorPageSourceProvider("test", (ConnectorPageSourceProvider)new TestingPageSourceProvider());
        return new LocalExecutionPlanner((Metadata)metadata, new SqlParser(), (PageSourceProvider)pageSourceManager, new IndexManager(), new RecordSinkManager(), (Supplier)new TestSqlTaskManager.MockExchangeClientSupplier(), new ExpressionCompiler((Metadata)metadata), new IndexJoinLookupStats(), new CompilerConfig(), new TaskManagerConfig());
    }

    public static TaskInfo updateTask(SqlTask sqlTask, List<TaskSource> taskSources, OutputBuffers outputBuffers) {
        return sqlTask.updateTask(SessionTestUtils.TEST_SESSION, PLAN_FRAGMENT, taskSources, outputBuffers);
    }
}

