/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.PagesSerde;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.testing.TestingBlockEncodingManager;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import io.airlift.http.client.testing.TestingResponse;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SliceOutput;
import io.airlift.units.DataSize;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;

public class MockExchangeRequestProcessor
implements Function<Request, Response> {
    private final ConcurrentMap<URI, BlockingQueue<Page>> pagesByLocation = new ConcurrentHashMap<URI, BlockingQueue<Page>>();
    private final ConcurrentMap<URI, Boolean> completeByLocation = new ConcurrentHashMap<URI, Boolean>();
    private final DataSize expectedMaxSize;
    private final ConcurrentMap<URI, Long> tokenByLocation = new ConcurrentHashMap<URI, Long>();

    public MockExchangeRequestProcessor(DataSize expectedMaxSize) {
        this.expectedMaxSize = expectedMaxSize;
    }

    public void addPage(URI location, Page page) {
        Preconditions.checkState((this.completeByLocation.get(location) != Boolean.TRUE ? 1 : 0) != 0, (String)"Location %s is complete", (Object[])new Object[]{location});
        LinkedBlockingQueue<Page> queue = (LinkedBlockingQueue<Page>)this.pagesByLocation.get(location);
        if (queue == null) {
            queue = new LinkedBlockingQueue<Page>();
            LinkedBlockingQueue<Page> existingValue = this.pagesByLocation.putIfAbsent(location, queue);
            queue = existingValue != null ? existingValue : queue;
            this.tokenByLocation.put(location, 0L);
        }
        queue.add(page);
    }

    public void setComplete(URI location) {
        this.completeByLocation.put(location, true);
    }

    public Response apply(Request request) {
        if (request.getMethod().equalsIgnoreCase("DELETE")) {
            return new TestingResponse(HttpStatus.NO_CONTENT, (ListMultimap)ImmutableListMultimap.of(), new byte[0]);
        }
        Assert.assertTrue((!request.getHeaders().get((Object)"X-Presto-Max-Size").isEmpty() ? 1 : 0) != 0);
        DataSize maxSize = DataSize.valueOf((String)request.getHeader("X-Presto-Max-Size"));
        Assert.assertEquals((Object)maxSize, (Object)this.expectedMaxSize);
        RequestLocation requestLocation = new RequestLocation(request.getUri());
        URI location = requestLocation.getLocation();
        BlockingQueue pages = (BlockingQueue)this.pagesByLocation.get(location);
        long token = (Long)this.tokenByLocation.get(location);
        if (this.completeByLocation.get(location) == Boolean.TRUE && (pages == null || pages.isEmpty())) {
            return new TestingResponse(HttpStatus.GONE, (ListMultimap)ImmutableListMultimap.of((Object)"X-Presto-Page-Sequence-Id", (Object)String.valueOf(token), (Object)"X-Presto-Page-End-Sequence-Id", (Object)String.valueOf(token)), new byte[0]);
        }
        if (pages == null) {
            return new TestingResponse(HttpStatus.NO_CONTENT, (ListMultimap)ImmutableListMultimap.of((Object)"X-Presto-Page-Sequence-Id", (Object)String.valueOf(token), (Object)"X-Presto-Page-End-Sequence-Id", (Object)String.valueOf(token)), new byte[0]);
        }
        Assert.assertEquals((long)requestLocation.getSequenceId(), (long)token, (String)"token");
        Page page = null;
        try {
            page = (Page)pages.poll(10L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (page == null) {
            return new TestingResponse(HttpStatus.NO_CONTENT, (ListMultimap)ImmutableListMultimap.of((Object)"X-Presto-Page-Sequence-Id", (Object)String.valueOf(token), (Object)"X-Presto-Page-End-Sequence-Id", (Object)String.valueOf(token)), new byte[0]);
        }
        ArrayList<Page> responsePages = new ArrayList<Page>();
        responsePages.add(page);
        for (long responseSize = page.getSizeInBytes(); responseSize < maxSize.toBytes() && (page = (Page)pages.poll()) != null; responseSize += page.getSizeInBytes()) {
            responsePages.add(page);
        }
        long nextToken = token + (long)responsePages.size();
        this.tokenByLocation.put(location, nextToken);
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(64);
        PagesSerde.writePages((BlockEncodingSerde)TestingBlockEncodingManager.createTestingBlockEncodingManager(), (SliceOutput)sliceOutput, responsePages);
        byte[] bytes = sliceOutput.slice().getBytes();
        return new TestingResponse(HttpStatus.OK, (ListMultimap)ImmutableListMultimap.of((Object)"Content-Type", (Object)"application/X-presto-pages", (Object)"X-Presto-Page-Sequence-Id", (Object)String.valueOf(token), (Object)"X-Presto-Page-End-Sequence-Id", (Object)String.valueOf(nextToken)), bytes);
    }

    private class RequestLocation {
        private final URI location;
        private final long sequenceId;

        public RequestLocation(URI uri) {
            String string = uri.toString();
            int index = string.lastIndexOf(47);
            this.location = URI.create(string.substring(0, index));
            this.sequenceId = Long.parseLong(string.substring(index + 1));
        }

        public URI getLocation() {
            return this.location;
        }

        public long getSequenceId() {
            return this.sequenceId;
        }
    }
}

