/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import java.util.List;

public final class SequencePageBuilder {
    private SequencePageBuilder() {
    }

    public static Page createSequencePage(List<? extends Type> types, int length, int ... initialValues) {
        Block[] blocks = new Block[initialValues.length];
        for (int i = 0; i < blocks.length; ++i) {
            Type type = types.get(i);
            int initialValue = initialValues[i];
            if (type.equals(BigintType.BIGINT)) {
                blocks[i] = BlockAssertions.createLongSequenceBlock(initialValue, initialValue + length);
                continue;
            }
            if (type.equals(DoubleType.DOUBLE)) {
                blocks[i] = BlockAssertions.createDoubleSequenceBlock(initialValue, initialValue + length);
                continue;
            }
            if (type.equals(VarcharType.VARCHAR)) {
                blocks[i] = BlockAssertions.createStringSequenceBlock(initialValue, initialValue + length);
                continue;
            }
            if (type.equals(BooleanType.BOOLEAN)) {
                blocks[i] = BlockAssertions.createBooleanSequenceBlock(initialValue, initialValue + length);
                continue;
            }
            throw new IllegalStateException("Unsupported type " + type);
        }
        return new Page(blocks);
    }
}

