/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.operator.DistinctLimitOperator;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.RowPagesBuilder;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.testing.MaterializedResult;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestDistinctLimitOperator {
    private ExecutorService executor;
    private DriverContext driverContext;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test"));
        this.driverContext = new TaskContext(new TaskId("query", "stage", "task"), (Executor)this.executor, SessionTestUtils.TEST_SESSION).addPipelineContext(true, true).addDriverContext();
    }

    @AfterMethod
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testDistinctLimit() throws Exception {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).addSequencePage(3, 1).addSequencePage(5, 2).build();
        DistinctLimitOperator.DistinctLimitOperatorFactory operatorFactory = new DistinctLimitOperator.DistinctLimitOperatorFactory(0, (List)ImmutableList.of((Object)BigintType.BIGINT), 5L);
        Operator operator = operatorFactory.createOperator(this.driverContext);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1}).row(new Object[]{2}).row(new Object[]{3}).row(new Object[]{4}).row(new Object[]{5}).build();
        OperatorAssertion.assertOperatorEquals(operator, input, expected);
    }

    @Test
    public void testDistinctLimitWithPageAlignment() throws Exception {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).addSequencePage(3, 1).addSequencePage(3, 2).build();
        DistinctLimitOperator.DistinctLimitOperatorFactory operatorFactory = new DistinctLimitOperator.DistinctLimitOperatorFactory(0, (List)ImmutableList.of((Object)BigintType.BIGINT), 3L);
        Operator operator = operatorFactory.createOperator(this.driverContext);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1}).row(new Object[]{2}).row(new Object[]{3}).build();
        OperatorAssertion.assertOperatorEquals(operator, input, expected);
    }

    @Test
    public void testDistinctLimitValuesLessThanLimit() throws Exception {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).addSequencePage(3, 1).addSequencePage(3, 2).build();
        DistinctLimitOperator.DistinctLimitOperatorFactory operatorFactory = new DistinctLimitOperator.DistinctLimitOperatorFactory(0, (List)ImmutableList.of((Object)BigintType.BIGINT), 5L);
        Operator operator = operatorFactory.createOperator(this.driverContext);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1}).row(new Object[]{2}).row(new Object[]{3}).row(new Object[]{4}).build();
        OperatorAssertion.assertOperatorEquals(operator, input, expected);
    }
}

