/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.ExchangeClientConfig;
import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestExchangeClientConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((ExchangeClientConfig)ConfigAssertions.recordDefaults(ExchangeClientConfig.class)).setMaxBufferSize(new DataSize(32.0, DataSize.Unit.MEGABYTE)).setConcurrentRequestMultiplier(3).setMinErrorDuration(new Duration(1.0, TimeUnit.MINUTES)).setMaxResponseSize(new HttpClientConfig().getMaxContentLength()));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"exchange.max-buffer-size", (Object)"1GB").put((Object)"exchange.concurrent-request-multiplier", (Object)"13").put((Object)"exchange.min-error-duration", (Object)"13s").put((Object)"exchange.max-response-size", (Object)"1kB").build();
        ExchangeClientConfig expected = new ExchangeClientConfig().setMaxBufferSize(new DataSize(1.0, DataSize.Unit.GIGABYTE)).setConcurrentRequestMultiplier(13).setMinErrorDuration(new Duration(13.0, TimeUnit.SECONDS)).setMaxResponseSize(new DataSize(1.0, DataSize.Unit.KILOBYTE));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

