/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.MarkDistinctOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.RowPagesBuilder;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.testing.MaterializedResult;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestMarkDistinctOperator {
    private ExecutorService executor;
    private DriverContext driverContext;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test"));
        this.driverContext = new TaskContext(new TaskId("query", "stage", "task"), (Executor)this.executor, SessionTestUtils.TEST_SESSION).addPipelineContext(true, true).addDriverContext();
    }

    @AfterMethod
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testMarkDistinct() throws Exception {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).addSequencePage(100, 0).addSequencePage(100, 0).build();
        MarkDistinctOperator.MarkDistinctOperatorFactory operatorFactory = new MarkDistinctOperator.MarkDistinctOperatorFactory(0, (List)ImmutableList.of((Object)BigintType.BIGINT), (Collection)ImmutableList.of((Object)0));
        Operator operator = operatorFactory.createOperator(this.driverContext);
        MaterializedResult.Builder expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, BooleanType.BOOLEAN});
        for (int i = 0; i < 100; ++i) {
            expected.row(new Object[]{i, true});
            expected.row(new Object[]{i, false});
        }
        OperatorAssertion.assertOperatorEqualsIgnoreOrder(operator, input, expected.build());
    }
}

