/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.Mergeable;
import com.facebook.presto.operator.OperatorStats;
import com.google.common.base.MoreObjects;
import io.airlift.json.JsonCodec;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOperatorStats {
    public static final OperatorStats EXPECTED = new OperatorStats(41, "test", 1L, new Duration(2.0, TimeUnit.NANOSECONDS), new Duration(3.0, TimeUnit.NANOSECONDS), new Duration(4.0, TimeUnit.NANOSECONDS), new DataSize(5.0, DataSize.Unit.BYTE), 6L, 7L, new Duration(8.0, TimeUnit.NANOSECONDS), new Duration(9.0, TimeUnit.NANOSECONDS), new Duration(10.0, TimeUnit.NANOSECONDS), new DataSize(11.0, DataSize.Unit.BYTE), 12L, new Duration(13.0, TimeUnit.NANOSECONDS), 14L, new Duration(15.0, TimeUnit.NANOSECONDS), new Duration(16.0, TimeUnit.NANOSECONDS), new Duration(17.0, TimeUnit.NANOSECONDS), new DataSize(18.0, DataSize.Unit.BYTE), (Object)"19");
    public static final OperatorStats MERGEABLE = new OperatorStats(41, "test", 1L, new Duration(2.0, TimeUnit.NANOSECONDS), new Duration(3.0, TimeUnit.NANOSECONDS), new Duration(4.0, TimeUnit.NANOSECONDS), new DataSize(5.0, DataSize.Unit.BYTE), 6L, 7L, new Duration(8.0, TimeUnit.NANOSECONDS), new Duration(9.0, TimeUnit.NANOSECONDS), new Duration(10.0, TimeUnit.NANOSECONDS), new DataSize(11.0, DataSize.Unit.BYTE), 12L, new Duration(13.0, TimeUnit.NANOSECONDS), 14L, new Duration(15.0, TimeUnit.NANOSECONDS), new Duration(16.0, TimeUnit.NANOSECONDS), new Duration(17.0, TimeUnit.NANOSECONDS), new DataSize(18.0, DataSize.Unit.BYTE), (Object)new LongMergeable(19L));

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(OperatorStats.class);
        String json = codec.toJson((Object)EXPECTED);
        OperatorStats actual = (OperatorStats)codec.fromJson(json);
        TestOperatorStats.assertExpectedOperatorStats(actual);
    }

    public static void assertExpectedOperatorStats(OperatorStats actual) {
        Assert.assertEquals((int)actual.getOperatorId(), (int)41);
        Assert.assertEquals((String)actual.getOperatorType(), (String)"test");
        Assert.assertEquals((long)actual.getAddInputCalls(), (long)1L);
        Assert.assertEquals((Object)actual.getAddInputWall(), (Object)new Duration(2.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getAddInputCpu(), (Object)new Duration(3.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getAddInputUser(), (Object)new Duration(4.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getInputDataSize(), (Object)new DataSize(5.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getInputPositions(), (long)6L);
        Assert.assertEquals((long)actual.getGetOutputCalls(), (long)7L);
        Assert.assertEquals((Object)actual.getGetOutputWall(), (Object)new Duration(8.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getGetOutputCpu(), (Object)new Duration(9.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getGetOutputUser(), (Object)new Duration(10.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getOutputDataSize(), (Object)new DataSize(11.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getOutputPositions(), (long)12L);
        Assert.assertEquals((Object)actual.getBlockedWall(), (Object)new Duration(13.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getFinishCalls(), (long)14L);
        Assert.assertEquals((Object)actual.getFinishWall(), (Object)new Duration(15.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFinishCpu(), (Object)new Duration(16.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFinishUser(), (Object)new Duration(17.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getMemoryReservation(), (Object)new DataSize(18.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getInfo(), (Object)"19");
    }

    @Test
    public void testAdd() {
        OperatorStats actual = EXPECTED.add(new OperatorStats[]{EXPECTED, EXPECTED});
        Assert.assertEquals((int)actual.getOperatorId(), (int)41);
        Assert.assertEquals((String)actual.getOperatorType(), (String)"test");
        Assert.assertEquals((long)actual.getAddInputCalls(), (long)3L);
        Assert.assertEquals((Object)actual.getAddInputWall(), (Object)new Duration(6.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getAddInputCpu(), (Object)new Duration(9.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getAddInputUser(), (Object)new Duration(12.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getInputDataSize(), (Object)new DataSize(15.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getInputPositions(), (long)18L);
        Assert.assertEquals((long)actual.getGetOutputCalls(), (long)21L);
        Assert.assertEquals((Object)actual.getGetOutputWall(), (Object)new Duration(24.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getGetOutputCpu(), (Object)new Duration(27.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getGetOutputUser(), (Object)new Duration(30.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getOutputDataSize(), (Object)new DataSize(33.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getOutputPositions(), (long)36L);
        Assert.assertEquals((Object)actual.getBlockedWall(), (Object)new Duration(39.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getFinishCalls(), (long)42L);
        Assert.assertEquals((Object)actual.getFinishWall(), (Object)new Duration(45.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFinishCpu(), (Object)new Duration(48.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFinishUser(), (Object)new Duration(51.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getMemoryReservation(), (Object)new DataSize(54.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getInfo(), null);
    }

    @Test
    public void testAddMergeable() {
        OperatorStats actual = MERGEABLE.add(new OperatorStats[]{MERGEABLE, MERGEABLE});
        Assert.assertEquals((int)actual.getOperatorId(), (int)41);
        Assert.assertEquals((String)actual.getOperatorType(), (String)"test");
        Assert.assertEquals((long)actual.getAddInputCalls(), (long)3L);
        Assert.assertEquals((Object)actual.getAddInputWall(), (Object)new Duration(6.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getAddInputCpu(), (Object)new Duration(9.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getAddInputUser(), (Object)new Duration(12.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getInputDataSize(), (Object)new DataSize(15.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getInputPositions(), (long)18L);
        Assert.assertEquals((long)actual.getGetOutputCalls(), (long)21L);
        Assert.assertEquals((Object)actual.getGetOutputWall(), (Object)new Duration(24.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getGetOutputCpu(), (Object)new Duration(27.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getGetOutputUser(), (Object)new Duration(30.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getOutputDataSize(), (Object)new DataSize(33.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getOutputPositions(), (long)36L);
        Assert.assertEquals((Object)actual.getBlockedWall(), (Object)new Duration(39.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getFinishCalls(), (long)42L);
        Assert.assertEquals((Object)actual.getFinishWall(), (Object)new Duration(45.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFinishCpu(), (Object)new Duration(48.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFinishUser(), (Object)new Duration(51.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getMemoryReservation(), (Object)new DataSize(54.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getInfo(), (Object)new LongMergeable(57L));
    }

    private static class LongMergeable
    implements Mergeable<LongMergeable> {
        private final long value;

        private LongMergeable(long value) {
            this.value = value;
        }

        public LongMergeable mergeWith(LongMergeable other) {
            return new LongMergeable(this.value + other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            LongMergeable other = (LongMergeable)obj;
            return Objects.equals(this.value, other.value);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", this.value).toString();
        }
    }
}

