/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.RowNumberOperator;
import com.facebook.presto.operator.RowPagesBuilder;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.util.IterableTransformer;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import io.airlift.concurrent.Threads;
import io.airlift.testing.Assertions;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test
public class TestRowNumberOperator {
    private ExecutorService executor;

    @BeforeClass
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test"));
    }

    @AfterClass
    public void tearDown() {
        this.executor.shutdownNow();
    }

    private DriverContext getDriverContext() {
        return new TaskContext(new TaskId("query", "stage", "task"), (Executor)this.executor, SessionTestUtils.TEST_SESSION).addPipelineContext(true, true).addDriverContext();
    }

    @Test
    public void testRowNumberUnPartitioned() throws Exception {
        DriverContext driverContext = this.getDriverContext();
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(1, 0.3).row(2, 0.2).row(3, 0.1).row(3, 0.19).pageBreak().row(1, 0.4).pageBreak().row(1, 0.5).row(1, 0.6).row(2, 0.7).row(2, 0.8).row(2, 0.9).build();
        RowNumberOperator.RowNumberOperatorFactory operatorFactory = new RowNumberOperator.RowNumberOperatorFactory(0, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), Ints.asList((int[])new int[]{1, 0}), Ints.asList((int[])new int[0]), (List)ImmutableList.of(), Optional.absent(), 10);
        Operator operator = operatorFactory.createOperator(driverContext);
        MaterializedResult expectedResult = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT}).row(new Object[]{0.3, 1}).row(new Object[]{0.4, 1}).row(new Object[]{0.5, 1}).row(new Object[]{0.6, 1}).row(new Object[]{0.2, 2}).row(new Object[]{0.7, 2}).row(new Object[]{0.8, 2}).row(new Object[]{0.9, 2}).row(new Object[]{0.1, 3}).row(new Object[]{0.19, 3}).build();
        List<Page> pages = OperatorAssertion.toPages(operator, input);
        Block rowNumberColumn = TestRowNumberOperator.getRowNumberColumn(pages);
        Assert.assertEquals((int)rowNumberColumn.getPositionCount(), (int)10);
        pages = TestRowNumberOperator.stripRowNumberColumn(pages);
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(operator.getOperatorContext().getSession(), (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT), pages);
        Assertions.assertEqualsIgnoreOrder((Iterable)actual.getMaterializedRows(), (Iterable)expectedResult.getMaterializedRows());
    }

    @Test
    public void testRowNumberPartitioned() throws Exception {
        DriverContext driverContext = this.getDriverContext();
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(1, 0.3).row(2, 0.2).row(3, 0.1).row(3, 0.19).pageBreak().row(1, 0.4).pageBreak().row(1, 0.5).row(1, 0.6).row(2, 0.7).row(2, 0.8).row(2, 0.9).build();
        RowNumberOperator.RowNumberOperatorFactory operatorFactory = new RowNumberOperator.RowNumberOperatorFactory(0, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), Ints.asList((int[])new int[]{1, 0}), Ints.asList((int[])new int[]{0}), (List)ImmutableList.of((Object)BigintType.BIGINT), Optional.of((Object)10), 10);
        Operator operator = operatorFactory.createOperator(driverContext);
        MaterializedResult expectedPartition1 = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT}).row(new Object[]{0.3, 1}).row(new Object[]{0.4, 1}).row(new Object[]{0.5, 1}).row(new Object[]{0.6, 1}).build();
        MaterializedResult expectedPartition2 = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT}).row(new Object[]{0.2, 2}).row(new Object[]{0.7, 2}).row(new Object[]{0.8, 2}).row(new Object[]{0.9, 2}).build();
        MaterializedResult expectedPartition3 = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT}).row(new Object[]{0.1, 3}).row(new Object[]{0.19, 3}).build();
        List<Page> pages = OperatorAssertion.toPages(operator, input);
        Block rowNumberColumn = TestRowNumberOperator.getRowNumberColumn(pages);
        Assert.assertEquals((int)rowNumberColumn.getPositionCount(), (int)10);
        pages = TestRowNumberOperator.stripRowNumberColumn(pages);
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(operator.getOperatorContext().getSession(), (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT), pages);
        ImmutableSet actualSet = ImmutableSet.copyOf((Collection)actual.getMaterializedRows());
        ImmutableSet expectedPartition1Set = ImmutableSet.copyOf((Collection)expectedPartition1.getMaterializedRows());
        ImmutableSet expectedPartition2Set = ImmutableSet.copyOf((Collection)expectedPartition2.getMaterializedRows());
        ImmutableSet expectedPartition3Set = ImmutableSet.copyOf((Collection)expectedPartition3.getMaterializedRows());
        Assert.assertEquals((int)Sets.intersection((Set)expectedPartition1Set, (Set)actualSet).size(), (int)4);
        Assert.assertEquals((int)Sets.intersection((Set)expectedPartition2Set, (Set)actualSet).size(), (int)4);
        Assert.assertEquals((int)Sets.intersection((Set)expectedPartition3Set, (Set)actualSet).size(), (int)2);
    }

    @Test
    public void testRowNumberPartitionedLimit() throws Exception {
        DriverContext driverContext = this.getDriverContext();
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(1, 0.3).row(2, 0.2).row(3, 0.1).row(3, 0.19).pageBreak().row(1, 0.4).pageBreak().row(1, 0.5).row(1, 0.6).row(2, 0.7).row(2, 0.8).row(2, 0.9).build();
        RowNumberOperator.RowNumberOperatorFactory operatorFactory = new RowNumberOperator.RowNumberOperatorFactory(0, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), Ints.asList((int[])new int[]{1, 0}), Ints.asList((int[])new int[]{0}), (List)ImmutableList.of((Object)BigintType.BIGINT), Optional.of((Object)3), 10);
        Operator operator = operatorFactory.createOperator(driverContext);
        MaterializedResult expectedPartition1 = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT}).row(new Object[]{0.3, 1}).row(new Object[]{0.4, 1}).row(new Object[]{0.5, 1}).row(new Object[]{0.6, 1}).build();
        MaterializedResult expectedPartition2 = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT}).row(new Object[]{0.2, 2}).row(new Object[]{0.7, 2}).row(new Object[]{0.8, 2}).row(new Object[]{0.9, 2}).build();
        MaterializedResult expectedPartition3 = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT}).row(new Object[]{0.1, 3}).row(new Object[]{0.19, 3}).build();
        List<Page> pages = OperatorAssertion.toPages(operator, input);
        Block rowNumberColumn = TestRowNumberOperator.getRowNumberColumn(pages);
        Assert.assertEquals((int)rowNumberColumn.getPositionCount(), (int)8);
        for (int i = 0; i < rowNumberColumn.getPositionCount(); ++i) {
            Assert.assertTrue((rowNumberColumn.getLong(i, 0) <= 3L ? 1 : 0) != 0);
        }
        pages = TestRowNumberOperator.stripRowNumberColumn(pages);
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(operator.getOperatorContext().getSession(), (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT), pages);
        ImmutableSet actualSet = ImmutableSet.copyOf((Collection)actual.getMaterializedRows());
        ImmutableSet expectedPartition1Set = ImmutableSet.copyOf((Collection)expectedPartition1.getMaterializedRows());
        ImmutableSet expectedPartition2Set = ImmutableSet.copyOf((Collection)expectedPartition2.getMaterializedRows());
        ImmutableSet expectedPartition3Set = ImmutableSet.copyOf((Collection)expectedPartition3.getMaterializedRows());
        Assert.assertEquals((int)Sets.intersection((Set)expectedPartition1Set, (Set)actualSet).size(), (int)3);
        Assert.assertEquals((int)Sets.intersection((Set)expectedPartition2Set, (Set)actualSet).size(), (int)3);
        Assert.assertEquals((int)Sets.intersection((Set)expectedPartition3Set, (Set)actualSet).size(), (int)2);
    }

    @Test
    public void testRowNumberUnPartitionedLimit() throws Exception {
        DriverContext driverContext = this.getDriverContext();
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(1, 0.3).row(2, 0.2).row(3, 0.1).row(3, 0.19).pageBreak().row(1, 0.4).pageBreak().row(1, 0.5).row(1, 0.6).row(2, 0.7).row(2, 0.8).row(2, 0.9).build();
        RowNumberOperator.RowNumberOperatorFactory operatorFactory = new RowNumberOperator.RowNumberOperatorFactory(0, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), Ints.asList((int[])new int[]{1, 0}), Ints.asList((int[])new int[0]), (List)ImmutableList.of(), Optional.of((Object)3), 10);
        Operator operator = operatorFactory.createOperator(driverContext);
        MaterializedResult expectedRows = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{0.3, 1}).row(new Object[]{0.2, 2}).row(new Object[]{0.1, 3}).row(new Object[]{0.19, 3}).row(new Object[]{0.4, 1}).row(new Object[]{0.5, 1}).row(new Object[]{0.6, 1}).row(new Object[]{0.7, 2}).row(new Object[]{0.8, 2}).row(new Object[]{0.9, 2}).build();
        List<Page> pages = OperatorAssertion.toPages(operator, input);
        Block rowNumberColumn = TestRowNumberOperator.getRowNumberColumn(pages);
        Assert.assertEquals((int)rowNumberColumn.getPositionCount(), (int)3);
        pages = TestRowNumberOperator.stripRowNumberColumn(pages);
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(operator.getOperatorContext().getSession(), (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT), pages);
        Assert.assertEquals((int)actual.getMaterializedRows().size(), (int)3);
        ImmutableSet actualSet = ImmutableSet.copyOf((Collection)actual.getMaterializedRows());
        ImmutableSet expectedRowsSet = ImmutableSet.copyOf((Collection)expectedRows.getMaterializedRows());
        Assert.assertEquals((int)Sets.intersection((Set)expectedRowsSet, (Set)actualSet).size(), (int)3);
    }

    private static Block getRowNumberColumn(List<Page> pages) {
        BlockBuilder builder = BigintType.BIGINT.createBlockBuilder(new BlockBuilderStatus());
        for (Page page : pages) {
            int rowNumberChannel = page.getChannelCount() - 1;
            for (int i = 0; i < page.getPositionCount(); ++i) {
                BigintType.BIGINT.writeLong(builder, page.getBlock(rowNumberChannel).getLong(i, 0));
            }
        }
        return builder.build();
    }

    private static List<Page> stripRowNumberColumn(List<Page> input) {
        return IterableTransformer.on(input).transform((Function)new Function<Page, Page>(){

            public Page apply(Page page) {
                Block[] blocks = Arrays.copyOf(page.getBlocks(), page.getChannelCount() - 1);
                return new Page(blocks);
            }
        }).list();
    }
}

