/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TestingSplit;
import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.CursorProcessor;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.FilterFunctions;
import com.facebook.presto.operator.GenericCursorProcessor;
import com.facebook.presto.operator.GenericPageProcessor;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.PageProcessor;
import com.facebook.presto.operator.ProjectionFunctions;
import com.facebook.presto.operator.ScanFilterAndProjectOperator;
import com.facebook.presto.operator.SequencePageBuilder;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.index.PageRecordSet;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.FixedPageSource;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.RecordPageSource;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.split.PageSourceProvider;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.testing.MaterializedResult;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestScanFilterAndProjectOperator {
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test"));

    @Test
    public void testPageSource() throws Exception {
        final Page input = SequencePageBuilder.createSequencePage((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), 10000, 0);
        DriverContext driverContext = this.newDriverContext();
        ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory factory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("0"), new PageSourceProvider(){

            public ConnectorPageSource createPageSource(Split split, List<ColumnHandle> columns) {
                return new FixedPageSource((Iterable)ImmutableList.of((Object)input));
            }
        }, (CursorProcessor)new GenericCursorProcessor(FilterFunctions.TRUE_FUNCTION, (Iterable)ImmutableList.of((Object)ProjectionFunctions.singleColumn((Type)VarcharType.VARCHAR, (int)0))), (PageProcessor)new GenericPageProcessor(FilterFunctions.TRUE_FUNCTION, (Iterable)ImmutableList.of((Object)ProjectionFunctions.singleColumn((Type)VarcharType.VARCHAR, (int)0))), (Iterable)ImmutableList.of(), (List)ImmutableList.of((Object)VarcharType.VARCHAR));
        SourceOperator operator = factory.createOperator(driverContext);
        operator.addSplit(new Split("test", (ConnectorSplit)new TestingSplit()));
        operator.noMoreSplits();
        MaterializedResult expected = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), (List<Page>)ImmutableList.of((Object)input));
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), TestScanFilterAndProjectOperator.toPages((Operator)operator));
        Assert.assertEquals((int)actual.getRowCount(), (int)expected.getRowCount());
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testRecordCursorSource() throws Exception {
        final Page input = SequencePageBuilder.createSequencePage((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), 10000, 0);
        DriverContext driverContext = this.newDriverContext();
        ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory factory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("0"), new PageSourceProvider(){

            public ConnectorPageSource createPageSource(Split split, List<ColumnHandle> columns) {
                return new RecordPageSource((RecordSet)new PageRecordSet((List)ImmutableList.of((Object)VarcharType.VARCHAR), input));
            }
        }, (CursorProcessor)new GenericCursorProcessor(FilterFunctions.TRUE_FUNCTION, (Iterable)ImmutableList.of((Object)ProjectionFunctions.singleColumn((Type)VarcharType.VARCHAR, (int)0))), (PageProcessor)new GenericPageProcessor(FilterFunctions.TRUE_FUNCTION, (Iterable)ImmutableList.of((Object)ProjectionFunctions.singleColumn((Type)VarcharType.VARCHAR, (int)0))), (Iterable)ImmutableList.of(), (List)ImmutableList.of((Object)VarcharType.VARCHAR));
        SourceOperator operator = factory.createOperator(driverContext);
        operator.addSplit(new Split("test", (ConnectorSplit)new TestingSplit()));
        operator.noMoreSplits();
        MaterializedResult expected = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), (List<Page>)ImmutableList.of((Object)input));
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), TestScanFilterAndProjectOperator.toPages((Operator)operator));
        Assert.assertEquals((int)actual.getRowCount(), (int)expected.getRowCount());
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    public static List<Page> toPages(Operator operator) {
        ImmutableList.Builder outputPages = ImmutableList.builder();
        int nullPages = 0;
        while (!operator.isFinished()) {
            Page outputPage = operator.getOutput();
            if (outputPage == null) {
                Assert.assertTrue((nullPages < 1000000 ? 1 : 0) != 0, (String)"Too many null pages; infinite loop?");
                ++nullPages;
                continue;
            }
            outputPages.add((Object)outputPage);
            nullPages = 0;
        }
        return outputPages.build();
    }

    private DriverContext newDriverContext() {
        return new TaskContext(new TaskId("query", "stage", "task"), (Executor)this.executor, SessionTestUtils.TEST_SESSION).addPipelineContext(true, true).addDriverContext();
    }
}

