/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.testing.RunLengthEncodedBlock;
import com.facebook.presto.type.TypeRegistry;
import com.facebook.presto.type.TypeUtils;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.testng.annotations.Test;

public abstract class AbstractTestAggregationFunction {
    protected final FunctionRegistry functionRegistry = new FunctionRegistry((TypeManager)new TypeRegistry(), true);

    public abstract Block getSequenceBlock(int var1, int var2);

    protected final InternalAggregationFunction getFunction() {
        return this.functionRegistry.resolveFunction(QualifiedName.of((String)this.getFunctionName(), (String[])new String[0]), Lists.transform(this.getFunctionParameterTypes(), (Function)TypeUtils.typeSignatureParser()), this.isApproximate()).getAggregationFunction();
    }

    protected abstract String getFunctionName();

    protected abstract List<String> getFunctionParameterTypes();

    protected boolean isApproximate() {
        return false;
    }

    public abstract Object getExpectedValue(int var1, int var2);

    public double getConfidence() {
        return 1.0;
    }

    public Object getExpectedValueIncludingNulls(int start, int length, int lengthIncludingNulls) {
        return this.getExpectedValue(start, length);
    }

    @Test
    public void testNoPositions() {
        this.testAggregation(this.getExpectedValue(0, 0), this.getSequenceBlock(0, 0));
    }

    @Test
    public void testSinglePosition() {
        this.testAggregation(this.getExpectedValue(0, 1), this.getSequenceBlock(0, 1));
    }

    @Test
    public void testMultiplePositions() {
        this.testAggregation(this.getExpectedValue(0, 5), this.getSequenceBlock(0, 5));
    }

    @Test
    public void testAllPositionsNull() throws Exception {
        List parameterTypes = this.getFunction().getParameterTypes();
        if (parameterTypes.isEmpty()) {
            return;
        }
        Block nullValueBlock = ((Type)parameterTypes.get(0)).createBlockBuilder(new BlockBuilderStatus()).appendNull().build();
        RunLengthEncodedBlock block = new RunLengthEncodedBlock(nullValueBlock, 10);
        this.testAggregation(this.getExpectedValueIncludingNulls(0, 0, 10), (Block)block);
    }

    @Test
    public void testMixedNullAndNonNullPositions() {
        List parameterTypes = this.getFunction().getParameterTypes();
        if (parameterTypes.isEmpty()) {
            return;
        }
        Block alternatingNullsBlock = this.createAlternatingNullsBlock((Type)parameterTypes.get(0), this.getSequenceBlock(0, 10));
        this.testAggregation(this.getExpectedValueIncludingNulls(0, 10, 20), alternatingNullsBlock);
    }

    @Test
    public void testNegativeOnlyValues() {
        this.testAggregation(this.getExpectedValue(-10, 5), this.getSequenceBlock(-10, 5));
    }

    @Test
    public void testPositiveOnlyValues() {
        this.testAggregation(this.getExpectedValue(2, 4), this.getSequenceBlock(2, 4));
    }

    public Block createAlternatingNullsBlock(Type type, Block sequenceBlock) {
        BlockBuilder blockBuilder = type.createBlockBuilder(new BlockBuilderStatus());
        for (int position = 0; position < sequenceBlock.getPositionCount(); ++position) {
            blockBuilder.appendNull();
            type.appendTo(sequenceBlock, position, blockBuilder);
        }
        return blockBuilder.build();
    }

    protected void testAggregation(Object expectedValue, Block block) {
        AggregationTestUtils.assertAggregation(this.getFunction(), this.getConfidence(), expectedValue, block.getPositionCount(), block);
    }
}

