/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractTestApproximateAggregationFunction;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.util.IterableTransformer;
import com.google.common.base.Predicates;
import java.util.List;

public class TestApproximateLongSumAggregation
extends AbstractTestApproximateAggregationFunction {
    @Override
    protected Type getType() {
        return BigintType.BIGINT;
    }

    @Override
    protected Double getExpectedValue(List<Number> values) {
        List nonNull = IterableTransformer.on(values).select(Predicates.notNull()).list();
        if (nonNull.isEmpty()) {
            return null;
        }
        double sum = 0.0;
        for (Number value : nonNull) {
            sum += (double)value.longValue();
        }
        return sum;
    }

    @Override
    protected String getFunctionName() {
        return "sum";
    }
}

