/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.type.TypeRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import io.airlift.json.ObjectMapperProvider;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestNumericHistogramAggregation {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get();
    private final AccumulatorFactory factory;
    private final Page input;

    public TestNumericHistogramAggregation() {
        FunctionRegistry functionRegistry = new FunctionRegistry((TypeManager)new TypeRegistry(), true);
        InternalAggregationFunction function = functionRegistry.resolveFunction(QualifiedName.of((String)"numeric_histogram", (String[])new String[0]), (List)ImmutableList.of((Object)BigintType.BIGINT.getTypeSignature(), (Object)DoubleType.DOUBLE.getTypeSignature(), (Object)DoubleType.DOUBLE.getTypeSignature()), false).getAggregationFunction();
        this.factory = function.bind((List)ImmutableList.of((Object)0, (Object)1, (Object)2), Optional.absent(), Optional.absent(), 1.0);
        int numberOfBuckets = 10;
        PageBuilder builder = new PageBuilder((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE));
        for (int i = 0; i < 100; ++i) {
            BigintType.BIGINT.writeLong(builder.getBlockBuilder(0), (long)numberOfBuckets);
            DoubleType.DOUBLE.writeDouble(builder.getBlockBuilder(1), (double)i);
            DoubleType.DOUBLE.writeDouble(builder.getBlockBuilder(2), 1.0);
        }
        this.input = builder.build();
    }

    @Test
    public void test() throws Exception {
        Accumulator singleStep = this.factory.createAccumulator();
        singleStep.addInput(this.input);
        Block expected = singleStep.evaluateFinal();
        Accumulator partialStep = this.factory.createAccumulator();
        partialStep.addInput(this.input);
        Accumulator finalStep = this.factory.createAccumulator();
        finalStep.addIntermediate(partialStep.evaluateIntermediate());
        Block actual = finalStep.evaluateFinal();
        Assert.assertEquals(TestNumericHistogramAggregation.extractSingleValue(actual), TestNumericHistogramAggregation.extractSingleValue(expected));
    }

    @Test
    public void testMerge() throws Exception {
        Accumulator singleStep = this.factory.createAccumulator();
        singleStep.addInput(this.input);
        Block singleStepResult = singleStep.evaluateFinal();
        Accumulator partialStep = this.factory.createAccumulator();
        partialStep.addInput(this.input);
        Accumulator finalStep = this.factory.createAccumulator();
        Block intermediate = partialStep.evaluateIntermediate();
        finalStep.addIntermediate(intermediate);
        finalStep.addIntermediate(intermediate);
        Block actual = finalStep.evaluateFinal();
        Map expected = Maps.transformValues(TestNumericHistogramAggregation.extractSingleValue(singleStepResult), (Function)new Function<Double, Double>(){

            public Double apply(Double input) {
                return input * 2.0;
            }
        });
        Assert.assertEquals(TestNumericHistogramAggregation.extractSingleValue(actual), (Map)expected);
    }

    @Test
    public void testNull() throws Exception {
        Accumulator accumulator = this.factory.createAccumulator();
        Block result = accumulator.evaluateFinal();
        Assert.assertTrue((result.getPositionCount() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)result.isNull(0));
    }

    private static Map<String, Double> extractSingleValue(Block block) throws IOException {
        String json = block.getSlice(0, 0, block.getLength(0)).toStringUtf8();
        return (Map)OBJECT_MAPPER.readValue(json, Map.class);
    }
}

