/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.state.AccumulatorState;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateFactory;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateSerializer;
import com.facebook.presto.operator.aggregation.state.LongState;
import com.facebook.presto.operator.aggregation.state.NullableBigintState;
import com.facebook.presto.operator.aggregation.state.StateCompiler;
import com.facebook.presto.operator.aggregation.state.VarianceState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.VarcharType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStateCompiler {
    @Test
    public void testPrimitiveNullableLongSerialization() {
        StateCompiler compiler = new StateCompiler();
        AccumulatorStateFactory factory = compiler.generateStateFactory(NullableBigintState.class);
        AccumulatorStateSerializer serializer = compiler.generateStateSerializer(NullableBigintState.class);
        NullableBigintState state = (NullableBigintState)factory.createSingleState();
        NullableBigintState deserializedState = (NullableBigintState)factory.createSingleState();
        state.setLong(2L);
        state.setNull(false);
        BlockBuilder builder = BigintType.BIGINT.createBlockBuilder(new BlockBuilderStatus());
        serializer.serialize((Object)state, builder);
        state.setNull(true);
        serializer.serialize((Object)state, builder);
        Block block = builder.build();
        Assert.assertEquals((long)BigintType.BIGINT.getLong(block, 0), (long)state.getLong());
        serializer.deserialize(block, 0, (Object)deserializedState);
        Assert.assertEquals((long)deserializedState.getLong(), (long)state.getLong());
        Assert.assertEquals((boolean)block.isNull(1), (boolean)state.isNull());
        serializer.deserialize(block, 1, (Object)deserializedState);
        Assert.assertEquals((boolean)deserializedState.isNull(), (boolean)state.isNull());
    }

    @Test
    public void testPrimitiveLongSerialization() {
        StateCompiler compiler = new StateCompiler();
        AccumulatorStateFactory factory = compiler.generateStateFactory(LongState.class);
        AccumulatorStateSerializer serializer = compiler.generateStateSerializer(LongState.class);
        LongState state = (LongState)factory.createSingleState();
        LongState deserializedState = (LongState)factory.createSingleState();
        state.setLong(2L);
        BlockBuilder builder = BigintType.BIGINT.createBlockBuilder(new BlockBuilderStatus());
        serializer.serialize((Object)state, builder);
        Block block = builder.build();
        Assert.assertEquals((long)BigintType.BIGINT.getLong(block, 0), (long)state.getLong());
        serializer.deserialize(block, 0, (Object)deserializedState);
        Assert.assertEquals((long)deserializedState.getLong(), (long)state.getLong());
    }

    @Test
    public void testGetSerializedType() {
        StateCompiler compiler = new StateCompiler();
        AccumulatorStateSerializer serializer = compiler.generateStateSerializer(LongState.class);
        Assert.assertEquals((Object)serializer.getSerializedType(), (Object)BigintType.BIGINT);
    }

    @Test
    public void testPrimitiveBooleanSerialization() {
        StateCompiler compiler = new StateCompiler();
        AccumulatorStateFactory factory = compiler.generateStateFactory(BooleanState.class);
        AccumulatorStateSerializer serializer = compiler.generateStateSerializer(BooleanState.class);
        BooleanState state = (BooleanState)factory.createSingleState();
        BooleanState deserializedState = (BooleanState)factory.createSingleState();
        state.setBoolean(true);
        BlockBuilder builder = BooleanType.BOOLEAN.createBlockBuilder(new BlockBuilderStatus());
        serializer.serialize((Object)state, builder);
        Block block = builder.build();
        serializer.deserialize(block, 0, (Object)deserializedState);
        Assert.assertEquals((boolean)deserializedState.getBoolean(), (boolean)state.getBoolean());
    }

    @Test
    public void testPrimitiveByteSerialization() {
        StateCompiler compiler = new StateCompiler();
        AccumulatorStateFactory factory = compiler.generateStateFactory(ByteState.class);
        AccumulatorStateSerializer serializer = compiler.generateStateSerializer(ByteState.class);
        ByteState state = (ByteState)factory.createSingleState();
        ByteState deserializedState = (ByteState)factory.createSingleState();
        state.setByte((byte)3);
        BlockBuilder builder = BigintType.BIGINT.createBlockBuilder(new BlockBuilderStatus());
        serializer.serialize((Object)state, builder);
        Block block = builder.build();
        serializer.deserialize(block, 0, (Object)deserializedState);
        Assert.assertEquals((byte)deserializedState.getByte(), (byte)state.getByte());
    }

    @Test
    public void testVarianceStateSerialization() {
        StateCompiler compiler = new StateCompiler();
        AccumulatorStateFactory factory = compiler.generateStateFactory(VarianceState.class);
        AccumulatorStateSerializer serializer = compiler.generateStateSerializer(VarianceState.class);
        VarianceState singleState = (VarianceState)factory.createSingleState();
        VarianceState deserializedState = (VarianceState)factory.createSingleState();
        singleState.setMean(1.0);
        singleState.setCount(2L);
        singleState.setM2(3.0);
        BlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(new BlockBuilderStatus());
        serializer.serialize((Object)singleState, builder);
        Block block = builder.build();
        serializer.deserialize(block, 0, (Object)deserializedState);
        Assert.assertEquals((long)deserializedState.getCount(), (long)singleState.getCount());
        Assert.assertEquals((Object)deserializedState.getMean(), (Object)singleState.getMean());
        Assert.assertEquals((Object)deserializedState.getM2(), (Object)singleState.getM2());
    }

    @Test
    public void testComplexSerialization() {
        StateCompiler compiler = new StateCompiler();
        AccumulatorStateFactory factory = compiler.generateStateFactory(TestComplexState.class);
        AccumulatorStateSerializer serializer = compiler.generateStateSerializer(TestComplexState.class);
        TestComplexState singleState = (TestComplexState)factory.createSingleState();
        TestComplexState deserializedState = (TestComplexState)factory.createSingleState();
        singleState.setBoolean(true);
        singleState.setLong(1L);
        singleState.setDouble(2.0);
        singleState.setByte((byte)3);
        BlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(new BlockBuilderStatus());
        serializer.serialize((Object)singleState, builder);
        Block block = builder.build();
        serializer.deserialize(block, 0, (Object)deserializedState);
        Assert.assertEquals((boolean)deserializedState.getBoolean(), (boolean)singleState.getBoolean());
        Assert.assertEquals((long)deserializedState.getLong(), (long)singleState.getLong());
        Assert.assertEquals((Object)deserializedState.getDouble(), (Object)singleState.getDouble());
        Assert.assertEquals((byte)deserializedState.getByte(), (byte)singleState.getByte());
    }

    public static interface ByteState
    extends AccumulatorState {
        public byte getByte();

        public void setByte(byte var1);
    }

    public static interface BooleanState
    extends AccumulatorState {
        public boolean getBoolean();

        public void setBoolean(boolean var1);
    }

    public static interface TestComplexState
    extends AccumulatorState {
        public double getDouble();

        public void setDouble(double var1);

        public boolean getBoolean();

        public void setBoolean(boolean var1);

        public long getLong();

        public void setLong(long var1);

        public byte getByte();

        public void setByte(byte var1);
    }
}

