/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.operator.PageAssertions;
import com.facebook.presto.operator.RowPagesBuilder;
import com.facebook.presto.operator.index.TupleFilterProcessor;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTupleFilterProcessor {
    @Test
    public void testFullPageFilter() throws Exception {
        Page tuplePage = (Page)Iterables.getOnlyElement(RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, DoubleType.DOUBLE}).row(1L, "a", 0.1).build());
        ImmutableList outputTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BooleanType.BOOLEAN, (Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE);
        TupleFilterProcessor tupleFilterProcessor = new TupleFilterProcessor(tuplePage, (List)outputTypes, new int[]{1, 0, 3});
        Page inputPage = (Page)Iterables.getOnlyElement(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)outputTypes).row("a", 1L, true, 0.1, 0.0).row("b", 1L, true, 0.1, 2.0).row("a", 1L, false, 0.1, 2.0).row("a", 0L, false, 0.2, 0.2).build());
        ConnectorSession session = new ConnectorSession("user", TimeZoneKey.UTC_KEY, Locale.ENGLISH, 0L, (Map)ImmutableMap.of());
        PageBuilder pageBuilder = new PageBuilder((List)outputTypes);
        int end = tupleFilterProcessor.process(session, inputPage, 0, inputPage.getPositionCount(), pageBuilder);
        Page actualPage = pageBuilder.build();
        Page expectedPage = (Page)Iterables.getOnlyElement(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)outputTypes).row("a", 1L, true, 0.1, 0.0).row("a", 1L, false, 0.1, 2.0).build());
        Assert.assertEquals((int)end, (int)inputPage.getPositionCount());
        PageAssertions.assertPageEquals((List<? extends Type>)outputTypes, actualPage, expectedPage);
    }

    @Test
    public void testPartialPageFilter() throws Exception {
        Page tuplePage = (Page)Iterables.getOnlyElement(RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, DoubleType.DOUBLE}).row(1L, "a", 0.1).build());
        ImmutableList outputTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BooleanType.BOOLEAN, (Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE);
        TupleFilterProcessor tupleFilterProcessor = new TupleFilterProcessor(tuplePage, (List)outputTypes, new int[]{1, 0, 3});
        Page inputPage = (Page)Iterables.getOnlyElement(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)outputTypes).row("a", 1L, true, 0.1, 0.0).row("b", 1L, true, 0.1, 2.0).row("a", 1L, false, 0.1, 2.0).row("a", 0L, false, 0.2, 0.2).row("a", 1L, false, 0.1, 3.0).build());
        ConnectorSession session = new ConnectorSession("user", TimeZoneKey.UTC_KEY, Locale.ENGLISH, 0L, (Map)ImmutableMap.of());
        PageBuilder pageBuilder = new PageBuilder((List)outputTypes);
        int end = tupleFilterProcessor.process(session, inputPage, 1, 4, pageBuilder);
        Page actualPage = pageBuilder.build();
        Page expectedPage = (Page)Iterables.getOnlyElement(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)outputTypes).row("a", 1L, false, 0.1, 2.0).build());
        Assert.assertEquals((int)end, (int)4);
        PageAssertions.assertPageEquals((List<? extends Type>)outputTypes, actualPage, expectedPage);
    }
}

