/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.scalar.ColorFunctions;
import com.google.common.base.Charsets;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.charset.Charset;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestColorFunctions {
    @Test
    public void testParseRgb() throws Exception {
        Assert.assertEquals((int)ColorFunctions.parseRgb((Slice)TestColorFunctions.toSlice("#000")), (int)0);
        Assert.assertEquals((int)ColorFunctions.parseRgb((Slice)TestColorFunctions.toSlice("#FFF")), (int)0xFFFFFF);
        Assert.assertEquals((int)ColorFunctions.parseRgb((Slice)TestColorFunctions.toSlice("#F00")), (int)0xFF0000);
        Assert.assertEquals((int)ColorFunctions.parseRgb((Slice)TestColorFunctions.toSlice("#0F0")), (int)65280);
        Assert.assertEquals((int)ColorFunctions.parseRgb((Slice)TestColorFunctions.toSlice("#00F")), (int)255);
        Assert.assertEquals((int)ColorFunctions.parseRgb((Slice)TestColorFunctions.toSlice("#700")), (int)0x770000);
        Assert.assertEquals((int)ColorFunctions.parseRgb((Slice)TestColorFunctions.toSlice("#070")), (int)30464);
        Assert.assertEquals((int)ColorFunctions.parseRgb((Slice)TestColorFunctions.toSlice("#007")), (int)119);
        Assert.assertEquals((int)ColorFunctions.parseRgb((Slice)TestColorFunctions.toSlice("#cde")), (int)0xCCDDEE);
    }

    @Test
    public void testGetComponent() throws Exception {
        Assert.assertEquals((int)ColorFunctions.getRed((long)ColorFunctions.parseRgb((Slice)TestColorFunctions.toSlice("#789"))), (int)119);
        Assert.assertEquals((int)ColorFunctions.getGreen((long)ColorFunctions.parseRgb((Slice)TestColorFunctions.toSlice("#789"))), (int)136);
        Assert.assertEquals((int)ColorFunctions.getBlue((long)ColorFunctions.parseRgb((Slice)TestColorFunctions.toSlice("#789"))), (int)153);
    }

    @Test
    public void testToRgb() throws Exception {
        Assert.assertEquals((long)ColorFunctions.rgb((long)255L, (long)0L, (long)0L), (long)0xFF0000L);
        Assert.assertEquals((long)ColorFunctions.rgb((long)0L, (long)255L, (long)0L), (long)65280L);
        Assert.assertEquals((long)ColorFunctions.rgb((long)0L, (long)0L, (long)255L), (long)255L);
    }

    @Test
    public void testColor() throws Exception {
        Assert.assertEquals((long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("black")), (long)-1L);
        Assert.assertEquals((long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("red")), (long)-2L);
        Assert.assertEquals((long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("green")), (long)-3L);
        Assert.assertEquals((long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("yellow")), (long)-4L);
        Assert.assertEquals((long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("blue")), (long)-5L);
        Assert.assertEquals((long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("magenta")), (long)-6L);
        Assert.assertEquals((long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("cyan")), (long)-7L);
        Assert.assertEquals((long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("white")), (long)-8L);
        Assert.assertEquals((long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#f00")), (long)0xFF0000L);
        Assert.assertEquals((long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#0f0")), (long)65280L);
        Assert.assertEquals((long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#00f")), (long)255L);
    }

    @Test
    public void testRenderString() throws Exception {
        Assert.assertEquals((Object)ColorFunctions.render((Slice)TestColorFunctions.toSlice("hello"), (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("red"))), (Object)TestColorFunctions.toSlice("\u001b[38;5;1mhello\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.render((Slice)TestColorFunctions.toSlice("hello"), (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#f00"))), (Object)TestColorFunctions.toSlice("\u001b[38;5;196mhello\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.render((Slice)TestColorFunctions.toSlice("hello"), (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#0f0"))), (Object)TestColorFunctions.toSlice("\u001b[38;5;46mhello\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.render((Slice)TestColorFunctions.toSlice("hello"), (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#00f"))), (Object)TestColorFunctions.toSlice("\u001b[38;5;21mhello\u001b[0m"));
    }

    @Test
    public void testRenderLong() throws Exception {
        Assert.assertEquals((Object)ColorFunctions.render((long)1234L, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("red"))), (Object)TestColorFunctions.toSlice("\u001b[38;5;1m1234\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.render((long)1234L, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#f00"))), (Object)TestColorFunctions.toSlice("\u001b[38;5;196m1234\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.render((long)1234L, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#0f0"))), (Object)TestColorFunctions.toSlice("\u001b[38;5;46m1234\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.render((long)1234L, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#00f"))), (Object)TestColorFunctions.toSlice("\u001b[38;5;21m1234\u001b[0m"));
    }

    @Test
    public void testRenderDouble() throws Exception {
        Assert.assertEquals((Object)ColorFunctions.render((double)1234.5678, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("red"))), (Object)TestColorFunctions.toSlice("\u001b[38;5;1m1234.5678\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.render((double)1234.5678, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#f00"))), (Object)TestColorFunctions.toSlice("\u001b[38;5;196m1234.5678\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.render((double)1234.5678, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#0f0"))), (Object)TestColorFunctions.toSlice("\u001b[38;5;46m1234.5678\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.render((double)1234.5678, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#00f"))), (Object)TestColorFunctions.toSlice("\u001b[38;5;21m1234.5678\u001b[0m"));
    }

    @Test
    public void testInterpolate() throws Exception {
        Assert.assertEquals((long)ColorFunctions.color((double)0.0, (double)0.0, (double)255.0, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#000")), (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#fff"))), (long)0L);
        Assert.assertEquals((long)ColorFunctions.color((double)128.0, (double)0.0, (double)255.0, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#000")), (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#fff"))), (long)0x808080L);
        Assert.assertEquals((long)ColorFunctions.color((double)255.0, (double)0.0, (double)255.0, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#000")), (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#fff"))), (long)0xFFFFFFL);
        Assert.assertEquals((long)ColorFunctions.color((double)0.0, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#000")), (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#fff"))), (long)0L);
        Assert.assertEquals((long)ColorFunctions.color((double)0.5, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#000")), (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#fff"))), (long)0x808080L);
        Assert.assertEquals((long)ColorFunctions.color((double)1.0, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#000")), (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#fff"))), (long)0xFFFFFFL);
    }

    private static Slice toSlice(String string) {
        return Slices.copiedBuffer((String)string, (Charset)Charsets.UTF_8);
    }
}

