/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.operator.window.WindowAssertions;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.MaterializedResult;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestWindowFunctions {
    private final LocalQueryRunner queryRunner = new LocalQueryRunner(SessionTestUtils.TEST_SESSION);

    @AfterClass
    public void tearDown() {
        this.queryRunner.close();
    }

    @Test
    public void testRowNumber() {
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{1, "O", 1}).row(new Object[]{2, "O", 2}).row(new Object[]{3, "F", 3}).row(new Object[]{4, "O", 4}).row(new Object[]{5, "F", 5}).row(new Object[]{6, "F", 6}).row(new Object[]{7, "O", 7}).row(new Object[]{32, "O", 8}).row(new Object[]{33, "F", 9}).row(new Object[]{34, "O", 10}).build();
        MaterializedResult expectedWithNulls = MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{1, null, 1}).row(new Object[]{3, "F", 2}).row(new Object[]{5, "F", 3}).row(new Object[]{7, null, 4}).row(new Object[]{34, "O", 5}).row(new Object[]{null, "F", 6}).row(new Object[]{null, "F", 7}).row(new Object[]{null, "O", 8}).row(new Object[]{null, null, 9}).row(new Object[]{null, null, 10}).build();
        WindowAssertions.assertWindowQuery("row_number() OVER ()", expected, this.queryRunner);
        WindowAssertions.assertWindowQuery("row_number() OVER (ORDER BY orderkey)", expected, this.queryRunner);
        WindowAssertions.assertWindowQueryWithNulls("row_number() OVER ()", expectedWithNulls, this.queryRunner);
        WindowAssertions.assertWindowQueryWithNulls("row_number() OVER (ORDER BY orderkey)", expectedWithNulls, this.queryRunner);
    }

    @Test
    public void testRank() {
        WindowAssertions.assertWindowQuery("rank() OVER (ORDER BY orderstatus)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 1}).row(new Object[]{5, "F", 1}).row(new Object[]{6, "F", 1}).row(new Object[]{33, "F", 1}).row(new Object[]{1, "O", 5}).row(new Object[]{2, "O", 5}).row(new Object[]{4, "O", 5}).row(new Object[]{7, "O", 5}).row(new Object[]{32, "O", 5}).row(new Object[]{34, "O", 5}).build(), this.queryRunner);
        WindowAssertions.assertWindowQueryWithNulls("rank() OVER (ORDER BY orderstatus)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 1}).row(new Object[]{5, "F", 1}).row(new Object[]{null, "F", 1}).row(new Object[]{null, "F", 1}).row(new Object[]{34, "O", 5}).row(new Object[]{null, "O", 5}).row(new Object[]{1, null, 7}).row(new Object[]{7, null, 7}).row(new Object[]{null, null, 7}).row(new Object[]{null, null, 7}).build(), this.queryRunner);
    }

    @Test
    public void testDenseRank() {
        WindowAssertions.assertWindowQuery("dense_rank() OVER (ORDER BY orderstatus)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 1}).row(new Object[]{5, "F", 1}).row(new Object[]{6, "F", 1}).row(new Object[]{33, "F", 1}).row(new Object[]{1, "O", 2}).row(new Object[]{2, "O", 2}).row(new Object[]{4, "O", 2}).row(new Object[]{7, "O", 2}).row(new Object[]{32, "O", 2}).row(new Object[]{34, "O", 2}).build(), this.queryRunner);
        WindowAssertions.assertWindowQueryWithNulls("dense_rank() OVER (ORDER BY orderstatus)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 1}).row(new Object[]{5, "F", 1}).row(new Object[]{null, "F", 1}).row(new Object[]{null, "F", 1}).row(new Object[]{34, "O", 2}).row(new Object[]{null, "O", 2}).row(new Object[]{1, null, 3}).row(new Object[]{7, null, 3}).row(new Object[]{null, null, 3}).row(new Object[]{null, null, 3}).build(), this.queryRunner);
    }

    @Test
    public void testPercentRank() {
        WindowAssertions.assertWindowQuery("percent_rank() OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, DoubleType.DOUBLE}).row(new Object[]{3, "F", 0.0}).row(new Object[]{5, "F", 0.3333333333333333}).row(new Object[]{6, "F", 0.6666666666666666}).row(new Object[]{33, "F", 1.0}).row(new Object[]{1, "O", 0.0}).row(new Object[]{2, "O", 0.2}).row(new Object[]{4, "O", 0.4}).row(new Object[]{7, "O", 0.6}).row(new Object[]{32, "O", 0.8}).row(new Object[]{34, "O", 1.0}).build(), this.queryRunner);
        WindowAssertions.assertWindowQueryWithNulls("percent_rank() OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 0.0}).row(new Object[]{5, "F", 0.3333333333333333}).row(new Object[]{null, "F", 0.6666666666666666}).row(new Object[]{null, "F", 0.6666666666666666}).row(new Object[]{34, "O", 0.0}).row(new Object[]{null, "O", 1.0}).row(new Object[]{1, null, 0.0}).row(new Object[]{7, null, 0.3333333333333333}).row(new Object[]{null, null, 0.6666666666666666}).row(new Object[]{null, null, 0.6666666666666666}).build(), this.queryRunner);
        WindowAssertions.assertWindowQuery("percent_rank() OVER (ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, DoubleType.DOUBLE}).row(new Object[]{1, "O", 0.0}).row(new Object[]{2, "O", 0.1111111111111111}).row(new Object[]{3, "F", 0.2222222222222222}).row(new Object[]{4, "O", 0.3333333333333333}).row(new Object[]{5, "F", 0.4444444444444444}).row(new Object[]{6, "F", 0.5555555555555556}).row(new Object[]{7, "O", 0.6666666666666666}).row(new Object[]{32, "O", 0.7777777777777778}).row(new Object[]{33, "F", 0.8888888888888888}).row(new Object[]{34, "O", 1.0}).build(), this.queryRunner);
        WindowAssertions.assertWindowQueryWithNulls("percent_rank() OVER (ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{1, null, 0.0}).row(new Object[]{3, "F", 0.1111111111111111}).row(new Object[]{5, "F", 0.2222222222222222}).row(new Object[]{7, null, 0.3333333333333333}).row(new Object[]{34, "O", 0.4444444444444444}).row(new Object[]{null, "F", 0.5555555555555556}).row(new Object[]{null, "F", 0.5555555555555556}).row(new Object[]{null, "O", 0.5555555555555556}).row(new Object[]{null, null, 0.5555555555555556}).row(new Object[]{null, null, 0.5555555555555556}).build(), this.queryRunner);
        WindowAssertions.assertWindowQuery("percent_rank() OVER (ORDER BY orderstatus)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, DoubleType.DOUBLE}).row(new Object[]{3, "F", 0.0}).row(new Object[]{5, "F", 0.0}).row(new Object[]{6, "F", 0.0}).row(new Object[]{33, "F", 0.0}).row(new Object[]{1, "O", 0.4444444444444444}).row(new Object[]{2, "O", 0.4444444444444444}).row(new Object[]{4, "O", 0.4444444444444444}).row(new Object[]{7, "O", 0.4444444444444444}).row(new Object[]{32, "O", 0.4444444444444444}).row(new Object[]{34, "O", 0.4444444444444444}).build(), this.queryRunner);
        WindowAssertions.assertWindowQueryWithNulls("percent_rank() OVER (ORDER BY orderstatus)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 0.0}).row(new Object[]{5, "F", 0.0}).row(new Object[]{null, "F", 0.0}).row(new Object[]{null, "F", 0.0}).row(new Object[]{34, "O", 0.4444444444444444}).row(new Object[]{null, "O", 0.4444444444444444}).row(new Object[]{1, null, 0.6666666666666666}).row(new Object[]{7, null, 0.6666666666666666}).row(new Object[]{null, null, 0.6666666666666666}).row(new Object[]{null, null, 0.6666666666666666}).build(), this.queryRunner);
        WindowAssertions.assertWindowQuery("percent_rank() OVER (PARTITION BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, DoubleType.DOUBLE}).row(new Object[]{1, "O", 0.0}).row(new Object[]{2, "O", 0.0}).row(new Object[]{3, "F", 0.0}).row(new Object[]{4, "O", 0.0}).row(new Object[]{5, "F", 0.0}).row(new Object[]{6, "F", 0.0}).row(new Object[]{7, "O", 0.0}).row(new Object[]{32, "O", 0.0}).row(new Object[]{33, "F", 0.0}).row(new Object[]{34, "O", 0.0}).build(), this.queryRunner);
        WindowAssertions.assertWindowQueryWithNulls("percent_rank() OVER (PARTITION BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{1, null, 0.0}).row(new Object[]{3, "F", 0.0}).row(new Object[]{5, "F", 0.0}).row(new Object[]{7, null, 0.0}).row(new Object[]{34, "O", 0.0}).row(new Object[]{null, "F", 0.0}).row(new Object[]{null, "F", 0.0}).row(new Object[]{null, "O", 0.0}).row(new Object[]{null, null, 0.0}).row(new Object[]{null, null, 0.0}).build(), this.queryRunner);
    }

    @Test
    public void testCumulativeDistribution() {
        WindowAssertions.assertWindowQuery("cume_dist() OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, DoubleType.DOUBLE}).row(new Object[]{3, "F", 0.25}).row(new Object[]{5, "F", 0.5}).row(new Object[]{6, "F", 0.75}).row(new Object[]{33, "F", 1.0}).row(new Object[]{1, "O", 0.16666666666666666}).row(new Object[]{2, "O", 0.3333333333333333}).row(new Object[]{4, "O", 0.5}).row(new Object[]{7, "O", 0.6666666666666666}).row(new Object[]{32, "O", 0.8333333333333334}).row(new Object[]{34, "O", 1.0}).build(), this.queryRunner);
        WindowAssertions.assertWindowQueryWithNulls("cume_dist() OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, DoubleType.DOUBLE}).row(new Object[]{3, "F", 0.25}).row(new Object[]{5, "F", 0.5}).row(new Object[]{null, "F", 1.0}).row(new Object[]{null, "F", 1.0}).row(new Object[]{34, "O", 0.5}).row(new Object[]{null, "O", 1.0}).row(new Object[]{1, null, 0.25}).row(new Object[]{7, null, 0.5}).row(new Object[]{null, null, 1.0}).row(new Object[]{null, null, 1.0}).build(), this.queryRunner);
        WindowAssertions.assertWindowQuery("cume_dist() OVER (ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, DoubleType.DOUBLE}).row(new Object[]{1, "O", 0.1}).row(new Object[]{2, "O", 0.2}).row(new Object[]{3, "F", 0.3}).row(new Object[]{4, "O", 0.4}).row(new Object[]{5, "F", 0.5}).row(new Object[]{6, "F", 0.6}).row(new Object[]{7, "O", 0.7}).row(new Object[]{32, "O", 0.8}).row(new Object[]{33, "F", 0.9}).row(new Object[]{34, "O", 1.0}).build(), this.queryRunner);
        WindowAssertions.assertWindowQueryWithNulls("cume_dist() OVER (ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, DoubleType.DOUBLE}).row(new Object[]{1, null, 0.1}).row(new Object[]{3, "F", 0.2}).row(new Object[]{5, "F", 0.3}).row(new Object[]{7, null, 0.4}).row(new Object[]{34, "O", 0.5}).row(new Object[]{null, "F", 1.0}).row(new Object[]{null, "F", 1.0}).row(new Object[]{null, "O", 1.0}).row(new Object[]{null, null, 1.0}).row(new Object[]{null, null, 1.0}).build(), this.queryRunner);
        WindowAssertions.assertWindowQuery("cume_dist() OVER (ORDER BY orderstatus)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, DoubleType.DOUBLE}).row(new Object[]{3, "F", 0.4}).row(new Object[]{5, "F", 0.4}).row(new Object[]{6, "F", 0.4}).row(new Object[]{33, "F", 0.4}).row(new Object[]{1, "O", 1.0}).row(new Object[]{2, "O", 1.0}).row(new Object[]{4, "O", 1.0}).row(new Object[]{7, "O", 1.0}).row(new Object[]{32, "O", 1.0}).row(new Object[]{34, "O", 1.0}).build(), this.queryRunner);
        WindowAssertions.assertWindowQueryWithNulls("cume_dist() OVER (ORDER BY orderstatus)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, DoubleType.DOUBLE}).row(new Object[]{3, "F", 0.4}).row(new Object[]{5, "F", 0.4}).row(new Object[]{null, "F", 0.4}).row(new Object[]{null, "F", 0.4}).row(new Object[]{34, "O", 0.6}).row(new Object[]{null, "O", 0.6}).row(new Object[]{1, null, 1.0}).row(new Object[]{7, null, 1.0}).row(new Object[]{null, null, 1.0}).row(new Object[]{null, null, 1.0}).build(), this.queryRunner);
        WindowAssertions.assertWindowQuery("cume_dist() OVER (PARTITION BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, DoubleType.DOUBLE}).row(new Object[]{1, "O", 1.0}).row(new Object[]{2, "O", 1.0}).row(new Object[]{3, "F", 1.0}).row(new Object[]{4, "O", 1.0}).row(new Object[]{5, "F", 1.0}).row(new Object[]{6, "F", 1.0}).row(new Object[]{7, "O", 1.0}).row(new Object[]{32, "O", 1.0}).row(new Object[]{33, "F", 1.0}).row(new Object[]{34, "O", 1.0}).build(), this.queryRunner);
        WindowAssertions.assertWindowQueryWithNulls("cume_dist() OVER (PARTITION BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, DoubleType.DOUBLE}).row(new Object[]{1, null, 1.0}).row(new Object[]{3, "F", 1.0}).row(new Object[]{5, "F", 1.0}).row(new Object[]{7, null, 1.0}).row(new Object[]{34, "O", 1.0}).row(new Object[]{null, "F", 1.0}).row(new Object[]{null, "F", 1.0}).row(new Object[]{null, "O", 1.0}).row(new Object[]{null, null, 1.0}).row(new Object[]{null, null, 1.0}).build(), this.queryRunner);
    }

    @Test
    public void testFirstValue() {
        WindowAssertions.assertWindowQuery("first_value(orderdate) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3, "F", "1993-10-14"}).row(new Object[]{5, "F", "1993-10-14"}).row(new Object[]{6, "F", "1993-10-14"}).row(new Object[]{33, "F", "1993-10-14"}).row(new Object[]{1, "O", "1996-01-02"}).row(new Object[]{2, "O", "1996-01-02"}).row(new Object[]{4, "O", "1996-01-02"}).row(new Object[]{7, "O", "1996-01-02"}).row(new Object[]{32, "O", "1996-01-02"}).row(new Object[]{34, "O", "1996-01-02"}).build(), this.queryRunner);
        WindowAssertions.assertWindowQueryWithNulls("first_value(orderdate) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3, "F", "1993-10-14"}).row(new Object[]{5, "F", "1993-10-14"}).row(new Object[]{null, "F", "1993-10-14"}).row(new Object[]{null, "F", "1993-10-14"}).row(new Object[]{34, "O", "1998-07-21"}).row(new Object[]{null, "O", "1998-07-21"}).row(new Object[]{1, null, null}).row(new Object[]{7, null, null}).row(new Object[]{null, null, null}).row(new Object[]{null, null, null}).build(), this.queryRunner);
        WindowAssertions.assertWindowQuery("first_value(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 3}).row(new Object[]{5, "F", 3}).row(new Object[]{6, "F", 3}).row(new Object[]{33, "F", 3}).row(new Object[]{1, "O", 1}).row(new Object[]{2, "O", 1}).row(new Object[]{4, "O", 1}).row(new Object[]{7, "O", 1}).row(new Object[]{32, "O", 1}).row(new Object[]{34, "O", 1}).build(), this.queryRunner);
        WindowAssertions.assertWindowQueryWithNulls("first_value(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 3}).row(new Object[]{5, "F", 3}).row(new Object[]{null, "F", 3}).row(new Object[]{null, "F", 3}).row(new Object[]{34, "O", 34}).row(new Object[]{null, "O", 34}).row(new Object[]{1, null, 1}).row(new Object[]{7, null, 1}).row(new Object[]{null, null, 1}).row(new Object[]{null, null, 1}).build(), this.queryRunner);
    }

    @Test
    public void testLastValue() {
        WindowAssertions.assertWindowQuery("last_value(orderdate) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3, "F", "1993-10-27"}).row(new Object[]{5, "F", "1993-10-27"}).row(new Object[]{6, "F", "1993-10-27"}).row(new Object[]{33, "F", "1993-10-27"}).row(new Object[]{1, "O", "1998-07-21"}).row(new Object[]{2, "O", "1998-07-21"}).row(new Object[]{4, "O", "1998-07-21"}).row(new Object[]{7, "O", "1998-07-21"}).row(new Object[]{32, "O", "1998-07-21"}).row(new Object[]{34, "O", "1998-07-21"}).build(), this.queryRunner);
        WindowAssertions.assertWindowQueryWithNulls("last_value(orderdate) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3, "F", "1992-02-21"}).row(new Object[]{5, "F", "1992-02-21"}).row(new Object[]{null, "F", "1992-02-21"}).row(new Object[]{null, "F", "1992-02-21"}).row(new Object[]{34, "O", "1996-12-01"}).row(new Object[]{null, "O", "1996-12-01"}).row(new Object[]{1, null, "1995-07-16"}).row(new Object[]{7, null, "1995-07-16"}).row(new Object[]{null, null, "1995-07-16"}).row(new Object[]{null, null, "1995-07-16"}).build(), this.queryRunner);
        WindowAssertions.assertWindowQuery("last_value(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 33}).row(new Object[]{5, "F", 33}).row(new Object[]{6, "F", 33}).row(new Object[]{33, "F", 33}).row(new Object[]{1, "O", 34}).row(new Object[]{2, "O", 34}).row(new Object[]{4, "O", 34}).row(new Object[]{7, "O", 34}).row(new Object[]{32, "O", 34}).row(new Object[]{34, "O", 34}).build(), this.queryRunner);
        WindowAssertions.assertWindowQueryWithNulls("last_value(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", null}).row(new Object[]{5, "F", null}).row(new Object[]{null, "F", null}).row(new Object[]{null, "F", null}).row(new Object[]{34, "O", null}).row(new Object[]{null, "O", null}).row(new Object[]{1, null, null}).row(new Object[]{7, null, null}).row(new Object[]{null, null, null}).row(new Object[]{null, null, null}).build(), this.queryRunner);
    }

    @Test
    public void testLagFunction() {
        WindowAssertions.assertWindowQuery("lag(orderdate) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3, "F", null}).row(new Object[]{5, "F", "1993-10-14"}).row(new Object[]{6, "F", "1994-07-30"}).row(new Object[]{33, "F", "1992-02-21"}).row(new Object[]{1, "O", null}).row(new Object[]{2, "O", "1996-01-02"}).row(new Object[]{4, "O", "1996-12-01"}).row(new Object[]{7, "O", "1995-10-11"}).row(new Object[]{32, "O", "1996-01-10"}).row(new Object[]{34, "O", "1995-07-16"}).build(), this.queryRunner);
        WindowAssertions.assertWindowQueryWithNulls("lag(orderdate) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3, "F", null}).row(new Object[]{5, "F", "1993-10-14"}).row(new Object[]{null, "F", null}).row(new Object[]{null, "F", "1993-10-27"}).row(new Object[]{34, "O", null}).row(new Object[]{null, "O", "1998-07-21"}).row(new Object[]{1, null, null}).row(new Object[]{7, null, null}).row(new Object[]{null, null, "1996-01-10"}).row(new Object[]{null, null, null}).build(), this.queryRunner);
        WindowAssertions.assertWindowQuery("lag(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", null}).row(new Object[]{5, "F", 3}).row(new Object[]{6, "F", 5}).row(new Object[]{33, "F", 6}).row(new Object[]{1, "O", null}).row(new Object[]{2, "O", 1}).row(new Object[]{4, "O", 2}).row(new Object[]{7, "O", 4}).row(new Object[]{32, "O", 7}).row(new Object[]{34, "O", 32}).build(), this.queryRunner);
        WindowAssertions.assertWindowQueryWithNulls("lag(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", null}).row(new Object[]{5, "F", 3}).row(new Object[]{null, "F", 5}).row(new Object[]{null, "F", null}).row(new Object[]{34, "O", null}).row(new Object[]{null, "O", 34}).row(new Object[]{1, null, null}).row(new Object[]{7, null, 1}).row(new Object[]{null, null, 7}).row(new Object[]{null, null, null}).build(), this.queryRunner);
        WindowAssertions.assertWindowQuery("lag(orderdate, 2, '1977-01-01') OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3, "F", "1977-01-01"}).row(new Object[]{5, "F", "1977-01-01"}).row(new Object[]{6, "F", "1993-10-14"}).row(new Object[]{33, "F", "1994-07-30"}).row(new Object[]{1, "O", "1977-01-01"}).row(new Object[]{2, "O", "1977-01-01"}).row(new Object[]{4, "O", "1996-01-02"}).row(new Object[]{7, "O", "1996-12-01"}).row(new Object[]{32, "O", "1995-10-11"}).row(new Object[]{34, "O", "1996-01-10"}).build(), this.queryRunner);
        WindowAssertions.assertWindowQueryWithNulls("lag(orderdate, 2, '1977-01-01') OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3, "F", "1977-01-01"}).row(new Object[]{5, "F", "1977-01-01"}).row(new Object[]{null, "F", "1993-10-14"}).row(new Object[]{null, "F", null}).row(new Object[]{34, "O", "1977-01-01"}).row(new Object[]{null, "O", "1977-01-01"}).row(new Object[]{1, null, "1977-01-01"}).row(new Object[]{7, null, "1977-01-01"}).row(new Object[]{null, null, null}).row(new Object[]{null, null, "1996-01-10"}).build(), this.queryRunner);
        WindowAssertions.assertWindowQuery("lag(orderkey, 2, -1) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", -1}).row(new Object[]{5, "F", -1}).row(new Object[]{6, "F", 3}).row(new Object[]{33, "F", 5}).row(new Object[]{1, "O", -1}).row(new Object[]{2, "O", -1}).row(new Object[]{4, "O", 1}).row(new Object[]{7, "O", 2}).row(new Object[]{32, "O", 4}).row(new Object[]{34, "O", 7}).build(), this.queryRunner);
        WindowAssertions.assertWindowQueryWithNulls("lag(orderkey, 2, -1) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", -1}).row(new Object[]{5, "F", -1}).row(new Object[]{null, "F", 3}).row(new Object[]{null, "F", 5}).row(new Object[]{34, "O", -1}).row(new Object[]{null, "O", -1}).row(new Object[]{1, null, -1}).row(new Object[]{7, null, -1}).row(new Object[]{null, null, 1}).row(new Object[]{null, null, 7}).build(), this.queryRunner);
    }

    @Test
    public void testLeadFunction() {
        WindowAssertions.assertWindowQuery("lead(orderdate) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3, "F", "1994-07-30"}).row(new Object[]{5, "F", "1992-02-21"}).row(new Object[]{6, "F", "1993-10-27"}).row(new Object[]{33, "F", null}).row(new Object[]{1, "O", "1996-12-01"}).row(new Object[]{2, "O", "1995-10-11"}).row(new Object[]{4, "O", "1996-01-10"}).row(new Object[]{7, "O", "1995-07-16"}).row(new Object[]{32, "O", "1998-07-21"}).row(new Object[]{34, "O", null}).build(), this.queryRunner);
        WindowAssertions.assertWindowQueryWithNulls("lead(orderdate) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3, "F", null}).row(new Object[]{5, "F", "1993-10-27"}).row(new Object[]{null, "F", "1992-02-21"}).row(new Object[]{null, "F", null}).row(new Object[]{34, "O", "1996-12-01"}).row(new Object[]{null, "O", null}).row(new Object[]{1, null, "1996-01-10"}).row(new Object[]{7, null, null}).row(new Object[]{null, null, "1995-07-16"}).row(new Object[]{null, null, null}).build(), this.queryRunner);
        WindowAssertions.assertWindowQuery("lead(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 5}).row(new Object[]{5, "F", 6}).row(new Object[]{6, "F", 33}).row(new Object[]{33, "F", null}).row(new Object[]{1, "O", 2}).row(new Object[]{2, "O", 4}).row(new Object[]{4, "O", 7}).row(new Object[]{7, "O", 32}).row(new Object[]{32, "O", 34}).row(new Object[]{34, "O", null}).build(), this.queryRunner);
        WindowAssertions.assertWindowQueryWithNulls("lead(orderkey) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 5}).row(new Object[]{5, "F", null}).row(new Object[]{null, "F", null}).row(new Object[]{null, "F", null}).row(new Object[]{34, "O", null}).row(new Object[]{null, "O", null}).row(new Object[]{1, null, 7}).row(new Object[]{7, null, null}).row(new Object[]{null, null, null}).row(new Object[]{null, null, null}).build(), this.queryRunner);
        WindowAssertions.assertWindowQuery("lead(orderdate, 2, '1977-01-01') OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3, "F", "1992-02-21"}).row(new Object[]{5, "F", "1993-10-27"}).row(new Object[]{6, "F", "1977-01-01"}).row(new Object[]{33, "F", "1977-01-01"}).row(new Object[]{1, "O", "1995-10-11"}).row(new Object[]{2, "O", "1996-01-10"}).row(new Object[]{4, "O", "1995-07-16"}).row(new Object[]{7, "O", "1998-07-21"}).row(new Object[]{32, "O", "1977-01-01"}).row(new Object[]{34, "O", "1977-01-01"}).build(), this.queryRunner);
        WindowAssertions.assertWindowQueryWithNulls("lead(orderdate, 2, '1977-01-01') OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{3, "F", "1993-10-27"}).row(new Object[]{5, "F", "1992-02-21"}).row(new Object[]{null, "F", "1977-01-01"}).row(new Object[]{null, "F", "1977-01-01"}).row(new Object[]{34, "O", "1977-01-01"}).row(new Object[]{null, "O", "1977-01-01"}).row(new Object[]{1, null, null}).row(new Object[]{7, null, "1995-07-16"}).row(new Object[]{null, null, "1977-01-01"}).row(new Object[]{null, null, "1977-01-01"}).build(), this.queryRunner);
        WindowAssertions.assertWindowQuery("lead(orderkey, 2, -1) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", 6}).row(new Object[]{5, "F", 33}).row(new Object[]{6, "F", -1}).row(new Object[]{33, "F", -1}).row(new Object[]{1, "O", 4}).row(new Object[]{2, "O", 7}).row(new Object[]{4, "O", 32}).row(new Object[]{7, "O", 34}).row(new Object[]{32, "O", -1}).row(new Object[]{34, "O", -1}).build(), this.queryRunner);
        WindowAssertions.assertWindowQueryWithNulls("lead(orderkey, 2, -1) OVER (PARTITION BY orderstatus ORDER BY orderkey)", MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{3, "F", null}).row(new Object[]{5, "F", null}).row(new Object[]{null, "F", -1}).row(new Object[]{null, "F", -1}).row(new Object[]{34, "O", -1}).row(new Object[]{null, "O", -1}).row(new Object[]{1, null, null}).row(new Object[]{7, null, null}).row(new Object[]{null, null, -1}).row(new Object[]{null, null, -1}).build(), this.queryRunner);
    }
}

