/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.PagePartitionFunction;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.TaskSource;
import com.facebook.presto.UnpartitionedPagePartitionFunction;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.StageState;
import com.facebook.presto.execution.StageStats;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.server.MockTaskManager;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public class MockQueryManager
implements QueryManager {
    public static final List<Type> TYPES = ImmutableList.of((Object)VarcharType.VARCHAR);
    public static final TaskId OUT = new TaskId("query", "stage", "out");
    private final MockTaskManager mockTaskManager;
    private final LocationFactory locationFactory;
    private final AtomicInteger nextQueryId = new AtomicInteger();
    private final ConcurrentMap<QueryId, SimpleQuery> queries = new ConcurrentHashMap<QueryId, SimpleQuery>();

    @Inject
    public MockQueryManager(MockTaskManager mockTaskManager, LocationFactory locationFactory) {
        Preconditions.checkNotNull((Object)mockTaskManager, (Object)"mockTaskManager is null");
        Preconditions.checkNotNull((Object)locationFactory, (Object)"locationFactory is null");
        this.mockTaskManager = mockTaskManager;
        this.locationFactory = locationFactory;
    }

    public List<QueryInfo> getAllQueryInfo() {
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform(this.queries.values(), (Function)new Function<SimpleQuery, QueryInfo>(){

            public QueryInfo apply(SimpleQuery queryWorker) {
                try {
                    return queryWorker.getQueryInfo();
                }
                catch (RuntimeException ignored) {
                    return null;
                }
            }
        }), (Predicate)Predicates.notNull()));
    }

    public Duration waitForStateChange(QueryId queryId, QueryState currentState, Duration maxWait) throws InterruptedException {
        return maxWait;
    }

    public QueryInfo getQueryInfo(QueryId queryId) {
        Preconditions.checkNotNull((Object)queryId, (Object)"queryId is null");
        SimpleQuery query = (SimpleQuery)this.queries.get(queryId);
        if (query == null) {
            throw new NoSuchElementException();
        }
        return query.getQueryInfo();
    }

    public QueryInfo createQuery(Session session, String query) {
        Preconditions.checkNotNull((Object)query, (Object)"query is null");
        TaskId outputTaskId = new TaskId(String.valueOf(this.nextQueryId.getAndIncrement()), "0", "0");
        this.mockTaskManager.updateTask(session, outputTaskId, null, (List<TaskSource>)ImmutableList.of(), OutputBuffers.INITIAL_EMPTY_OUTPUT_BUFFERS.withBuffer(OUT, (PagePartitionFunction)new UnpartitionedPagePartitionFunction()).withNoMoreBufferIds());
        SimpleQuery simpleQuery = new SimpleQuery(outputTaskId, this.locationFactory.createQueryLocation(outputTaskId.getQueryId()), this.mockTaskManager, this.locationFactory);
        this.queries.put(outputTaskId.getQueryId(), simpleQuery);
        return simpleQuery.getQueryInfo();
    }

    public void cancelQuery(QueryId queryId) {
        this.queries.remove(queryId);
    }

    public void cancelStage(StageId stageId) {
    }

    private static class SimpleQuery {
        private final TaskId outputTaskId;
        private final URI self;
        private final MockTaskManager mockTaskManager;
        private final LocationFactory locationFactory;

        private SimpleQuery(TaskId outputTaskId, URI self, MockTaskManager mockTaskManager, LocationFactory locationFactory) {
            this.outputTaskId = outputTaskId;
            this.self = self;
            this.mockTaskManager = mockTaskManager;
            this.locationFactory = locationFactory;
        }

        private QueryInfo getQueryInfo() {
            QueryState state;
            TaskInfo outputTask = this.mockTaskManager.getTaskInfo(this.outputTaskId);
            switch (outputTask.getState()) {
                case PLANNED: 
                case RUNNING: {
                    state = QueryState.RUNNING;
                    break;
                }
                case FINISHED: {
                    state = QueryState.FINISHED;
                    break;
                }
                case CANCELED: {
                    state = QueryState.CANCELED;
                    break;
                }
                case FAILED: {
                    state = QueryState.FAILED;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown task state " + outputTask.getState());
                }
            }
            return new QueryInfo(this.outputTaskId.getQueryId(), SessionTestUtils.TEST_SESSION, state, this.self, (List)ImmutableList.of((Object)"out"), "query", new QueryStats(), new StageInfo(this.outputTaskId.getStageId(), StageState.FINISHED, this.locationFactory.createStageLocation(this.outputTaskId.getStageId()), null, TYPES, new StageStats(), (List)ImmutableList.of((Object)outputTask), (List)ImmutableList.of(), (List)ImmutableList.of()), null, null, null);
        }
    }
}

