/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.PageProcessor;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.RowExpression;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.tpch.LineItem;
import io.airlift.tpch.LineItemGenerator;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=5)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
public class BenchmarkPageProcessor {
    private static final int EXTENDED_PRICE = 0;
    private static final int DISCOUNT = 1;
    private static final int SHIP_DATE = 2;
    private static final int QUANTITY = 3;
    private static final Slice MIN_SHIP_DATE = Slices.copiedBuffer((String)"1994-01-01", (Charset)Charsets.UTF_8);
    private static final Slice MAX_SHIP_DATE = Slices.copiedBuffer((String)"1995-01-01", (Charset)Charsets.UTF_8);
    private Page inputPage;
    private PageProcessor handCodedProcessor;
    private PageProcessor compiledProcessor;
    private static final RowExpression FILTER = Expressions.call((Signature)new Signature("AND", "boolean", new String[0]), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.call((Signature)new Signature(OperatorType.GREATER_THAN_OR_EQUAL.name(), "boolean", new String[]{"varchar", "varchar"}), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)2, (Type)VarcharType.VARCHAR), Expressions.constant((Object)MIN_SHIP_DATE, (Type)VarcharType.VARCHAR)}), Expressions.call((Signature)new Signature("AND", "boolean", new String[0]), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.call((Signature)new Signature(OperatorType.LESS_THAN.name(), "boolean", new String[]{"varchar", "varchar"}), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)2, (Type)VarcharType.VARCHAR), Expressions.constant((Object)MAX_SHIP_DATE, (Type)VarcharType.VARCHAR)}), Expressions.call((Signature)new Signature("AND", "boolean", new String[0]), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.call((Signature)new Signature(OperatorType.GREATER_THAN_OR_EQUAL.name(), "boolean", new String[]{"double", "double"}), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)DoubleType.DOUBLE), Expressions.constant((Object)0.05, (Type)DoubleType.DOUBLE)}), Expressions.call((Signature)new Signature("AND", "boolean", new String[0]), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.call((Signature)new Signature(OperatorType.LESS_THAN_OR_EQUAL.name(), "boolean", new String[]{"double", "double"}), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)DoubleType.DOUBLE), Expressions.constant((Object)0.07, (Type)DoubleType.DOUBLE)}), Expressions.call((Signature)new Signature(OperatorType.LESS_THAN.name(), "boolean", new String[]{"bigint", "bigint"}), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)3, (Type)BigintType.BIGINT), Expressions.constant((Object)24L, (Type)BigintType.BIGINT)})})})})});
    private static final RowExpression PROJECT = Expressions.call((Signature)new Signature(OperatorType.MULTIPLY.name(), "double", new String[]{"double", "double"}), (Type)DoubleType.DOUBLE, (RowExpression[])new RowExpression[]{Expressions.field((int)0, (Type)DoubleType.DOUBLE), Expressions.field((int)1, (Type)DoubleType.DOUBLE)});

    @Setup
    public void setup() {
        this.inputPage = BenchmarkPageProcessor.createInputPage();
        this.handCodedProcessor = new Tpch1FilterAndProject();
        this.compiledProcessor = new ExpressionCompiler((Metadata)new MetadataManager()).compilePageProcessor(FILTER, (List)ImmutableList.of((Object)PROJECT));
    }

    @Benchmark
    public Page handCoded() {
        return BenchmarkPageProcessor.execute(this.inputPage, this.handCodedProcessor);
    }

    @Benchmark
    public Page compiled() {
        return BenchmarkPageProcessor.execute(this.inputPage, this.compiledProcessor);
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkPageProcessor.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    public static Page execute(Page inputPage, PageProcessor processor) {
        PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)DoubleType.DOUBLE));
        int count = processor.process(null, inputPage, 0, inputPage.getPositionCount(), pageBuilder);
        Preconditions.checkState((count == inputPage.getPositionCount() ? 1 : 0) != 0);
        return pageBuilder.build();
    }

    public static Page createInputPage() {
        PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT));
        LineItemGenerator lineItemGenerator = new LineItemGenerator(1.0, 1, 1);
        Iterator iterator = lineItemGenerator.iterator();
        for (int i = 0; i < 10000; ++i) {
            LineItem lineItem = (LineItem)iterator.next();
            DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(0), lineItem.getExtendedPrice());
            DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(1), lineItem.getDiscount());
            VarcharType.VARCHAR.writeSlice(pageBuilder.getBlockBuilder(2), Slices.utf8Slice((String)lineItem.getShipDate()));
            BigintType.BIGINT.writeLong(pageBuilder.getBlockBuilder(3), lineItem.getQuantity());
        }
        return pageBuilder.build();
    }

    private static final class Tpch1FilterAndProject
    implements PageProcessor {
        private Tpch1FilterAndProject() {
        }

        public int process(ConnectorSession session, Page page, int start, int end, PageBuilder pageBuilder) {
            int position;
            Block discountBlock = page.getBlock(1);
            for (position = start; position < end; ++position) {
                if (!Tpch1FilterAndProject.filter(position, discountBlock, page.getBlock(2), page.getBlock(3))) continue;
                Tpch1FilterAndProject.project(position, pageBuilder, page.getBlock(0), discountBlock);
            }
            return position;
        }

        private static void project(int position, PageBuilder pageBuilder, Block extendedPriceBlock, Block discountBlock) {
            if (discountBlock.isNull(position) || extendedPriceBlock.isNull(position)) {
                pageBuilder.getBlockBuilder(0).appendNull();
            } else {
                DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(0), DoubleType.DOUBLE.getDouble(extendedPriceBlock, position) * DoubleType.DOUBLE.getDouble(discountBlock, position));
            }
        }

        private static boolean filter(int position, Block discountBlock, Block shipDateBlock, Block quantityBlock) {
            return !shipDateBlock.isNull(position) && VarcharType.VARCHAR.getSlice(shipDateBlock, position).compareTo(MIN_SHIP_DATE) >= 0 && !shipDateBlock.isNull(position) && VarcharType.VARCHAR.getSlice(shipDateBlock, position).compareTo(MAX_SHIP_DATE) < 0 && !discountBlock.isNull(position) && DoubleType.DOUBLE.getDouble(discountBlock, position) >= 0.05 && !discountBlock.isNull(position) && DoubleType.DOUBLE.getDouble(discountBlock, position) <= 0.07 && !quantityBlock.isNull(position) && BigintType.BIGINT.getLong(quantityBlock, position) < 24L;
        }
    }
}

