/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.Session;
import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.spi.type.SqlDate;
import com.facebook.presto.spi.type.SqlTime;
import com.facebook.presto.spi.type.SqlTimeWithTimeZone;
import com.facebook.presto.spi.type.SqlTimestamp;
import com.facebook.presto.spi.type.SqlTimestampWithTimeZone;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.util.DateTimeZoneIndex;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestTimestamp {
    private static final TimeZoneKey TIME_ZONE_KEY = TimeZoneKey.getTimeZoneKey((String)"Europe/Berlin");
    private static final DateTimeZone DATE_TIME_ZONE = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TIME_ZONE_KEY);
    private FunctionAssertions functionAssertions;

    @BeforeClass
    public void setUp() {
        Session session = Session.builder().setUser("user").setSource("test").setCatalog("catalog").setSchema("schema").setTimeZoneKey(TIME_ZONE_KEY).setLocale(Locale.ENGLISH).build();
        this.functionAssertions = new FunctionAssertions(session);
    }

    private void assertFunction(String projection, Object expected) {
        this.functionAssertions.assertFunction(projection, expected);
    }

    @Test
    public void testLiteral() {
        this.assertFunction("TIMESTAMP '2013-03-30 01:05'", new SqlTimestamp(new DateTime(2013, 3, 30, 1, 5, 0, 0, DATE_TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2013-03-30 02:05'", new SqlTimestamp(new DateTime(2013, 3, 30, 2, 5, 0, 0, DATE_TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2013-03-30 03:05'", new SqlTimestamp(new DateTime(2013, 3, 30, 3, 5, 0, 0, DATE_TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-01-22 03:04:05.321'", new SqlTimestamp(new DateTime(2001, 1, 22, 3, 4, 5, 321, DATE_TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-01-22 03:04:05'", new SqlTimestamp(new DateTime(2001, 1, 22, 3, 4, 5, 0, DATE_TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-01-22 03:04'", new SqlTimestamp(new DateTime(2001, 1, 22, 3, 4, 0, 0, DATE_TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-01-22'", new SqlTimestamp(new DateTime(2001, 1, 22, 0, 0, 0, 0, DATE_TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-1-2 3:4:5.321'", new SqlTimestamp(new DateTime(2001, 1, 2, 3, 4, 5, 321, DATE_TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-1-2 3:4:5'", new SqlTimestamp(new DateTime(2001, 1, 2, 3, 4, 5, 0, DATE_TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-1-2 3:4'", new SqlTimestamp(new DateTime(2001, 1, 2, 3, 4, 0, 0, DATE_TIME_ZONE).getMillis(), TIME_ZONE_KEY));
        this.assertFunction("TIMESTAMP '2001-1-2'", new SqlTimestamp(new DateTime(2001, 1, 2, 0, 0, 0, 0, DATE_TIME_ZONE).getMillis(), TIME_ZONE_KEY));
    }

    @Test
    public void testEqual() {
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' = TIMESTAMP '2001-1-22 03:04:05.321'", true);
        this.assertFunction("TIMESTAMP '2001-1-22' = TIMESTAMP '2001-1-22'", true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' = TIMESTAMP '2001-1-22 03:04:05.333'", false);
        this.assertFunction("TIMESTAMP '2001-1-22' = TIMESTAMP '2001-1-11'", false);
    }

    @Test
    public void testNotEqual() {
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' <> TIMESTAMP '2001-1-22 03:04:05.333'", true);
        this.assertFunction("TIMESTAMP '2001-1-22' <> TIMESTAMP '2001-1-11'", true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' <> TIMESTAMP '2001-1-22 03:04:05.321'", false);
        this.assertFunction("TIMESTAMP '2001-1-22' <> TIMESTAMP '2001-1-22'", false);
    }

    @Test
    public void testLessThan() {
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' < TIMESTAMP '2001-1-22 03:04:05.333'", true);
        this.assertFunction("TIMESTAMP '2001-1-22' < TIMESTAMP '2001-1-23'", true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' < TIMESTAMP '2001-1-22 03:04:05.321'", false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' < TIMESTAMP '2001-1-22 03:04:05'", false);
        this.assertFunction("TIMESTAMP '2001-1-22' < TIMESTAMP '2001-1-22'", false);
        this.assertFunction("TIMESTAMP '2001-1-22' < TIMESTAMP '2001-1-20'", false);
    }

    @Test
    public void testLessThanOrEqual() {
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' <= TIMESTAMP '2001-1-22 03:04:05.333'", true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' <= TIMESTAMP '2001-1-22 03:04:05.321'", true);
        this.assertFunction("TIMESTAMP '2001-1-22' <= TIMESTAMP '2001-1-23'", true);
        this.assertFunction("TIMESTAMP '2001-1-22' <= TIMESTAMP '2001-1-22'", true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' <= TIMESTAMP '2001-1-22 03:04:05'", false);
        this.assertFunction("TIMESTAMP '2001-1-22' <= TIMESTAMP '2001-1-20'", false);
    }

    @Test
    public void testGreaterThan() {
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' > TIMESTAMP '2001-1-22 03:04:05.111'", true);
        this.assertFunction("TIMESTAMP '2001-1-22' > TIMESTAMP '2001-1-11'", true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' > TIMESTAMP '2001-1-22 03:04:05.321'", false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' > TIMESTAMP '2001-1-22 03:04:05.333'", false);
        this.assertFunction("TIMESTAMP '2001-1-22' > TIMESTAMP '2001-1-22'", false);
        this.assertFunction("TIMESTAMP '2001-1-22' > TIMESTAMP '2001-1-23'", false);
    }

    @Test
    public void testGreaterThanOrEqual() {
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' >= TIMESTAMP '2001-1-22 03:04:05.111'", true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' >= TIMESTAMP '2001-1-22 03:04:05.321'", true);
        this.assertFunction("TIMESTAMP '2001-1-22' >= TIMESTAMP '2001-1-11'", true);
        this.assertFunction("TIMESTAMP '2001-1-22' >= TIMESTAMP '2001-1-22'", true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' >= TIMESTAMP '2001-1-22 03:04:05.333'", false);
        this.assertFunction("TIMESTAMP '2001-1-22' >= TIMESTAMP '2001-1-23'", false);
    }

    @Test
    public void testBetween() {
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' between TIMESTAMP '2001-1-22 03:04:05.111' and TIMESTAMP '2001-1-22 03:04:05.333'", true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' between TIMESTAMP '2001-1-22 03:04:05.321' and TIMESTAMP '2001-1-22 03:04:05.333'", true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' between TIMESTAMP '2001-1-22 03:04:05.111' and TIMESTAMP '2001-1-22 03:04:05.321'", true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' between TIMESTAMP '2001-1-22 03:04:05.321' and TIMESTAMP '2001-1-22 03:04:05.321'", true);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' between TIMESTAMP '2001-1-22 03:04:05.322' and TIMESTAMP '2001-1-22 03:04:05.333'", false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' between TIMESTAMP '2001-1-22 03:04:05.311' and TIMESTAMP '2001-1-22 03:04:05.312'", false);
        this.assertFunction("TIMESTAMP '2001-1-22 03:04:05.321' between TIMESTAMP '2001-1-22 03:04:05.333' and TIMESTAMP '2001-1-22 03:04:05.111'", false);
    }

    @Test
    public void testCastToDate() throws Exception {
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04:05.321' as date)", new SqlDate(new LocalDate(2001, 1, 22).toDateMidnight(DATE_TIME_ZONE).getMillis(), TIME_ZONE_KEY));
    }

    @Test
    public void testCastToTime() throws Exception {
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04:05.321' as time)", new SqlTime(new DateTime(1970, 1, 1, 3, 4, 5, 321, DATE_TIME_ZONE).getMillis(), TIME_ZONE_KEY));
    }

    @Test
    public void testCastToTimeWithTimeZone() throws Exception {
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04:05.321' as time with time zone)", new SqlTimeWithTimeZone(new DateTime(1970, 1, 1, 3, 4, 5, 321, DATE_TIME_ZONE).getMillis(), TIME_ZONE_KEY));
    }

    @Test
    public void testCastToTimestampWithTimeZone() {
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04:05.321' as timestamp with time zone)", new SqlTimestampWithTimeZone(new DateTime(2001, 1, 22, 3, 4, 5, 321, DATE_TIME_ZONE).getMillis(), DATE_TIME_ZONE.toTimeZone()));
    }

    @Test
    public void testCastToSlice() {
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04:05.321' as varchar)", "2001-01-22 03:04:05.321");
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04:05' as varchar)", "2001-01-22 03:04:05.000");
        this.assertFunction("cast(TIMESTAMP '2001-1-22 03:04' as varchar)", "2001-01-22 03:04:00.000");
        this.assertFunction("cast(TIMESTAMP '2001-1-22' as varchar)", "2001-01-22 00:00:00.000");
    }

    @Test
    public void testCastFromSlice() {
        this.assertFunction("cast('2001-1-22 03:04:05.321' as timestamp) = TIMESTAMP '2001-01-22 03:04:05.321'", true);
        this.assertFunction("cast('2001-1-22 03:04:05' as timestamp) = TIMESTAMP '2001-01-22 03:04:05.000'", true);
        this.assertFunction("cast('2001-1-22 03:04' as timestamp) = TIMESTAMP '2001-01-22 03:04:00.000'", true);
        this.assertFunction("cast('2001-1-22' as timestamp) = TIMESTAMP '2001-01-22 00:00:00.000'", true);
    }

    @Test
    public void testGreatest() throws Exception {
        this.assertFunction("greatest(TIMESTAMP '2013-03-30 01:05', TIMESTAMP '2012-03-30 01:05')", new SqlTimestamp(new DateTime(2013, 3, 30, 1, 5, 0, 0, DATE_TIME_ZONE).getMillis(), TIME_ZONE_KEY));
    }

    @Test
    public void testLeast() throws Exception {
        this.assertFunction("least(TIMESTAMP '2013-03-30 01:05', TIMESTAMP '2012-03-30 01:05')", new SqlTimestamp(new DateTime(2012, 3, 30, 1, 5, 0, 0, DATE_TIME_ZONE).getMillis(), TIME_ZONE_KEY));
    }
}

