/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.HashPagePartitionFunction;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=3)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
public class BenchmarkHashPagePartitionFunction {
    @Benchmark
    public List<Page> runBenchmark(BenchmarkData data) {
        HashPagePartitionFunction partitionFunction = new HashPagePartitionFunction(0, 8, data.getChannels(), data.getHashChannel(), data.getTypes());
        return partitionFunction.partition(data.getPages());
    }

    private static List<Page> createPages(int pageCount, int channelCount) {
        int positionCount = 0x100000 / (channelCount * 8);
        ArrayList<Page> pages = new ArrayList<Page>(pageCount);
        for (int numPage = 0; numPage < pageCount; ++numPage) {
            Block[] blocks = new Block[channelCount];
            for (int numChannel = 0; numChannel < channelCount; ++numChannel) {
                blocks[numChannel] = BlockAssertions.createLongSequenceBlock(0, positionCount);
            }
            pages.add(new Page(blocks));
        }
        return pages;
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkHashPagePartitionFunction.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"2", "5", "10", "15", "20"})
        private int channelCount;
        @Param(value={"true", "false"})
        private boolean hashEnabled;
        private final int maxPages = 20;
        private List<Page> pages;
        public Optional<Integer> hashChannel;
        public List<Type> types;
        public List<Integer> channels;

        @Setup
        public void setup() {
            this.pages = BenchmarkHashPagePartitionFunction.createPages(20, this.channelCount);
            this.hashChannel = this.hashEnabled ? Optional.of(this.channelCount - 1) : Optional.empty();
            this.types = Collections.nCopies(this.channelCount, BigintType.BIGINT);
            this.channels = new ArrayList<Integer>(this.channelCount - 1);
            for (int i = 0; i < this.channelCount - 1; ++i) {
                this.channels.add(i);
            }
        }

        public List<Page> getPages() {
            return this.pages;
        }

        public Optional<Integer> getHashChannel() {
            return this.hashChannel;
        }

        public List<Type> getTypes() {
            return this.types;
        }

        public List<Integer> getChannels() {
            return this.channels;
        }
    }
}

