/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.block.AbstractTestBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.VariableWidthBlockBuilder;
import com.facebook.presto.testing.RunLengthEncodedBlock;
import io.airlift.slice.Slice;
import org.testng.annotations.Test;

public class TestRunLengthEncodedBlock
extends AbstractTestBlock {
    @Test
    public void test() {
        for (int positionCount = 0; positionCount < 10; ++positionCount) {
            TestRunLengthEncodedBlock.assertRleBlock(positionCount);
        }
    }

    private static void assertRleBlock(int positionCount) {
        Slice expectedValue = TestRunLengthEncodedBlock.createExpectedValue(0);
        RunLengthEncodedBlock block = new RunLengthEncodedBlock(TestRunLengthEncodedBlock.createSingleValueBlock(expectedValue), positionCount);
        Slice[] expectedValues = new Slice[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            expectedValues[position] = expectedValue;
        }
        TestRunLengthEncodedBlock.assertBlock((Block)block, expectedValues);
    }

    private static Block createSingleValueBlock(Slice expectedValue) {
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(new BlockBuilderStatus());
        blockBuilder.writeBytes(expectedValue, 0, expectedValue.length()).closeEntry();
        return blockBuilder.build();
    }
}

