/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.expression.ByteCodeExpressionAssertions;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.google.common.primitives.Primitives;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCastByteCodeExpression {
    public static final Object OBJECT_FIELD = "foo";
    public static final byte BYTE_FIELD = 99;
    public static final char CHAR_FIELD = '\u000b';
    public static final short SHORT_FIELD = 22;
    public static final int INT_FIELD = 33;
    public static final long LONG_FIELD = 44L;
    public static final float FLOAT_FIELD = 3.3f;
    public static final double DOUBLE_FIELD = 4.4;

    @Test
    public void testDownCastObject() throws Exception {
        ByteCodeExpressionAssertions.assertByteCodeExpression(ByteCodeExpressions.getStatic(this.getClass(), (String)"OBJECT_FIELD").cast(String.class).invoke("length", Integer.TYPE, new ByteCodeExpression[0]), ((String)OBJECT_FIELD).length(), "((String) " + this.getClass().getSimpleName() + ".OBJECT_FIELD).length()");
    }

    @Test
    public void testCastPrimitive() throws Exception {
        this.assertPrimitiveCast("BYTE_FIELD", Byte.TYPE, (byte)99);
        this.assertPrimitiveCast("BYTE_FIELD", Character.TYPE, Character.valueOf('c'));
        this.assertPrimitiveCast("BYTE_FIELD", Short.TYPE, (short)99);
        this.assertPrimitiveCast("BYTE_FIELD", Integer.TYPE, 99);
        this.assertPrimitiveCast("BYTE_FIELD", Long.TYPE, 99L);
        this.assertPrimitiveCast("BYTE_FIELD", Float.TYPE, Float.valueOf(99.0f));
        this.assertPrimitiveCast("BYTE_FIELD", Double.TYPE, 99.0);
        this.assertPrimitiveCast("CHAR_FIELD", Byte.TYPE, (byte)11);
        this.assertPrimitiveCast("CHAR_FIELD", Character.TYPE, Character.valueOf('\u000b'));
        this.assertPrimitiveCast("CHAR_FIELD", Short.TYPE, (short)11);
        this.assertPrimitiveCast("CHAR_FIELD", Integer.TYPE, 11);
        this.assertPrimitiveCast("CHAR_FIELD", Long.TYPE, 11L);
        this.assertPrimitiveCast("CHAR_FIELD", Float.TYPE, Float.valueOf(11.0f));
        this.assertPrimitiveCast("CHAR_FIELD", Double.TYPE, 11.0);
        this.assertPrimitiveCast("SHORT_FIELD", Byte.TYPE, (byte)22);
        this.assertPrimitiveCast("SHORT_FIELD", Character.TYPE, Character.valueOf('\u0016'));
        this.assertPrimitiveCast("SHORT_FIELD", Short.TYPE, (short)22);
        this.assertPrimitiveCast("SHORT_FIELD", Integer.TYPE, 22);
        this.assertPrimitiveCast("SHORT_FIELD", Long.TYPE, 22L);
        this.assertPrimitiveCast("SHORT_FIELD", Float.TYPE, Float.valueOf(22.0f));
        this.assertPrimitiveCast("SHORT_FIELD", Double.TYPE, 22.0);
        this.assertPrimitiveCast("INT_FIELD", Byte.TYPE, (byte)33);
        this.assertPrimitiveCast("INT_FIELD", Character.TYPE, Character.valueOf('!'));
        this.assertPrimitiveCast("INT_FIELD", Short.TYPE, (short)33);
        this.assertPrimitiveCast("INT_FIELD", Integer.TYPE, 33);
        this.assertPrimitiveCast("INT_FIELD", Long.TYPE, 33L);
        this.assertPrimitiveCast("INT_FIELD", Float.TYPE, Float.valueOf(33.0f));
        this.assertPrimitiveCast("INT_FIELD", Double.TYPE, 33.0);
        this.assertPrimitiveCast("LONG_FIELD", Byte.TYPE, (byte)44);
        this.assertPrimitiveCast("LONG_FIELD", Character.TYPE, Character.valueOf(','));
        this.assertPrimitiveCast("LONG_FIELD", Short.TYPE, (short)44);
        this.assertPrimitiveCast("LONG_FIELD", Integer.TYPE, 44);
        this.assertPrimitiveCast("LONG_FIELD", Long.TYPE, 44L);
        this.assertPrimitiveCast("LONG_FIELD", Float.TYPE, Float.valueOf(44.0f));
        this.assertPrimitiveCast("LONG_FIELD", Double.TYPE, 44.0);
        this.assertPrimitiveCast("FLOAT_FIELD", Byte.TYPE, (byte)3);
        this.assertPrimitiveCast("FLOAT_FIELD", Character.TYPE, Character.valueOf('\u0003'));
        this.assertPrimitiveCast("FLOAT_FIELD", Short.TYPE, (short)3);
        this.assertPrimitiveCast("FLOAT_FIELD", Integer.TYPE, 3);
        this.assertPrimitiveCast("FLOAT_FIELD", Long.TYPE, 3L);
        this.assertPrimitiveCast("FLOAT_FIELD", Float.TYPE, Float.valueOf(3.3f));
        this.assertPrimitiveCast("FLOAT_FIELD", Double.TYPE, 3.3f);
        this.assertPrimitiveCast("DOUBLE_FIELD", Byte.TYPE, (byte)4);
        this.assertPrimitiveCast("DOUBLE_FIELD", Character.TYPE, Character.valueOf('\u0004'));
        this.assertPrimitiveCast("DOUBLE_FIELD", Short.TYPE, (short)4);
        this.assertPrimitiveCast("DOUBLE_FIELD", Integer.TYPE, 4);
        this.assertPrimitiveCast("DOUBLE_FIELD", Long.TYPE, 4L);
        this.assertPrimitiveCast("DOUBLE_FIELD", Float.TYPE, Float.valueOf(4.4f));
        this.assertPrimitiveCast("DOUBLE_FIELD", Double.TYPE, 4.4);
    }

    public void assertPrimitiveCast(String fieldName, Class<?> castToType, Object expected) throws Exception {
        ByteCodeExpression baseExpression = ByteCodeExpressions.getStatic(this.getClass(), (String)fieldName);
        TestCastByteCodeExpression.assertCast(baseExpression, expected, castToType);
        baseExpression = baseExpression.cast(castToType);
        Class boxedType = Primitives.wrap(castToType);
        TestCastByteCodeExpression.assertCast(baseExpression, expected, boxedType);
        baseExpression = baseExpression.cast(boxedType);
        TestCastByteCodeExpression.assertCast(baseExpression, expected, castToType);
    }

    public static void assertCast(ByteCodeExpression expression, Object expectedValue, Class<?> castToType) throws Exception {
        ByteCodeExpression castExpression = expression.cast(castToType);
        ByteCodeExpressionAssertions.assertByteCodeExpression(castExpression, expectedValue, TestCastByteCodeExpression.expectedCastRendering(expression.toString(), castToType));
        Assert.assertEquals((String)castExpression.getType().getJavaClassName(), (String)castToType.getName());
    }

    public static String expectedCastRendering(String expectedRendering, Class<?> castToType) {
        return "((" + castToType.getSimpleName() + ") " + expectedRendering + ")";
    }
}

