/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.ResetSessionTask;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.ResetSession;
import com.google.common.collect.ImmutableSet;
import io.airlift.concurrent.Threads;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestResetSessionTask {
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"stage-executor-%s"));

    @AfterClass
    public void tearDown() throws Exception {
        this.executor.shutdownNow();
    }

    @Test
    public void test() throws Exception {
        Session session = SessionTestUtils.TEST_SESSION.withSystemProperty("foo", "bar").withCatalogProperty("catalog", "baz", "blah");
        QueryStateMachine stateMachine = new QueryStateMachine(new QueryId("query"), "reset foo", session, URI.create("fake://uri"), (Executor)this.executor);
        new ResetSessionTask().execute(new ResetSession(QualifiedName.of((String)"catalog", (String[])new String[]{"baz"})), session, (Metadata)new MetadataManager(), stateMachine);
        Set sessionProperties = stateMachine.getResetSessionProperties();
        Assert.assertEquals((Set)sessionProperties, (Set)ImmutableSet.of((Object)"catalog.baz"));
    }
}

