/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.SetSessionTask;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.SetSession;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.Threads;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestSetSessionTask {
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"stage-executor-%s"));

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        this.executor.shutdownNow();
    }

    @Test
    public void test() throws Exception {
        QueryStateMachine stateMachine = new QueryStateMachine(new QueryId("query"), "set foo.bar = 'baz'", SessionTestUtils.TEST_SESSION, URI.create("fake://uri"), (Executor)this.executor);
        new SetSessionTask().execute(new SetSession(QualifiedName.of((String)"foo", (String[])new String[]{"bar"}), "baz"), SessionTestUtils.TEST_SESSION, (Metadata)new MetadataManager(), stateMachine);
        Map sessionProperties = stateMachine.getSetSessionProperties();
        Assert.assertEquals((Map)sessionProperties, (Map)ImmutableMap.of((Object)"foo.bar", (Object)"baz"));
    }
}

