/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.connector.informationSchema.InformationSchemaHandleResolver;
import com.facebook.presto.connector.informationSchema.InformationSchemaTableHandle;
import com.facebook.presto.connector.system.SystemHandleResolver;
import com.facebook.presto.connector.system.SystemTableHandle;
import com.facebook.presto.metadata.HandleJsonModule;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.Stage;
import com.google.inject.multibindings.MapBinder;
import io.airlift.json.JsonModule;
import io.airlift.testing.Assertions;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestJsonTableHandle {
    private static final Map<String, Object> SYSTEM_AS_MAP = ImmutableMap.of((Object)"type", (Object)"system", (Object)"schemaName", (Object)"system_schema", (Object)"tableName", (Object)"system_table");
    private static final Map<String, Object> INFORMATION_SCHEMA_AS_MAP = ImmutableMap.of((Object)"type", (Object)"information_schema", (Object)"session", (Object)ImmutableMap.builder().put((Object)"user", (Object)SessionTestUtils.TEST_SESSION.getUser()).put((Object)"source", (Object)SessionTestUtils.TEST_SESSION.getSource()).put((Object)"catalog", (Object)SessionTestUtils.TEST_SESSION.getCatalog()).put((Object)"schema", (Object)SessionTestUtils.TEST_SESSION.getSchema()).put((Object)"timeZoneKey", (Object)SessionTestUtils.TEST_SESSION.getTimeZoneKey().getKey()).put((Object)"locale", (Object)SessionTestUtils.TEST_SESSION.getLocale().toString()).put((Object)"remoteUserAddress", (Object)SessionTestUtils.TEST_SESSION.getRemoteUserAddress()).put((Object)"userAgent", (Object)SessionTestUtils.TEST_SESSION.getUserAgent()).put((Object)"startTime", (Object)SessionTestUtils.TEST_SESSION.getStartTime()).put((Object)"systemProperties", (Object)ImmutableMap.of()).put((Object)"catalogProperties", (Object)ImmutableMap.of()).build(), (Object)"catalogName", (Object)"information_schema_catalog", (Object)"schemaName", (Object)"information_schema_schema", (Object)"tableName", (Object)"information_schema_table");
    private ObjectMapper objectMapper;

    @BeforeMethod
    public void startUp() {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new JsonModule(), new HandleJsonModule(), new Module(){

            public void configure(Binder binder) {
                MapBinder connectorHandleResolverBinder = MapBinder.newMapBinder((Binder)binder, String.class, ConnectorHandleResolver.class);
                connectorHandleResolverBinder.addBinding((Object)"system").to(SystemHandleResolver.class).in(Scopes.SINGLETON);
                connectorHandleResolverBinder.addBinding((Object)"information_schema").to(InformationSchemaHandleResolver.class).in(Scopes.SINGLETON);
            }
        }});
        this.objectMapper = (ObjectMapper)injector.getInstance(ObjectMapper.class);
    }

    @Test
    public void testSystemSerialize() throws Exception {
        SystemTableHandle internalHandle = new SystemTableHandle("system_schema", "system_table");
        Assert.assertTrue((boolean)this.objectMapper.canSerialize(SystemTableHandle.class));
        String json = this.objectMapper.writeValueAsString((Object)internalHandle);
        this.testJsonEquals(json, SYSTEM_AS_MAP);
    }

    @Test
    public void testInformationSchemaSerialize() throws Exception {
        InformationSchemaTableHandle informationSchemaTableHandle = new InformationSchemaTableHandle(SessionTestUtils.TEST_SESSION, "information_schema_catalog", "information_schema_schema", "information_schema_table");
        Assert.assertTrue((boolean)this.objectMapper.canSerialize(InformationSchemaTableHandle.class));
        String json = this.objectMapper.writeValueAsString((Object)informationSchemaTableHandle);
        this.testJsonEquals(json, INFORMATION_SCHEMA_AS_MAP);
    }

    @Test
    public void testSystemDeserialize() throws Exception {
        String json = this.objectMapper.writeValueAsString(SYSTEM_AS_MAP);
        ConnectorTableHandle tableHandle = (ConnectorTableHandle)this.objectMapper.readValue(json, ConnectorTableHandle.class);
        Assert.assertEquals(tableHandle.getClass(), SystemTableHandle.class);
        SystemTableHandle systemHandle = (SystemTableHandle)tableHandle;
        Assert.assertEquals((Object)systemHandle.getSchemaTableName(), (Object)new SchemaTableName("system_schema", "system_table"));
    }

    @Test
    public void testInformationSchemaDeserialize() throws Exception {
        String json = this.objectMapper.writeValueAsString(INFORMATION_SCHEMA_AS_MAP);
        ConnectorTableHandle tableHandle = (ConnectorTableHandle)this.objectMapper.readValue(json, ConnectorTableHandle.class);
        Assert.assertEquals(tableHandle.getClass(), InformationSchemaTableHandle.class);
        InformationSchemaTableHandle informationSchemaHandle = (InformationSchemaTableHandle)tableHandle;
        Assert.assertEquals((String)informationSchemaHandle.getCatalogName(), (String)"information_schema_catalog");
        Assert.assertEquals((String)informationSchemaHandle.getSchemaName(), (String)"information_schema_schema");
        Assert.assertEquals((String)informationSchemaHandle.getTableName(), (String)"information_schema_table");
    }

    private void testJsonEquals(String json, Map<String, Object> expectedMap) throws Exception {
        Map jsonMap = (Map)this.objectMapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
        Assertions.assertEqualsIgnoreOrder(jsonMap.entrySet(), expectedMap.entrySet());
    }
}

