/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=3)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
public class BenchmarkGroupByHash {
    @Benchmark
    public int runBenchmark(BenchmarkData data) {
        GroupByHash groupByHash = new GroupByHash(data.getTypes(), data.getChannels(), data.getHashChannel(), 100);
        int groupCount = 0;
        for (Page page : data.getPages()) {
            GroupByIdBlock groupIds = groupByHash.getGroupIds(page);
            groupCount += (int)groupIds.getGroupCount();
        }
        return groupCount;
    }

    private static List<Page> createPages(int pageCount, int channelCount, int groupCount, List<Type> types) {
        int positionCount = 0x100000 / (channelCount * 8);
        ArrayList<Page> pages = new ArrayList<Page>(pageCount);
        PageBuilder pageBuilder = new PageBuilder(types);
        for (int numPage = 0; numPage < pageCount; ++numPage) {
            pageBuilder.reset();
            for (int i = 0; i < positionCount; ++i) {
                int rand = ThreadLocalRandom.current().nextInt() % groupCount;
                for (int numChannel = 0; numChannel < channelCount; ++numChannel) {
                    BigintType.BIGINT.writeLong(pageBuilder.getBlockBuilder(numChannel), (long)rand);
                }
            }
            pages.add(pageBuilder.build());
        }
        return pages;
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkGroupByHash.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"2", "5", "10", "15", "20"})
        private int channelCount;
        @Param(value={"2", "10", "100", "1000", "10000"})
        private int groupCount;
        @Param(value={"true", "false"})
        private boolean hashEnabled;
        private final int maxPages = 20;
        private List<Page> pages;
        public Optional<Integer> hashChannel;
        public List<Type> types;
        public int[] channels;

        @Setup
        public void setup() {
            this.pages = BenchmarkGroupByHash.createPages(20, this.channelCount, this.groupCount, Collections.nCopies(this.channelCount, BigintType.BIGINT));
            this.hashChannel = this.hashEnabled ? Optional.of(this.channelCount - 1) : Optional.empty();
            this.types = Collections.nCopies(this.channelCount - 1, BigintType.BIGINT);
            this.channels = new int[this.channelCount - 1];
            for (int i = 0; i < this.channelCount - 1; ++i) {
                this.channels[i] = i;
            }
        }

        public List<Page> getPages() {
            return this.pages;
        }

        public Optional<Integer> getHashChannel() {
            return this.hashChannel;
        }

        public List<Type> getTypes() {
            return this.types;
        }

        public int[] getChannels() {
            return this.channels;
        }
    }
}

