/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.Session;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.PageAssertions;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.collect.ImmutableList;
import io.airlift.testing.Assertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;

public final class OperatorAssertion {
    private OperatorAssertion() {
    }

    public static List<Page> appendSampleWeight(List<Page> input, int sampleWeight) {
        return (List)input.stream().map(page -> {
            BlockBuilder builder = BigintType.BIGINT.createBlockBuilder(new BlockBuilderStatus());
            for (int i = 0; i < page.getPositionCount(); ++i) {
                BigintType.BIGINT.writeLong(builder, (long)sampleWeight);
            }
            Block[] blocks = new Block[page.getChannelCount() + 1];
            System.arraycopy(page.getBlocks(), 0, blocks, 0, page.getChannelCount());
            blocks[blocks.length - 1] = builder.build();
            return new Page(blocks);
        }).collect(ImmutableCollectors.toImmutableList());
    }

    public static List<Page> toPages(Operator operator, Iterator<Page> input) {
        ImmutableList.Builder outputPages = ImmutableList.builder();
        while (input.hasNext()) {
            Page outputPage;
            Page inputPage = input.next();
            int nullPages = 0;
            while (!operator.needsInput() && !operator.isFinished()) {
                outputPage = operator.getOutput();
                if (outputPage == null) {
                    Assert.assertTrue((nullPages < 1000000 ? 1 : 0) != 0, (String)"Too many null pages; infinite loop?");
                    ++nullPages;
                    continue;
                }
                outputPages.add((Object)outputPage);
                nullPages = 0;
            }
            if (operator.isFinished()) break;
            Assert.assertEquals((boolean)operator.needsInput(), (boolean)true);
            operator.addInput(inputPage);
            outputPage = operator.getOutput();
            if (outputPage == null) continue;
            outputPages.add((Object)outputPage);
        }
        operator.finish();
        Assert.assertEquals((boolean)operator.needsInput(), (boolean)false);
        OperatorAssertion.addRemainingOutputPages(operator, (ImmutableList.Builder<Page>)outputPages);
        return outputPages.build();
    }

    public static List<Page> toPages(Operator operator, List<Page> input) {
        Assert.assertEquals((boolean)operator.isFinished(), (boolean)false);
        Assert.assertEquals((boolean)operator.needsInput(), (boolean)true);
        Assert.assertEquals((Object)operator.getOutput(), null);
        return OperatorAssertion.toPages(operator, input.iterator());
    }

    public static List<Page> toPages(Operator operator) {
        Assert.assertEquals((boolean)operator.needsInput(), (boolean)false);
        ImmutableList.Builder outputPages = ImmutableList.builder();
        OperatorAssertion.addRemainingOutputPages(operator, (ImmutableList.Builder<Page>)outputPages);
        return outputPages.build();
    }

    private static void addRemainingOutputPages(Operator operator, ImmutableList.Builder<Page> outputPages) {
        while (true) {
            Assert.assertEquals((boolean)operator.needsInput(), (boolean)false);
            Page outputPage = operator.getOutput();
            if (outputPage == null) break;
            outputPages.add((Object)outputPage);
        }
        Assert.assertEquals((boolean)operator.isFinished(), (boolean)true);
        Assert.assertEquals((boolean)operator.needsInput(), (boolean)false);
        Assert.assertEquals((Object)operator.getOutput(), null);
    }

    public static MaterializedResult toMaterializedResult(Session session, List<Type> types, List<Page> pages) {
        MaterializedResult.Builder resultBuilder = MaterializedResult.resultBuilder((Session)session, types);
        for (Page outputPage : pages) {
            resultBuilder.page(outputPage);
        }
        return resultBuilder.build();
    }

    public static void assertOperatorEquals(Operator operator, List<Page> expected) {
        List<Page> actual = OperatorAssertion.toPages(operator);
        Assert.assertEquals((int)actual.size(), (int)expected.size());
        for (int i = 0; i < actual.size(); ++i) {
            PageAssertions.assertPageEquals(operator.getTypes(), actual.get(i), expected.get(i));
        }
    }

    public static void assertOperatorEquals(Operator operator, List<Page> input, List<Page> expected) {
        List<Page> actual = OperatorAssertion.toPages(operator, input);
        Assert.assertEquals((int)actual.size(), (int)expected.size());
        for (int i = 0; i < actual.size(); ++i) {
            PageAssertions.assertPageEquals(operator.getTypes(), actual.get(i), expected.get(i));
        }
    }

    public static void assertOperatorEquals(Operator operator, MaterializedResult expected) {
        List<Page> pages = OperatorAssertion.toPages(operator);
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(operator.getOperatorContext().getSession(), operator.getTypes(), pages);
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    public static void assertOperatorEquals(Operator operator, List<Page> input, MaterializedResult expected) {
        OperatorAssertion.assertOperatorEquals(operator, input, expected, false, (List<Integer>)ImmutableList.of());
    }

    public static void assertOperatorEquals(Operator operator, List<Page> input, MaterializedResult expected, boolean hashEnabled, List<Integer> hashChannels) {
        MaterializedResult actual;
        List<Page> pages = OperatorAssertion.toPages(operator, input);
        if (hashEnabled && !hashChannels.isEmpty()) {
            List<Page> actualPages = OperatorAssertion.dropChannel(pages, hashChannels);
            List<Type> expectedTypes = OperatorAssertion.without(operator.getTypes(), hashChannels);
            actual = OperatorAssertion.toMaterializedResult(operator.getOperatorContext().getSession(), expectedTypes, actualPages);
        } else {
            actual = OperatorAssertion.toMaterializedResult(operator.getOperatorContext().getSession(), operator.getTypes(), pages);
        }
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    public static void assertOperatorEqualsIgnoreOrder(Operator operator, List<Page> input, MaterializedResult expected) {
        OperatorAssertion.assertOperatorEqualsIgnoreOrder(operator, input, expected, false, Optional.empty());
    }

    public static void assertOperatorEqualsIgnoreOrder(Operator operator, List<Page> input, MaterializedResult expected, boolean hashEnabled, Optional<Integer> hashChannel) {
        MaterializedResult actual;
        List<Page> pages = OperatorAssertion.toPages(operator, input);
        if (hashEnabled && hashChannel.isPresent()) {
            List<Page> actualPages = OperatorAssertion.dropChannel(pages, (List<Integer>)ImmutableList.of((Object)hashChannel.get()));
            List<Type> expectedTypes = OperatorAssertion.without(operator.getTypes(), (List<Integer>)ImmutableList.of((Object)hashChannel.get()));
            actual = OperatorAssertion.toMaterializedResult(operator.getOperatorContext().getSession(), expectedTypes, actualPages);
        } else {
            actual = OperatorAssertion.toMaterializedResult(operator.getOperatorContext().getSession(), operator.getTypes(), pages);
        }
        Assertions.assertEqualsIgnoreOrder((Iterable)actual.getMaterializedRows(), (Iterable)expected.getMaterializedRows());
    }

    public static void assertOperatorEqualsIgnoreOrderWithoutHashes(Operator operator, List<Page> input, MaterializedResult expected, List<Integer> hashChannels) {
        List<Page> pages = OperatorAssertion.toPages(operator, input);
        List<Page> actualPages = OperatorAssertion.dropChannel(pages, hashChannels);
        List<Type> expectedTypes = OperatorAssertion.without(operator.getTypes(), hashChannels);
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(operator.getOperatorContext().getSession(), expectedTypes, actualPages);
        Assert.assertEquals((Collection)actual.getTypes(), (Collection)expected.getTypes());
        Assertions.assertEqualsIgnoreOrder((Iterable)actual.getMaterializedRows(), (Iterable)expected.getMaterializedRows());
    }

    static <T> List<T> without(List<T> types, List<Integer> channels) {
        types = new ArrayList<T>(types);
        int removed = 0;
        for (int hashChannel : channels) {
            types.remove(hashChannel - removed);
            ++removed;
        }
        return ImmutableList.copyOf(types);
    }

    static List<Page> dropChannel(List<Page> pages, List<Integer> channels) {
        ArrayList<Page> actualPages = new ArrayList<Page>();
        for (Page page : pages) {
            int channel = 0;
            Block[] blocks = new Block[page.getChannelCount() - channels.size()];
            for (int i = 0; i < page.getChannelCount(); ++i) {
                if (channels.contains(i)) continue;
                blocks[channel++] = page.getBlock(i);
            }
            actualPages.add(new Page(blocks));
        }
        return actualPages;
    }
}

