/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverStats;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.PipelineStats;
import com.facebook.presto.operator.TestDriverStats;
import com.facebook.presto.operator.TestOperatorStats;
import com.google.common.collect.ImmutableList;
import io.airlift.json.JsonCodec;
import io.airlift.stats.Distribution;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPipelineStats {
    public static final PipelineStats EXPECTED = new PipelineStats(true, false, 1, 2, 1, 3, 2, 4, new DataSize(5.0, DataSize.Unit.BYTE), TestPipelineStats.getTestDistribution(6), TestPipelineStats.getTestDistribution(7), new Duration(8.0, TimeUnit.NANOSECONDS), new Duration(9.0, TimeUnit.NANOSECONDS), new Duration(10.0, TimeUnit.NANOSECONDS), new Duration(11.0, TimeUnit.NANOSECONDS), new DataSize(12.0, DataSize.Unit.BYTE), 13L, new DataSize(14.0, DataSize.Unit.BYTE), 15L, new DataSize(16.0, DataSize.Unit.BYTE), 17L, (List)ImmutableList.of((Object)TestOperatorStats.EXPECTED), (List)ImmutableList.of((Object)TestDriverStats.EXPECTED));

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(PipelineStats.class);
        String json = codec.toJson((Object)EXPECTED);
        PipelineStats actual = (PipelineStats)codec.fromJson(json);
        TestPipelineStats.assertExpectedPipelineStats(actual);
    }

    public static void assertExpectedPipelineStats(PipelineStats actual) {
        Assert.assertEquals((boolean)actual.isInputPipeline(), (boolean)true);
        Assert.assertEquals((boolean)actual.isOutputPipeline(), (boolean)false);
        Assert.assertEquals((int)actual.getTotalDrivers(), (int)1);
        Assert.assertEquals((int)actual.getQueuedDrivers(), (int)2);
        Assert.assertEquals((int)actual.getQueuedPartitionedDrivers(), (int)1);
        Assert.assertEquals((int)actual.getRunningDrivers(), (int)3);
        Assert.assertEquals((int)actual.getRunningPartitionedDrivers(), (int)2);
        Assert.assertEquals((int)actual.getCompletedDrivers(), (int)4);
        Assert.assertEquals((Object)actual.getMemoryReservation(), (Object)new DataSize(5.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getQueuedTime().getCount(), (Object)6.0);
        Assert.assertEquals((Object)actual.getElapsedTime().getCount(), (Object)7.0);
        Assert.assertEquals((Object)actual.getTotalScheduledTime(), (Object)new Duration(8.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalCpuTime(), (Object)new Duration(9.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalUserTime(), (Object)new Duration(10.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalBlockedTime(), (Object)new Duration(11.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getRawInputDataSize(), (Object)new DataSize(12.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getRawInputPositions(), (long)13L);
        Assert.assertEquals((Object)actual.getProcessedInputDataSize(), (Object)new DataSize(14.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getProcessedInputPositions(), (long)15L);
        Assert.assertEquals((Object)actual.getOutputDataSize(), (Object)new DataSize(16.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getOutputPositions(), (long)17L);
        Assert.assertEquals((int)actual.getOperatorSummaries().size(), (int)1);
        TestOperatorStats.assertExpectedOperatorStats((OperatorStats)actual.getOperatorSummaries().get(0));
        Assert.assertEquals((int)actual.getDrivers().size(), (int)1);
        TestDriverStats.assertExpectedDriverStats((DriverStats)actual.getDrivers().get(0));
    }

    private static Distribution.DistributionSnapshot getTestDistribution(int count) {
        Distribution distribution = new Distribution();
        for (int i = 0; i < count; ++i) {
            distribution.add((long)i);
        }
        return distribution.snapshot();
    }
}

