/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.PipelineStats;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.operator.TestPipelineStats;
import com.google.common.collect.ImmutableList;
import io.airlift.json.JsonCodec;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTaskStats {
    public static final TaskStats EXPECTED = new TaskStats(new DateTime(1L), new DateTime(2L), new DateTime(100L), new DateTime(3L), new Duration(4.0, TimeUnit.NANOSECONDS), new Duration(5.0, TimeUnit.NANOSECONDS), 6, 7, 5, 8, 6, 10, new DataSize(11.0, DataSize.Unit.BYTE), new Duration(12.0, TimeUnit.NANOSECONDS), new Duration(13.0, TimeUnit.NANOSECONDS), new Duration(14.0, TimeUnit.NANOSECONDS), new Duration(15.0, TimeUnit.NANOSECONDS), new DataSize(16.0, DataSize.Unit.BYTE), 17L, new DataSize(18.0, DataSize.Unit.BYTE), 19L, new DataSize(20.0, DataSize.Unit.BYTE), 21L, (List)ImmutableList.of((Object)TestPipelineStats.EXPECTED));

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(TaskStats.class);
        String json = codec.toJson((Object)EXPECTED);
        TaskStats actual = (TaskStats)codec.fromJson(json);
        TestTaskStats.assertExpectedTaskStats(actual);
    }

    public static void assertExpectedTaskStats(TaskStats actual) {
        Assert.assertEquals((Object)actual.getCreateTime(), (Object)new DateTime(1L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getFirstStartTime(), (Object)new DateTime(2L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getLastStartTime(), (Object)new DateTime(100L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getEndTime(), (Object)new DateTime(3L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getElapsedTime(), (Object)new Duration(4.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getQueuedTime(), (Object)new Duration(5.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((int)actual.getTotalDrivers(), (int)6);
        Assert.assertEquals((int)actual.getQueuedDrivers(), (int)7);
        Assert.assertEquals((int)actual.getQueuedPartitionedDrivers(), (int)5);
        Assert.assertEquals((int)actual.getRunningDrivers(), (int)8);
        Assert.assertEquals((int)actual.getRunningPartitionedDrivers(), (int)6);
        Assert.assertEquals((int)actual.getCompletedDrivers(), (int)10);
        Assert.assertEquals((Object)actual.getMemoryReservation(), (Object)new DataSize(11.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getTotalScheduledTime(), (Object)new Duration(12.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalCpuTime(), (Object)new Duration(13.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalUserTime(), (Object)new Duration(14.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalBlockedTime(), (Object)new Duration(15.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getRawInputDataSize(), (Object)new DataSize(16.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getRawInputPositions(), (long)17L);
        Assert.assertEquals((Object)actual.getProcessedInputDataSize(), (Object)new DataSize(18.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getProcessedInputPositions(), (long)19L);
        Assert.assertEquals((Object)actual.getOutputDataSize(), (Object)new DataSize(20.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getOutputPositions(), (long)21L);
        Assert.assertEquals((int)actual.getPipelines().size(), (int)1);
        TestPipelineStats.assertExpectedPipelineStats((PipelineStats)actual.getPipelines().get(0));
    }
}

