/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractTestApproximateAggregationFunction;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.util.ImmutableCollectors;
import java.util.List;
import java.util.Objects;

public class TestApproximateLongSumAggregation
extends AbstractTestApproximateAggregationFunction {
    @Override
    protected Type getType() {
        return BigintType.BIGINT;
    }

    @Override
    protected Double getExpectedValue(List<Number> values) {
        List nonNull = (List)values.stream().filter(Objects::nonNull).collect(ImmutableCollectors.toImmutableList());
        if (nonNull.isEmpty()) {
            return null;
        }
        double sum = 0.0;
        for (Number value : nonNull) {
            sum += (double)value.longValue();
        }
        return sum;
    }

    @Override
    protected String getFunctionName() {
        return "sum";
    }
}

