/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestArbitraryAggregation {
    private static final MetadataManager metadata = new MetadataManager();

    @Test
    public void testAllRegistered() {
        ImmutableSet allTypes = FluentIterable.from((Iterable)metadata.getTypeManager().getTypes()).toSet();
        for (Type valueType : allTypes) {
            Assert.assertNotNull((Object)metadata.getExactFunction(new Signature("arbitrary", valueType.getTypeSignature(), new TypeSignature[]{valueType.getTypeSignature()})));
        }
    }

    @Test
    public void testNullBoolean() throws Exception {
        InternalAggregationFunction booleanAgg = metadata.getExactFunction(new Signature("arbitrary", "boolean", new String[]{"boolean"})).getAggregationFunction();
        AggregationTestUtils.assertAggregation(booleanAgg, 1.0, null, TestArbitraryAggregation.createPage(new Boolean[]{null}));
    }

    @Test
    public void testValidBoolean() throws Exception {
        InternalAggregationFunction booleanAgg = metadata.getExactFunction(new Signature("arbitrary", "boolean", new String[]{"boolean"})).getAggregationFunction();
        AggregationTestUtils.assertAggregation(booleanAgg, 1.0, (Object)true, TestArbitraryAggregation.createPage(new Boolean[]{true, true}));
    }

    @Test
    public void testNullLong() throws Exception {
        InternalAggregationFunction longAgg = metadata.getExactFunction(new Signature("arbitrary", "bigint", new String[]{"bigint"})).getAggregationFunction();
        AggregationTestUtils.assertAggregation(longAgg, 1.0, null, TestArbitraryAggregation.createPage(new Long[]{null, null}));
    }

    @Test
    public void testValidLong() throws Exception {
        InternalAggregationFunction longAgg = metadata.getExactFunction(new Signature("arbitrary", "bigint", new String[]{"bigint"})).getAggregationFunction();
        AggregationTestUtils.assertAggregation(longAgg, 1.0, (Object)1L, TestArbitraryAggregation.createPage(new Long[]{1L, null}));
    }

    @Test
    public void testNullDouble() throws Exception {
        InternalAggregationFunction doubleAgg = metadata.getExactFunction(new Signature("arbitrary", "double", new String[]{"double"})).getAggregationFunction();
        AggregationTestUtils.assertAggregation(doubleAgg, 1.0, null, TestArbitraryAggregation.createPage(new Double[]{null, null}));
    }

    @Test
    public void testValidDouble() throws Exception {
        InternalAggregationFunction doubleAgg = metadata.getExactFunction(new Signature("arbitrary", "double", new String[]{"double"})).getAggregationFunction();
        AggregationTestUtils.assertAggregation(doubleAgg, 1.0, (Object)2.0, TestArbitraryAggregation.createPage(new Double[]{null, 2.0}));
    }

    @Test
    public void testNullString() throws Exception {
        InternalAggregationFunction stringAgg = metadata.getExactFunction(new Signature("arbitrary", "varchar", new String[]{"varchar"})).getAggregationFunction();
        AggregationTestUtils.assertAggregation(stringAgg, 1.0, null, TestArbitraryAggregation.createPage(new String[]{null, null}));
    }

    @Test
    public void testValidString() throws Exception {
        InternalAggregationFunction stringAgg = metadata.getExactFunction(new Signature("arbitrary", "varchar", new String[]{"varchar"})).getAggregationFunction();
        AggregationTestUtils.assertAggregation(stringAgg, 1.0, (Object)"a", TestArbitraryAggregation.createPage(new String[]{"a", "a"}));
    }

    private static Page createPage(Boolean[] values) {
        return new Page(new Block[]{BlockAssertions.createBooleansBlock(values)});
    }

    private static Page createPage(Long[] values) {
        return new Page(new Block[]{BlockAssertions.createLongsBlock(values)});
    }

    private static Page createPage(Double[] values) {
        return new Page(new Block[]{BlockAssertions.createDoublesBlock(values)});
    }

    private static Page createPage(String[] values) {
        return new Page(new Block[]{BlockAssertions.createStringsBlock(values)});
    }
}

