/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.DoubleType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;

public class TestDoubleStdDevPopAggregation
extends AbstractTestAggregationFunction {
    @Override
    public Block getSequenceBlock(int start, int length) {
        BlockBuilder blockBuilder = DoubleType.DOUBLE.createBlockBuilder(new BlockBuilderStatus());
        for (int i = start; i < start + length; ++i) {
            DoubleType.DOUBLE.writeDouble(blockBuilder, (double)i);
        }
        return blockBuilder.build();
    }

    @Override
    public Number getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        double[] values = new double[length];
        for (int i = 0; i < length; ++i) {
            values[i] = start + i;
        }
        StandardDeviation stdDev = new StandardDeviation(false);
        return stdDev.evaluate(values);
    }

    @Override
    protected String getFunctionName() {
        return "stddev_pop";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"double");
    }
}

