/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractTestApproximateAggregationFunction;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import java.util.List;

public class TestLongApproximateAverageAggregation
extends AbstractTestApproximateAggregationFunction {
    @Override
    protected Type getType() {
        return BigintType.BIGINT;
    }

    @Override
    protected Double getExpectedValue(List<Number> values) {
        int length = 0;
        long sum = 0L;
        for (Number value : values) {
            if (value == null) continue;
            ++length;
            sum += value.longValue();
        }
        if (length == 0) {
            return null;
        }
        return (double)sum / (double)length;
    }

    @Override
    protected String getFunctionName() {
        return "avg";
    }
}

