/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestStringFunctions {
    private FunctionAssertions functionAssertions;

    @BeforeClass
    public void setUp() {
        this.functionAssertions = new FunctionAssertions();
    }

    @Test
    public void testChr() {
        this.assertFunction("CHR(65)", "A");
        this.assertFunction("CHR(9731)", "\u2603");
        this.assertFunction("CHR(131210)", new String(Character.toChars(131210)));
        this.assertFunction("CHR(0)", "\u0000");
        this.assertInvalidFunction("CHR(-1)", "Not a valid Unicode code point: -1");
        this.assertInvalidFunction("CHR(1234567)", "Not a valid Unicode code point: 1234567");
        this.assertInvalidFunction("CHR(8589934592)", "Not a valid Unicode code point: 8589934592");
    }

    @Test
    public void testConcat() {
        this.assertFunction("CONCAT('hello', ' world')", "hello world");
        this.assertFunction("CONCAT('', '')", "");
        this.assertFunction("CONCAT('what', '')", "what");
        this.assertFunction("CONCAT('', 'what')", "what");
        this.assertFunction("CONCAT(CONCAT('this', ' is'), ' cool')", "this is cool");
        this.assertFunction("CONCAT('this', CONCAT(' is', ' cool'))", "this is cool");
    }

    @Test
    public void testLength() {
        this.assertFunction("LENGTH('')", 0);
        this.assertFunction("LENGTH('hello')", 5);
        this.assertFunction("LENGTH('Quadratically')", 13);
    }

    @Test
    public void testReplace() {
        this.assertFunction("REPLACE('aaa', 'a', 'aa')", "aaaaaa");
        this.assertFunction("REPLACE('abcdefabcdef', 'cd', 'XX')", "abXXefabXXef");
        this.assertFunction("REPLACE('abcdefabcdef', 'cd')", "abefabef");
        this.assertFunction("REPLACE('123123tech', '123')", "tech");
        this.assertFunction("REPLACE('123tech123', '123')", "tech");
        this.assertFunction("REPLACE('222tech', '2', '3')", "333tech");
        this.assertFunction("REPLACE('0000123', '0')", "123");
        this.assertFunction("REPLACE('0000123', '0', ' ')", "    123");
        this.assertFunction("REPLACE('foo', '')", "foo");
        this.assertFunction("REPLACE('foo', '', '')", "foo");
        this.assertFunction("REPLACE('', '')", "");
        this.assertFunction("REPLACE('', '', '')", "");
    }

    @Test
    public void testReverse() {
        this.assertFunction("REVERSE('')", "");
        this.assertFunction("REVERSE('hello')", "olleh");
        this.assertFunction("REVERSE('Quadratically')", "yllacitardauQ");
        this.assertFunction("REVERSE('racecar')", "racecar");
    }

    @Test
    public void testStringPosition() {
        this.assertFunction("STRPOS('high', 'ig')", 2);
        this.assertFunction("STRPOS('high', 'igx')", 0);
        this.assertFunction("STRPOS('Quadratically', 'a')", 3);
        this.assertFunction("STRPOS('foobar', 'foobar')", 1);
        this.assertFunction("STRPOS('foobar', 'obar')", 3);
        this.assertFunction("STRPOS('zoo!', '!')", 4);
        this.assertFunction("STRPOS('x', '')", 1);
        this.assertFunction("STRPOS('', '')", 1);
    }

    @Test
    public void testSubstring() {
        this.assertFunction("SUBSTR('Quadratically', 5)", "ratically");
        this.assertFunction("SUBSTR('Quadratically', 50)", "");
        this.assertFunction("SUBSTR('Quadratically', -5)", "cally");
        this.assertFunction("SUBSTR('Quadratically', -50)", "");
        this.assertFunction("SUBSTR('Quadratically', 0)", "");
        this.assertFunction("SUBSTR('Quadratically', 5, 6)", "ratica");
        this.assertFunction("SUBSTR('Quadratically', 5, 10)", "ratically");
        this.assertFunction("SUBSTR('Quadratically', 5, 50)", "ratically");
        this.assertFunction("SUBSTR('Quadratically', 50, 10)", "");
        this.assertFunction("SUBSTR('Quadratically', -5, 4)", "call");
        this.assertFunction("SUBSTR('Quadratically', -5, 40)", "cally");
        this.assertFunction("SUBSTR('Quadratically', -50, 4)", "");
        this.assertFunction("SUBSTR('Quadratically', 0, 4)", "");
        this.assertFunction("SUBSTR('Quadratically', 5, 0)", "");
        this.assertFunction("SUBSTRING('Quadratically' FROM 5)", "ratically");
        this.assertFunction("SUBSTRING('Quadratically' FROM 50)", "");
        this.assertFunction("SUBSTRING('Quadratically' FROM -5)", "cally");
        this.assertFunction("SUBSTRING('Quadratically' FROM -50)", "");
        this.assertFunction("SUBSTRING('Quadratically' FROM 0)", "");
        this.assertFunction("SUBSTRING('Quadratically' FROM 5 FOR 6)", "ratica");
        this.assertFunction("SUBSTRING('Quadratically' FROM 5 FOR 50)", "ratically");
    }

    @Test
    public void testSplitPart() {
        this.assertFunction("SPLIT_PART('abc-@-def-@-ghi', '-@-', 1)", "abc");
        this.assertFunction("SPLIT_PART('abc-@-def-@-ghi', '-@-', 2)", "def");
        this.assertFunction("SPLIT_PART('abc-@-def-@-ghi', '-@-', 3)", "ghi");
        this.assertFunction("SPLIT_PART('abc-@-def-@-ghi', '-@-', 4)", null);
        this.assertFunction("SPLIT_PART('abc-@-def-@-ghi', '-@-', 99)", null);
        this.assertFunction("SPLIT_PART('abc', 'abc', 1)", "");
        this.assertFunction("SPLIT_PART('abc', 'abc', 2)", "");
        this.assertFunction("SPLIT_PART('abc', 'abc', 3)", null);
        this.assertFunction("SPLIT_PART('abc', '-@-', 1)", "abc");
        this.assertFunction("SPLIT_PART('abc', '-@-', 2)", null);
        this.assertFunction("SPLIT_PART('', 'abc', 1)", "");
        this.assertFunction("SPLIT_PART('', '', 1)", null);
        this.assertFunction("SPLIT_PART('abc', '', 1)", "a");
        this.assertFunction("SPLIT_PART('abc', '', 2)", "b");
        this.assertFunction("SPLIT_PART('abc', '', 3)", "c");
        this.assertFunction("SPLIT_PART('abc', '', 4)", null);
        this.assertFunction("SPLIT_PART('abc', '', 99)", null);
        this.assertFunction("SPLIT_PART('abc', 'abcd', 1)", "abc");
        this.assertFunction("SPLIT_PART('abc', 'abcd', 2)", null);
        this.assertFunction("SPLIT_PART('abc--@--def', '-@-', 1)", "abc-");
        this.assertFunction("SPLIT_PART('abc--@--def', '-@-', 2)", "-def");
        this.assertFunction("SPLIT_PART('abc-@-@-@-def', '-@-', 1)", "abc");
        this.assertFunction("SPLIT_PART('abc-@-@-@-def', '-@-', 2)", "@");
        this.assertFunction("SPLIT_PART('abc-@-@-@-def', '-@-', 3)", "def");
        this.assertFunction("SPLIT_PART(' ', ' ', 1)", "");
        this.assertFunction("SPLIT_PART('abcdddddef', 'dd', 1)", "abc");
        this.assertFunction("SPLIT_PART('abcdddddef', 'dd', 2)", "");
        this.assertFunction("SPLIT_PART('abcdddddef', 'dd', 3)", "def");
        this.assertFunction("SPLIT_PART('a/b/c', '/', 4)", null);
        this.assertFunction("SPLIT_PART('a/b/c/', '/', 4)", "");
        this.assertInvalidFunction("SPLIT_PART('abc', '', 0)", "Index must be greater than zero");
        this.assertInvalidFunction("SPLIT_PART('abc', '', -1)", "Index must be greater than zero");
    }

    @Test(expectedExceptions={RuntimeException.class})
    public void testSplitPartInvalid() {
        this.assertFunction("SPLIT_PART('abc-@-def-@-ghi', '-@-', 0)", "");
    }

    @Test
    public void testLeftTrim() {
        this.assertFunction("LTRIM('')", "");
        this.assertFunction("LTRIM('   ')", "");
        this.assertFunction("LTRIM('  hello  ')", "hello  ");
        this.assertFunction("LTRIM('  hello')", "hello");
        this.assertFunction("LTRIM('hello  ')", "hello  ");
        this.assertFunction("LTRIM(' hello world ')", "hello world ");
    }

    @Test
    public void testRightTrim() {
        this.assertFunction("RTRIM('')", "");
        this.assertFunction("RTRIM('   ')", "");
        this.assertFunction("RTRIM('  hello  ')", "  hello");
        this.assertFunction("RTRIM('  hello')", "  hello");
        this.assertFunction("RTRIM('hello  ')", "hello");
        this.assertFunction("RTRIM(' hello world ')", " hello world");
    }

    @Test
    public void testTrim() {
        this.assertFunction("TRIM('')", "");
        this.assertFunction("TRIM('   ')", "");
        this.assertFunction("TRIM('  hello  ')", "hello");
        this.assertFunction("TRIM('  hello')", "hello");
        this.assertFunction("TRIM('hello  ')", "hello");
        this.assertFunction("TRIM(' hello world ')", "hello world");
    }

    @Test
    public void testLower() {
        this.assertFunction("LOWER('')", "");
        this.assertFunction("LOWER('Hello World')", "hello world");
        this.assertFunction("LOWER('WHAT!!')", "what!!");
    }

    @Test
    public void testUpper() {
        this.assertFunction("UPPER('')", "");
        this.assertFunction("UPPER('Hello World')", "HELLO WORLD");
        this.assertFunction("UPPER('what!!')", "WHAT!!");
    }

    private void assertFunction(String projection, Object expected) {
        this.functionAssertions.assertFunction(projection, expected);
    }

    private void assertInvalidFunction(String projection, String message) {
        try {
            this.assertFunction(projection, null);
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.INVALID_FUNCTION_ARGUMENT.toErrorCode());
            Assert.assertEquals((String)e.getMessage(), (String)message);
        }
    }
}

