/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.client.QueryResults;
import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.server.testing.TestingPrestoServer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.JsonResponseHandler;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StaticBodyGenerator;
import io.airlift.http.client.StatusResponseHandler;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.json.JsonCodec;
import io.airlift.testing.Closeables;
import java.io.Closeable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestServer {
    private TestingPrestoServer server;
    private HttpClient client;

    @BeforeMethod
    public void setup() throws Exception {
        this.server = new TestingPrestoServer();
        this.client = new JettyHttpClient();
    }

    @AfterMethod
    public void teardown() {
        Closeables.closeQuietly((Closeable[])new Closeable[]{this.server});
        Closeables.closeQuietly((Closeable[])new Closeable[]{this.client});
    }

    @Test
    public void testServerStarts() throws Exception {
        StatusResponseHandler.StatusResponse response = (StatusResponseHandler.StatusResponse)this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/query")).build(), (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        Assert.assertEquals((int)response.getStatusCode(), (int)Response.Status.OK.getStatusCode());
    }

    @Test
    public void testQuery() throws Exception {
        Request request = Request.Builder.preparePost().setUri(this.uriFor("/v1/statement")).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)"show catalogs", (Charset)StandardCharsets.UTF_8)).setHeader("X-Presto-User", "user").setHeader("X-Presto-Source", "source").setHeader("X-Presto-Catalog", "catalog").setHeader("X-Presto-Schema", "schema").addHeader("X-Presto-Session", "system-name=system-value").addHeader("X-Presto-Session", "catalog.name=catalog-value").addHeader("X-Presto-Session", "catalog2.name=catalog2-value").build();
        QueryResults queryResults = (QueryResults)this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.jsonCodec(QueryResults.class)));
        QueryInfo queryInfo = this.server.getQueryManager().getQueryInfo(new QueryId(queryResults.getId()));
        Assert.assertEquals((Map)queryInfo.getSession().getSystemProperties(), (Map)ImmutableMap.of((Object)"system-name", (Object)"system-value"));
        Assert.assertEquals((Map)queryInfo.getSession().getCatalogProperties(), (Map)ImmutableMap.of((Object)"catalog", (Object)ImmutableMap.of((Object)"name", (Object)"catalog-value"), (Object)"catalog2", (Object)ImmutableMap.of((Object)"name", (Object)"catalog2-value")));
        ImmutableList.Builder data = ImmutableList.builder();
        if (queryResults.getData() != null) {
            data.addAll(queryResults.getData());
        }
        while (queryResults.getNextUri() != null) {
            queryResults = (QueryResults)this.client.execute(Request.Builder.prepareGet().setUri(queryResults.getNextUri()).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.jsonCodec(QueryResults.class)));
            if (queryResults.getData() == null) continue;
            data.addAll(queryResults.getData());
        }
        ImmutableList rows = data.build();
        Assert.assertEquals((int)rows.size(), (int)0);
    }

    public URI uriFor(String path) {
        return HttpUriBuilder.uriBuilderFrom((URI)this.server.getBaseUrl()).replacePath(path).build();
    }
}

