/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntervalDayTimeType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.ExpressionFormatter;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolResolver;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.StringLiteral;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.charset.StandardCharsets;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.intellij.lang.annotations.Language;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestExpressionInterpreter {
    private static final Map<Symbol, Type> SYMBOL_TYPES = ImmutableMap.builder().put((Object)new Symbol("bound_long"), (Object)BigintType.BIGINT).put((Object)new Symbol("bound_string"), (Object)VarcharType.VARCHAR).put((Object)new Symbol("bound_double"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("bound_boolean"), (Object)BooleanType.BOOLEAN).put((Object)new Symbol("bound_date"), (Object)DateType.DATE).put((Object)new Symbol("bound_time"), (Object)TimeType.TIME).put((Object)new Symbol("bound_timestamp"), (Object)TimestampType.TIMESTAMP).put((Object)new Symbol("bound_pattern"), (Object)VarcharType.VARCHAR).put((Object)new Symbol("bound_null_string"), (Object)VarcharType.VARCHAR).put((Object)new Symbol("time"), (Object)BigintType.BIGINT).put((Object)new Symbol("unbound_long"), (Object)BigintType.BIGINT).put((Object)new Symbol("unbound_long2"), (Object)BigintType.BIGINT).put((Object)new Symbol("unbound_string"), (Object)VarcharType.VARCHAR).put((Object)new Symbol("unbound_double"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("unbound_boolean"), (Object)BooleanType.BOOLEAN).put((Object)new Symbol("unbound_date"), (Object)DateType.DATE).put((Object)new Symbol("unbound_time"), (Object)TimeType.TIME).put((Object)new Symbol("unbound_timestamp"), (Object)TimestampType.TIMESTAMP).put((Object)new Symbol("unbound_interval"), (Object)IntervalDayTimeType.INTERVAL_DAY_TIME).put((Object)new Symbol("unbound_pattern"), (Object)VarcharType.VARCHAR).put((Object)new Symbol("unbound_null_string"), (Object)VarcharType.VARCHAR).build();
    private static final SqlParser SQL_PARSER = new SqlParser();
    private static final Metadata METADATA = new MetadataManager();

    @Test
    public void testAnd() throws Exception {
        TestExpressionInterpreter.assertOptimizedEquals("true and false", "false");
        TestExpressionInterpreter.assertOptimizedEquals("false and true", "false");
        TestExpressionInterpreter.assertOptimizedEquals("false and false", "false");
        TestExpressionInterpreter.assertOptimizedEquals("true and null", "null");
        TestExpressionInterpreter.assertOptimizedEquals("false and null", "false");
        TestExpressionInterpreter.assertOptimizedEquals("null and true", "null");
        TestExpressionInterpreter.assertOptimizedEquals("null and false", "false");
        TestExpressionInterpreter.assertOptimizedEquals("null and null", "null");
        TestExpressionInterpreter.assertOptimizedEquals("unbound_string='z' and true", "unbound_string='z'");
        TestExpressionInterpreter.assertOptimizedEquals("unbound_string='z' and false", "false");
        TestExpressionInterpreter.assertOptimizedEquals("true and unbound_string='z'", "unbound_string='z'");
        TestExpressionInterpreter.assertOptimizedEquals("false and unbound_string='z'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("bound_string='z' and bound_long=1+1", "bound_string='z' and bound_long=2");
    }

    @Test
    public void testOr() throws Exception {
        TestExpressionInterpreter.assertOptimizedEquals("true or true", "true");
        TestExpressionInterpreter.assertOptimizedEquals("true or false", "true");
        TestExpressionInterpreter.assertOptimizedEquals("false or true", "true");
        TestExpressionInterpreter.assertOptimizedEquals("false or false", "false");
        TestExpressionInterpreter.assertOptimizedEquals("true or null", "true");
        TestExpressionInterpreter.assertOptimizedEquals("null or true", "true");
        TestExpressionInterpreter.assertOptimizedEquals("null or null", "null");
        TestExpressionInterpreter.assertOptimizedEquals("false or null", "null");
        TestExpressionInterpreter.assertOptimizedEquals("null or false", "null");
        TestExpressionInterpreter.assertOptimizedEquals("bound_string='z' or true", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_string='z' or false", "bound_string='z'");
        TestExpressionInterpreter.assertOptimizedEquals("true or bound_string='z'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("false or bound_string='z'", "bound_string='z'");
        TestExpressionInterpreter.assertOptimizedEquals("bound_string='z' or bound_long=1+1", "bound_string='z' or bound_long=2");
    }

    @Test
    public void testComparison() throws Exception {
        TestExpressionInterpreter.assertOptimizedEquals("null = null", "null");
        TestExpressionInterpreter.assertOptimizedEquals("'a' = 'b'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'a' = 'a'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'a' = null", "null");
        TestExpressionInterpreter.assertOptimizedEquals("null = 'a'", "null");
        TestExpressionInterpreter.assertOptimizedEquals("bound_long = 1234", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_double = 12.34", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_string = 'hello'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_long = unbound_long", "1234 = unbound_long");
        TestExpressionInterpreter.assertOptimizedEquals("10151082135029368 = 10151082135029369", "false");
    }

    @Test
    public void testIsDistinctFrom() throws Exception {
        TestExpressionInterpreter.assertOptimizedEquals("null is distinct from null", "false");
        TestExpressionInterpreter.assertOptimizedEquals("3 is distinct from 4", "true");
        TestExpressionInterpreter.assertOptimizedEquals("3 is distinct from 3", "false");
        TestExpressionInterpreter.assertOptimizedEquals("3 is distinct from null", "true");
        TestExpressionInterpreter.assertOptimizedEquals("null is distinct from 3", "true");
        TestExpressionInterpreter.assertOptimizedEquals("10151082135029368 is distinct from 10151082135029369", "true");
    }

    @Test
    public void testIsNull() throws Exception {
        TestExpressionInterpreter.assertOptimizedEquals("null is null", "true");
        TestExpressionInterpreter.assertOptimizedEquals("1 is null", "false");
        TestExpressionInterpreter.assertOptimizedEquals("1.0 is null", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'a' is null", "false");
        TestExpressionInterpreter.assertOptimizedEquals("true is null", "false");
        TestExpressionInterpreter.assertOptimizedEquals("null+1 is null", "true");
        TestExpressionInterpreter.assertOptimizedEquals("unbound_string is null", "unbound_string is null");
        TestExpressionInterpreter.assertOptimizedEquals("unbound_long+(1+1) is null", "unbound_long+2 is null");
    }

    @Test
    public void testIsNotNull() throws Exception {
        TestExpressionInterpreter.assertOptimizedEquals("null is not null", "false");
        TestExpressionInterpreter.assertOptimizedEquals("1 is not null", "true");
        TestExpressionInterpreter.assertOptimizedEquals("1.0 is not null", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'a' is not null", "true");
        TestExpressionInterpreter.assertOptimizedEquals("true is not null", "true");
        TestExpressionInterpreter.assertOptimizedEquals("null+1 is not null", "false");
        TestExpressionInterpreter.assertOptimizedEquals("unbound_string is not null", "unbound_string is not null");
        TestExpressionInterpreter.assertOptimizedEquals("unbound_long+(1+1) is not null", "unbound_long+2 is not null");
    }

    @Test
    public void testNullIf() throws Exception {
        TestExpressionInterpreter.assertOptimizedEquals("nullif(true, true)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(true, false)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(null, false)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(true, null)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("nullif('a', 'a')", "null");
        TestExpressionInterpreter.assertOptimizedEquals("nullif('a', 'b')", "'a'");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(null, 'b')", "null");
        TestExpressionInterpreter.assertOptimizedEquals("nullif('a', null)", "'a'");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(1, 1)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(1, 2)", "1");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(1.0, 1)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(1.1, 1)", "1.1");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(1.1, 1.1)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(1, 2-1)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(null, null)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(1, null)", "1");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(unbound_long, 1)", "nullif(unbound_long, 1)");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(unbound_long, unbound_long2)", "nullif(unbound_long, unbound_long2)");
        TestExpressionInterpreter.assertOptimizedEquals("nullif(unbound_long, unbound_long2+(1+1))", "nullif(unbound_long, unbound_long2+2)");
    }

    @Test
    public void testNegative() throws Exception {
        TestExpressionInterpreter.assertOptimizedEquals("-(1)", "-1");
        TestExpressionInterpreter.assertOptimizedEquals("-(unbound_long+1)", "-(unbound_long+1)");
        TestExpressionInterpreter.assertOptimizedEquals("-(1+1)", "-2");
        TestExpressionInterpreter.assertOptimizedEquals("-(null)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("-(unbound_long+(1+1))", "-(unbound_long+2)");
    }

    @Test
    public void testNot() throws Exception {
        TestExpressionInterpreter.assertOptimizedEquals("not true", "false");
        TestExpressionInterpreter.assertOptimizedEquals("not false", "true");
        TestExpressionInterpreter.assertOptimizedEquals("not null", "null");
        TestExpressionInterpreter.assertOptimizedEquals("not 1=1", "false");
        TestExpressionInterpreter.assertOptimizedEquals("not 1!=1", "true");
        TestExpressionInterpreter.assertOptimizedEquals("not unbound_long=1", "not unbound_long=1");
        TestExpressionInterpreter.assertOptimizedEquals("not unbound_long=(1+1)", "not unbound_long=2");
    }

    @Test
    public void testFunctionCall() throws Exception {
        TestExpressionInterpreter.assertOptimizedEquals("abs(-5)", "5");
        TestExpressionInterpreter.assertOptimizedEquals("abs(-10-5)", "15");
        TestExpressionInterpreter.assertOptimizedEquals("abs(-bound_long + 1)", "1233");
        TestExpressionInterpreter.assertOptimizedEquals("abs(-bound_long)", "1234");
        TestExpressionInterpreter.assertOptimizedEquals("abs(unbound_long)", "abs(unbound_long)");
        TestExpressionInterpreter.assertOptimizedEquals("abs(unbound_long + 1)", "abs(unbound_long + 1)");
    }

    @Test
    public void testNonDeterministicFunctionCall() throws Exception {
        TestExpressionInterpreter.assertOptimizedEquals("random()", "random()");
        Object value = TestExpressionInterpreter.evaluate("random()");
        Assert.assertTrue((boolean)(value instanceof Double));
        double randomValue = (Double)value;
        Assert.assertTrue((0.0 <= randomValue && randomValue < 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void testBetween() throws Exception {
        TestExpressionInterpreter.assertOptimizedEquals("3 between 2 and 4", "true");
        TestExpressionInterpreter.assertOptimizedEquals("2 between 3 and 4", "false");
        TestExpressionInterpreter.assertOptimizedEquals("null between 2 and 4", "null");
        TestExpressionInterpreter.assertOptimizedEquals("3 between null and 4", "null");
        TestExpressionInterpreter.assertOptimizedEquals("3 between 2 and null", "null");
        TestExpressionInterpreter.assertOptimizedEquals("'c' between 'b' and 'd'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'b' between 'c' and 'd'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("null between 'b' and 'd'", "null");
        TestExpressionInterpreter.assertOptimizedEquals("'c' between null and 'd'", "null");
        TestExpressionInterpreter.assertOptimizedEquals("'c' between 'b' and null", "null");
        TestExpressionInterpreter.assertOptimizedEquals("bound_long between 1000 and 2000", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_long between 3 and 4", "false");
        TestExpressionInterpreter.assertOptimizedEquals("bound_string between 'e' and 'i'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_string between 'a' and 'b'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("bound_long between unbound_long and 2000 + 1", "1234 between unbound_long and 2001");
        TestExpressionInterpreter.assertOptimizedEquals("bound_string between unbound_string and 'bar'", "'hello' between unbound_string and 'bar'");
    }

    @Test
    public void testExtract() {
        DateTime dateTime = new DateTime(2001, 8, 22, 3, 4, 5, 321, DateTimeZone.UTC);
        double seconds = (double)dateTime.getMillis() / 1000.0;
        TestExpressionInterpreter.assertOptimizedEquals("extract (YEAR from from_unixtime(" + seconds + "))", "2001");
        TestExpressionInterpreter.assertOptimizedEquals("extract (QUARTER from from_unixtime(" + seconds + "))", "3");
        TestExpressionInterpreter.assertOptimizedEquals("extract (MONTH from from_unixtime(" + seconds + "))", "8");
        TestExpressionInterpreter.assertOptimizedEquals("extract (WEEK from from_unixtime(" + seconds + "))", "34");
        TestExpressionInterpreter.assertOptimizedEquals("extract (DOW from from_unixtime(" + seconds + "))", "3");
        TestExpressionInterpreter.assertOptimizedEquals("extract (DOY from from_unixtime(" + seconds + "))", "234");
        TestExpressionInterpreter.assertOptimizedEquals("extract (DAY from from_unixtime(" + seconds + "))", "22");
        TestExpressionInterpreter.assertOptimizedEquals("extract (HOUR from from_unixtime(" + seconds + "))", "3");
        TestExpressionInterpreter.assertOptimizedEquals("extract (MINUTE from from_unixtime(" + seconds + "))", "4");
        TestExpressionInterpreter.assertOptimizedEquals("extract (SECOND from from_unixtime(" + seconds + "))", "5");
        TestExpressionInterpreter.assertOptimizedEquals("extract (TIMEZONE_HOUR from from_unixtime(" + seconds + ", 7, 9))", "7");
        TestExpressionInterpreter.assertOptimizedEquals("extract (TIMEZONE_MINUTE from from_unixtime(" + seconds + ", 7, 9))", "9");
        TestExpressionInterpreter.assertOptimizedEquals("extract (YEAR from bound_timestamp)", "2001");
        TestExpressionInterpreter.assertOptimizedEquals("extract (QUARTER from bound_timestamp)", "3");
        TestExpressionInterpreter.assertOptimizedEquals("extract (MONTH from bound_timestamp)", "8");
        TestExpressionInterpreter.assertOptimizedEquals("extract (WEEK from bound_timestamp)", "34");
        TestExpressionInterpreter.assertOptimizedEquals("extract (DOW from bound_timestamp)", "3");
        TestExpressionInterpreter.assertOptimizedEquals("extract (DOY from bound_timestamp)", "234");
        TestExpressionInterpreter.assertOptimizedEquals("extract (DAY from bound_timestamp)", "22");
        TestExpressionInterpreter.assertOptimizedEquals("extract (HOUR from bound_timestamp)", "3");
        TestExpressionInterpreter.assertOptimizedEquals("extract (MINUTE from bound_timestamp)", "4");
        TestExpressionInterpreter.assertOptimizedEquals("extract (SECOND from bound_timestamp)", "5");
        TestExpressionInterpreter.assertOptimizedEquals("extract (YEAR from unbound_timestamp)", "extract (YEAR from unbound_timestamp)");
        TestExpressionInterpreter.assertOptimizedEquals("extract (SECOND from bound_timestamp + INTERVAL '3' SECOND)", "8");
    }

    @Test
    public void testIn() throws Exception {
        TestExpressionInterpreter.assertOptimizedEquals("3 in (2, 4, 3, 5)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("3 in (2, 4, 9, 5)", "false");
        TestExpressionInterpreter.assertOptimizedEquals("3 in (2, null, 3, 5)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'foo' in ('bar', 'baz', 'foo', 'blah')", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'foo' in ('bar', 'baz', 'buz', 'blah')", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'foo' in ('bar', null, 'foo', 'blah')", "true");
        TestExpressionInterpreter.assertOptimizedEquals("null in (2, null, 3, 5)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("3 in (2, null)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("bound_long in (2, 1234, 3, 5)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_long in (2, 4, 3, 5)", "false");
        TestExpressionInterpreter.assertOptimizedEquals("1234 in (2, bound_long, 3, 5)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("99 in (2, bound_long, 3, 5)", "false");
        TestExpressionInterpreter.assertOptimizedEquals("bound_long in (2, bound_long, 3, 5)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_string in ('bar', 'hello', 'foo', 'blah')", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_string in ('bar', 'baz', 'foo', 'blah')", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'hello' in ('bar', bound_string, 'foo', 'blah')", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'baz' in ('bar', bound_string, 'foo', 'blah')", "false");
        TestExpressionInterpreter.assertOptimizedEquals("bound_long in (2, 1234, unbound_long, 5)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_string in ('bar', 'hello', unbound_string, 'blah')", "true");
        TestExpressionInterpreter.assertOptimizedEquals("bound_long in (2, 4, unbound_long, unbound_long2, 9)", "1234 in (unbound_long, unbound_long2)");
        TestExpressionInterpreter.assertOptimizedEquals("unbound_long in (2, 4, bound_long, unbound_long2, 5)", "unbound_long in (2, 4, 1234, unbound_long2, 5)");
    }

    @Test
    public void testCurrentTimestamp() throws Exception {
        double current = (double)SessionTestUtils.TEST_SESSION.getStartTime() / 1000.0;
        TestExpressionInterpreter.assertOptimizedEquals("current_timestamp = from_unixtime(" + current + ")", "true");
        double future = current + (double)TimeUnit.MINUTES.toSeconds(1L);
        TestExpressionInterpreter.assertOptimizedEquals("current_timestamp > from_unixtime(" + future + ")", "false");
    }

    @Test
    public void testCastToString() throws Exception {
        TestExpressionInterpreter.assertOptimizedEquals("cast(123 as VARCHAR)", "'123'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123 as VARCHAR)", "'-123'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(123.0 as VARCHAR)", "'123.0'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123.0 as VARCHAR)", "'-123.0'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(123.456 as VARCHAR)", "'123.456'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123.456 as VARCHAR)", "'-123.456'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(true as VARCHAR)", "'true'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(false as VARCHAR)", "'false'");
        TestExpressionInterpreter.assertOptimizedEquals("cast('xyz' as VARCHAR)", "'xyz'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(null as VARCHAR)", "null");
    }

    @Test
    public void testCastToBoolean() throws Exception {
        TestExpressionInterpreter.assertOptimizedEquals("cast(123 as BOOLEAN)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123 as BOOLEAN)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("cast(0 as BOOLEAN)", "false");
        TestExpressionInterpreter.assertOptimizedEquals("cast(true as BOOLEAN)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("cast(false as BOOLEAN)", "false");
        TestExpressionInterpreter.assertOptimizedEquals("cast('true' as BOOLEAN)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("cast('false' as BOOLEAN)", "false");
        TestExpressionInterpreter.assertOptimizedEquals("cast('t' as BOOLEAN)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("cast('f' as BOOLEAN)", "false");
        TestExpressionInterpreter.assertOptimizedEquals("cast('1' as BOOLEAN)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("cast('0' as BOOLEAN)", "false");
        TestExpressionInterpreter.assertOptimizedEquals("cast(null as BOOLEAN)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("cast(123.45 as BOOLEAN)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123.45 as BOOLEAN)", "true");
        TestExpressionInterpreter.assertOptimizedEquals("cast(0.0 as BOOLEAN)", "false");
    }

    @Test
    public void testCastToLong() throws Exception {
        TestExpressionInterpreter.assertOptimizedEquals("cast(0 as BIGINT)", "0");
        TestExpressionInterpreter.assertOptimizedEquals("cast(123 as BIGINT)", "123");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123 as BIGINT)", "-123");
        TestExpressionInterpreter.assertOptimizedEquals("cast(123.0 as BIGINT)", "123");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123.0 as BIGINT)", "-123");
        TestExpressionInterpreter.assertOptimizedEquals("cast(123.456 as BIGINT)", "123");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123.456 as BIGINT)", "-123");
        TestExpressionInterpreter.assertOptimizedEquals("cast(true as BIGINT)", "1");
        TestExpressionInterpreter.assertOptimizedEquals("cast(false as BIGINT)", "0");
        TestExpressionInterpreter.assertOptimizedEquals("cast('123' as BIGINT)", "123");
        TestExpressionInterpreter.assertOptimizedEquals("cast('-123' as BIGINT)", "-123");
        TestExpressionInterpreter.assertOptimizedEquals("cast(null as BIGINT)", "null");
    }

    @Test
    public void testCastToDouble() throws Exception {
        TestExpressionInterpreter.assertOptimizedEquals("cast(0 as DOUBLE)", "0.0");
        TestExpressionInterpreter.assertOptimizedEquals("cast(123 as DOUBLE)", "123.0");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123 as DOUBLE)", "-123.0");
        TestExpressionInterpreter.assertOptimizedEquals("cast(123.0 as DOUBLE)", "123.0");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123.0 as DOUBLE)", "-123.0");
        TestExpressionInterpreter.assertOptimizedEquals("cast(123.456 as DOUBLE)", "123.456");
        TestExpressionInterpreter.assertOptimizedEquals("cast(-123.456 as DOUBLE)", "-123.456");
        TestExpressionInterpreter.assertOptimizedEquals("cast('0' as DOUBLE)", "0.0");
        TestExpressionInterpreter.assertOptimizedEquals("cast('123' as DOUBLE)", "123.0");
        TestExpressionInterpreter.assertOptimizedEquals("cast('-123' as DOUBLE)", "-123.0");
        TestExpressionInterpreter.assertOptimizedEquals("cast('123.0' as DOUBLE)", "123.0");
        TestExpressionInterpreter.assertOptimizedEquals("cast('-123.0' as DOUBLE)", "-123.0");
        TestExpressionInterpreter.assertOptimizedEquals("cast('123.456' as DOUBLE)", "123.456");
        TestExpressionInterpreter.assertOptimizedEquals("cast('-123.456' as DOUBLE)", "-123.456");
        TestExpressionInterpreter.assertOptimizedEquals("cast(null as DOUBLE)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("cast(true as DOUBLE)", "1.0");
        TestExpressionInterpreter.assertOptimizedEquals("cast(false as DOUBLE)", "0.0");
    }

    @Test
    public void testCastOptimization() throws Exception {
        TestExpressionInterpreter.assertOptimizedEquals("cast(bound_long as VARCHAR)", "'1234'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(bound_long + 1 as VARCHAR)", "'1235'");
        TestExpressionInterpreter.assertOptimizedEquals("cast(unbound_string as VARCHAR)", "cast(unbound_string as VARCHAR)");
    }

    @Test
    public void testTryCast() {
        TestExpressionInterpreter.assertOptimizedEquals("try_cast(null as BIGINT)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("try_cast(123 as BIGINT)", "123");
        TestExpressionInterpreter.assertOptimizedEquals("try_cast('foo' as VARCHAR)", "'foo'");
        TestExpressionInterpreter.assertOptimizedEquals("try_cast('foo' as BIGINT)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("try_cast(unbound_string as BIGINT)", "try_cast(unbound_string as BIGINT)");
    }

    @Test
    public void testReservedWithDoubleQuotes() throws Exception {
        TestExpressionInterpreter.assertOptimizedEquals("\"time\"", "\"time\"");
    }

    @Test
    public void testSearchCase() throws Exception {
        TestExpressionInterpreter.assertOptimizedEquals("case when true then 33 end", "33");
        TestExpressionInterpreter.assertOptimizedEquals("case when false then 1 else 33 end", "33");
        TestExpressionInterpreter.assertOptimizedEquals("case when bound_long = 1234 then 33 end", "33");
        TestExpressionInterpreter.assertOptimizedEquals("case when true then bound_long end", "1234");
        TestExpressionInterpreter.assertOptimizedEquals("case when false then 1 else bound_long end", "1234");
        TestExpressionInterpreter.assertOptimizedEquals("case when bound_long = 1234 then 33 else unbound_long end", "33");
        TestExpressionInterpreter.assertOptimizedEquals("case when true then bound_long else unbound_long end", "1234");
        TestExpressionInterpreter.assertOptimizedEquals("case when false then unbound_long else bound_long end", "1234");
        TestExpressionInterpreter.assertOptimizedEquals("case when unbound_long = 1234 then 33 else 1 end", "case when unbound_long = 1234 then 33 else 1 end");
    }

    @Test
    public void testSimpleCase() throws Exception {
        TestExpressionInterpreter.assertOptimizedEquals("case true when true then 33 end", "33");
        TestExpressionInterpreter.assertOptimizedEquals("case true when false then 1 else 33 end", "33");
        TestExpressionInterpreter.assertOptimizedEquals("case bound_long when 1234 then 33 end", "33");
        TestExpressionInterpreter.assertOptimizedEquals("case 1234 when bound_long then 33 end", "33");
        TestExpressionInterpreter.assertOptimizedEquals("case true when true then bound_long end", "1234");
        TestExpressionInterpreter.assertOptimizedEquals("case true when false then 1 else bound_long end", "1234");
        TestExpressionInterpreter.assertOptimizedEquals("case bound_long when 1234 then 33 else unbound_long end", "33");
        TestExpressionInterpreter.assertOptimizedEquals("case true when true then bound_long else unbound_long end", "1234");
        TestExpressionInterpreter.assertOptimizedEquals("case true when false then unbound_long else bound_long end", "1234");
        TestExpressionInterpreter.assertOptimizedEquals("case unbound_long when 1234 then 33 else 1 end", "case unbound_long when 1234 then 33 else 1 end");
    }

    @Test
    public void testIf() throws Exception {
        TestExpressionInterpreter.assertOptimizedEquals("IF(2 = 2, 3, 4)", "3");
        TestExpressionInterpreter.assertOptimizedEquals("IF(1 = 2, 3, 4)", "4");
        TestExpressionInterpreter.assertOptimizedEquals("IF(true, 3, 4)", "3");
        TestExpressionInterpreter.assertOptimizedEquals("IF(false, 3, 4)", "4");
        TestExpressionInterpreter.assertOptimizedEquals("IF(null, 3, 4)", "4");
        TestExpressionInterpreter.assertOptimizedEquals("IF(true, 3, null)", "3");
        TestExpressionInterpreter.assertOptimizedEquals("IF(false, 3, null)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("IF(true, null, 4)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("IF(false, null, 4)", "4");
        TestExpressionInterpreter.assertOptimizedEquals("IF(true, null, null)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("IF(false, null, null)", "null");
        TestExpressionInterpreter.assertOptimizedEquals("IF(true, 3.5, 4.2)", "3.5");
        TestExpressionInterpreter.assertOptimizedEquals("IF(false, 3.5, 4.2)", "4.2");
        TestExpressionInterpreter.assertOptimizedEquals("IF(true, 'foo', 'bar')", "'foo'");
        TestExpressionInterpreter.assertOptimizedEquals("IF(false, 'foo', 'bar')", "'bar'");
        TestExpressionInterpreter.assertOptimizedEquals("IF(unbound_boolean, 1 + 2, 3 + 4)", "CASE WHEN unbound_boolean THEN (1 + 2) ELSE (3 + 4) END");
    }

    @Test
    public void testLike() throws Exception {
        TestExpressionInterpreter.assertOptimizedEquals("'a' LIKE 'a'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'' LIKE 'a'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'abc' LIKE 'a'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'a' LIKE '_'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'' LIKE '_'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'abc' LIKE '_'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'a' LIKE '%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'' LIKE '%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'abc' LIKE '%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'abc' LIKE '___'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'ab' LIKE '___'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'abcd' LIKE '___'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'abc' LIKE 'abc'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'xyz' LIKE 'abc'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'abc0' LIKE 'abc'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'0abc' LIKE 'abc'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'abc' LIKE 'abc%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'abc0' LIKE 'abc%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'0abc' LIKE 'abc%'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'abc' LIKE '%abc'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'0abc' LIKE '%abc'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'abc0' LIKE '%abc'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'abc' LIKE '%abc%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'0abc' LIKE '%abc%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'abc0' LIKE '%abc%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'0abc0' LIKE '%abc%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'xyzw' LIKE '%abc%'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'abc' LIKE '%ab%c%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'0abc' LIKE '%ab%c%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'abc0' LIKE '%ab%c%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'0abc0' LIKE '%ab%c%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'ab01c' LIKE '%ab%c%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'0ab01c' LIKE '%ab%c%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'ab01c0' LIKE '%ab%c%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'0ab01c0' LIKE '%ab%c%'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'xyzw' LIKE '%ab%c%'", "false");
        TestExpressionInterpreter.assertOptimizedEquals("'' LIKE ''", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'.*' LIKE '.*'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'[' LIKE '['", "true");
        TestExpressionInterpreter.assertOptimizedEquals("']' LIKE ']'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'{' LIKE '{'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'}' LIKE '}'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'?' LIKE '?'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'+' LIKE '+'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'(' LIKE '('", "true");
        TestExpressionInterpreter.assertOptimizedEquals("')' LIKE ')'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'|' LIKE '|'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'^' LIKE '^'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'$' LIKE '$'", "true");
        TestExpressionInterpreter.assertOptimizedEquals("null like '%'", "null");
        TestExpressionInterpreter.assertOptimizedEquals("'a' like null", "null");
        TestExpressionInterpreter.assertOptimizedEquals("'a' like '%' escape null", "null");
        TestExpressionInterpreter.assertOptimizedEquals("'%' like 'z%' escape 'z'", "true");
    }

    @Test
    public void testLikeOptimization() throws Exception {
        TestExpressionInterpreter.assertOptimizedEquals("unbound_string like 'abc'", "unbound_string = 'abc'");
        TestExpressionInterpreter.assertOptimizedEquals("bound_string like bound_pattern", "true");
        TestExpressionInterpreter.assertOptimizedEquals("'abc' like bound_pattern", "false");
        TestExpressionInterpreter.assertOptimizedEquals("unbound_string like bound_pattern", "unbound_string like bound_pattern");
        TestExpressionInterpreter.assertOptimizedEquals("unbound_string like unbound_pattern escape unbound_string", "unbound_string like unbound_pattern escape unbound_string");
    }

    @Test
    public void testFailedExpressionOptimization() throws Exception {
        TestExpressionInterpreter.assertOptimizedEquals("if(unbound_boolean, 1, 0 / 0)", "CASE WHEN unbound_boolean THEN 1 ELSE 0 / 0 END");
        TestExpressionInterpreter.assertOptimizedEquals("if(unbound_boolean, 0 / 0, 1)", "CASE WHEN unbound_boolean THEN 0 / 0 ELSE 1 END");
        TestExpressionInterpreter.assertOptimizedEqualsSelf("case unbound_long when 1 then 1 when 0 / 0 then 2 end");
        TestExpressionInterpreter.assertOptimizedEqualsSelf("case unbound_boolean when true then 1 else 0 / 0 end");
        TestExpressionInterpreter.assertOptimizedEqualsSelf("case unbound_boolean when true then 0 / 0 else 1 end");
        TestExpressionInterpreter.assertOptimizedEqualsSelf("case when unbound_boolean then 1 when 0 / 0 = 0 then 2 end");
        TestExpressionInterpreter.assertOptimizedEqualsSelf("case when unbound_boolean then 1 else 0 / 0  end");
        TestExpressionInterpreter.assertOptimizedEqualsSelf("case when unbound_boolean then 0 / 0 else 1 end");
        TestExpressionInterpreter.assertOptimizedEqualsSelf("coalesce(unbound_boolean, 0 / 0 = 0)");
    }

    @Test(expectedExceptions={PrestoException.class})
    public void testOptimizeDivideByZero() throws Exception {
        TestExpressionInterpreter.optimize("0 / 0");
    }

    @Test(expectedExceptions={PrestoException.class})
    public void testOptimizeConstantIfDivideByZero() throws Exception {
        TestExpressionInterpreter.optimize("if(false, 1, 0 / 0)");
    }

    @Test(expectedExceptions={PrestoException.class})
    public void testOptimizeConstantSearchedCaseDivideByZero() throws Exception {
        TestExpressionInterpreter.optimize("case when 0 / 0 = 0 then 1 end");
    }

    @Test(timeOut=60000L)
    public void testLikeInvalidUtf8() {
        TestExpressionInterpreter.assertLike(new byte[]{97, 98, 99}, "%b%", true);
        TestExpressionInterpreter.assertLike(new byte[]{97, 98, 99, -1, 120, 121}, "%b%", true);
    }

    @Test
    public void testLiterals() {
        TestExpressionInterpreter.optimize("date '2013-04-03' + unbound_interval");
        TestExpressionInterpreter.optimize("time '03:04:05.321' + unbound_interval");
        TestExpressionInterpreter.optimize("time '03:04:05.321 UTC' + unbound_interval");
        TestExpressionInterpreter.optimize("timestamp '2013-04-03 03:04:05.321' + unbound_interval");
        TestExpressionInterpreter.optimize("timestamp '2013-04-03 03:04:05.321 UTC' + unbound_interval");
        TestExpressionInterpreter.optimize("interval '3' day * unbound_long");
        TestExpressionInterpreter.optimize("interval '3' year * unbound_long");
    }

    private static void assertLike(byte[] value, String pattern, boolean expected) {
        LikePredicate predicate = new LikePredicate((Expression)TestExpressionInterpreter.rawStringLiteral(Slices.wrappedBuffer((byte[])value)), (Expression)new StringLiteral(pattern), null);
        Assert.assertEquals((Object)TestExpressionInterpreter.evaluate((Expression)predicate), (Object)expected);
    }

    private static StringLiteral rawStringLiteral(final Slice slice) {
        return new StringLiteral(slice.toString(StandardCharsets.UTF_8)){

            public Slice getSlice() {
                return slice;
            }
        };
    }

    private static void assertOptimizedEquals(@Language(value="SQL") String actual, @Language(value="SQL") String expected) {
        Assert.assertEquals((Object)TestExpressionInterpreter.optimize(actual), (Object)TestExpressionInterpreter.optimize(expected));
    }

    private static void assertOptimizedEqualsSelf(@Language(value="SQL") String expression) {
        Assert.assertEquals((Object)TestExpressionInterpreter.optimize(expression), (Object)SQL_PARSER.createExpression(expression));
    }

    private static Object optimize(@Language(value="SQL") String expression) {
        TestExpressionInterpreter.assertRoundTrip(expression);
        Expression parsedExpression = FunctionAssertions.createExpression(expression, METADATA, SYMBOL_TYPES);
        IdentityHashMap expressionTypes = ExpressionAnalyzer.getExpressionTypes((Session)SessionTestUtils.TEST_SESSION, (Metadata)METADATA, (SqlParser)SQL_PARSER, SYMBOL_TYPES, (Expression)parsedExpression);
        ExpressionInterpreter interpreter = ExpressionInterpreter.expressionOptimizer((Expression)parsedExpression, (Metadata)METADATA, (Session)SessionTestUtils.TEST_SESSION, (IdentityHashMap)expressionTypes);
        return interpreter.optimize(new SymbolResolver(){

            public Object getValue(Symbol symbol) {
                switch (symbol.getName().toLowerCase(Locale.ENGLISH)) {
                    case "bound_long": {
                        return 1234L;
                    }
                    case "bound_string": {
                        return Slices.wrappedBuffer((byte[])"hello".getBytes(StandardCharsets.UTF_8));
                    }
                    case "bound_double": {
                        return 12.34;
                    }
                    case "bound_date": {
                        return new LocalDate(2001, 8, 22).toDateMidnight(DateTimeZone.UTC).getMillis();
                    }
                    case "bound_time": {
                        return new LocalTime(3, 4, 5, 321).toDateTime((ReadableInstant)new DateTime(0L, DateTimeZone.UTC)).getMillis();
                    }
                    case "bound_timestamp": {
                        return new DateTime(2001, 8, 22, 3, 4, 5, 321, DateTimeZone.UTC).getMillis();
                    }
                    case "bound_pattern": {
                        return Slices.wrappedBuffer((byte[])"%el%".getBytes(StandardCharsets.UTF_8));
                    }
                }
                return new QualifiedNameReference(symbol.toQualifiedName());
            }
        });
    }

    private static Object evaluate(String expression) {
        TestExpressionInterpreter.assertRoundTrip(expression);
        Expression parsedExpression = FunctionAssertions.createExpression(expression, METADATA, SYMBOL_TYPES);
        return TestExpressionInterpreter.evaluate(parsedExpression);
    }

    private static void assertRoundTrip(String expression) {
        Assert.assertEquals((Object)SQL_PARSER.createExpression(expression), (Object)SQL_PARSER.createExpression(ExpressionFormatter.formatExpression((Expression)SQL_PARSER.createExpression(expression))));
    }

    private static Object evaluate(Expression expression) {
        IdentityHashMap expressionTypes = ExpressionAnalyzer.getExpressionTypes((Session)SessionTestUtils.TEST_SESSION, (Metadata)METADATA, (SqlParser)SQL_PARSER, SYMBOL_TYPES, (Expression)expression);
        ExpressionInterpreter interpreter = ExpressionInterpreter.expressionInterpreter((Expression)expression, (Metadata)METADATA, (Session)SessionTestUtils.TEST_SESSION, (IdentityHashMap)expressionTypes);
        return interpreter.evaluate((RecordCursor)null);
    }
}

