/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.SequencePageBuilder;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.JoinProbe;
import com.facebook.presto.operator.JoinProbeFactory;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.PageAssertions;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.ValuesOperator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.sql.gen.JoinProbeCompiler;
import com.facebook.presto.type.TypeUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.concurrent.Threads;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestJoinProbeCompiler {
    private static final JoinCompiler joinCompiler = new JoinCompiler();
    private ExecutorService executor;
    private TaskContext taskContext;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test"));
        this.taskContext = new TaskContext(new TaskId("query", "stage", "task"), (Executor)this.executor, SessionTestUtils.TEST_SESSION);
    }

    @AfterMethod
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @DataProvider(name="hashEnabledValues")
    public static Object[][] hashEnabledValuesProvider() {
        return new Object[][]{{true}, {false}};
    }

    @Test(dataProvider="hashEnabledValues")
    public void testSingleChannel(boolean hashEnabled) throws Exception {
        DriverContext driverContext = this.taskContext.addPipelineContext(true, true).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, ValuesOperator.class.getSimpleName());
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR);
        JoinCompiler.LookupSourceFactory lookupSourceFactoryFactory = joinCompiler.compileLookupSourceFactory((List)types, Ints.asList((int[])new int[]{0}));
        ImmutableList channel = ImmutableList.of((Object)BlockAssertions.createStringSequenceBlock(10, 20), (Object)BlockAssertions.createStringSequenceBlock(20, 30), (Object)BlockAssertions.createStringSequenceBlock(15, 25));
        LongArrayList addresses = new LongArrayList();
        for (int blockIndex = 0; blockIndex < channel.size(); ++blockIndex) {
            Block block = (Block)channel.get(blockIndex);
            for (int positionIndex = 0; positionIndex < block.getPositionCount(); ++positionIndex) {
                addresses.add(SyntheticAddress.encodeSyntheticAddress((int)blockIndex, (int)positionIndex));
            }
        }
        Optional<Object> hashChannel = Optional.empty();
        ImmutableList channels = ImmutableList.of((Object)channel);
        if (hashEnabled) {
            ImmutableList.Builder hashChannelBuilder = ImmutableList.builder();
            for (Block block : channel) {
                hashChannelBuilder.add((Object)TypeUtils.getHashBlock((List)ImmutableList.of((Object)VarcharType.VARCHAR), (Block[])new Block[]{block}));
            }
            types = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT);
            hashChannel = Optional.of(1);
            channels = ImmutableList.of((Object)channel, (Object)hashChannelBuilder.build());
        }
        LookupSource lookupSource = lookupSourceFactoryFactory.createLookupSource(addresses, (List)types, (List)channels, hashChannel, operatorContext);
        JoinProbeCompiler joinProbeCompiler = new JoinProbeCompiler();
        JoinProbeFactory probeFactory = joinProbeCompiler.internalCompileJoinProbe((List)types, Ints.asList((int[])new int[]{0}), hashChannel);
        Page page = SequencePageBuilder.createSequencePage((List<? extends Type>)types, 10, 10);
        if (hashEnabled) {
            page = new Page(new Block[]{page.getBlock(0), TypeUtils.getHashBlock((List)ImmutableList.of((Object)VarcharType.VARCHAR), (Block[])new Block[]{page.getBlock(0)})});
        }
        JoinProbe joinProbe = probeFactory.createJoinProbe(lookupSource, page);
        Assert.assertEquals((int)joinProbe.getChannelCount(), (int)types.size());
        PageBuilder pageBuilder = new PageBuilder((List)types);
        for (int position = 0; position < page.getPositionCount(); ++position) {
            Assert.assertTrue((boolean)joinProbe.advanceNextPosition());
            pageBuilder.declarePosition();
            joinProbe.appendTo(pageBuilder);
            Assert.assertEquals((long)joinProbe.getCurrentJoinPosition(), (long)lookupSource.getJoinPosition(position, page));
        }
        Assert.assertFalse((boolean)joinProbe.advanceNextPosition());
        PageAssertions.assertPageEquals((List<? extends Type>)types, pageBuilder.build(), page);
    }
}

