/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.Session;
import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.spi.type.SqlDate;
import com.facebook.presto.spi.type.SqlTimestamp;
import com.facebook.presto.spi.type.SqlTimestampWithTimeZone;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.util.DateTimeZoneIndex;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestDate {
    private static final TimeZoneKey TIME_ZONE_KEY = TimeZoneKey.getTimeZoneKey((String)"Europe/Berlin");
    private static final DateTimeZone DATE_TIME_ZONE = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TIME_ZONE_KEY);
    private FunctionAssertions functionAssertions;

    @BeforeClass
    public void setUp() {
        Session session = Session.builder().setUser("user").setSource("test").setCatalog("catalog").setSchema("schema").setTimeZoneKey(TIME_ZONE_KEY).setLocale(Locale.ENGLISH).build();
        this.functionAssertions = new FunctionAssertions(session);
    }

    private void assertFunction(String projection, Object expected) {
        this.functionAssertions.assertFunction(projection, expected);
    }

    @Test
    public void testLiteral() throws Exception {
        long millis = new DateTime(2001, 1, 22, 0, 0, DateTimeZone.UTC).getMillis();
        this.assertFunction("DATE '2001-1-22'", new SqlDate((int)TimeUnit.MILLISECONDS.toDays(millis)));
    }

    @Test
    public void testEqual() throws Exception {
        this.assertFunction("DATE '2001-1-22' = DATE '2001-1-22'", true);
        this.assertFunction("DATE '2001-1-22' = DATE '2001-1-22'", true);
        this.assertFunction("DATE '2001-1-22' = DATE '2001-1-23'", false);
        this.assertFunction("DATE '2001-1-22' = DATE '2001-1-11'", false);
    }

    @Test
    public void testNotEqual() throws Exception {
        this.assertFunction("DATE '2001-1-22' <> DATE '2001-1-23'", true);
        this.assertFunction("DATE '2001-1-22' <> DATE '2001-1-11'", true);
        this.assertFunction("DATE '2001-1-22' <> DATE '2001-1-22'", false);
    }

    @Test
    public void testLessThan() throws Exception {
        this.assertFunction("DATE '2001-1-22' < DATE '2001-1-23'", true);
        this.assertFunction("DATE '2001-1-22' < DATE '2001-1-22'", false);
        this.assertFunction("DATE '2001-1-22' < DATE '2001-1-20'", false);
    }

    @Test
    public void testLessThanOrEqual() throws Exception {
        this.assertFunction("DATE '2001-1-22' <= DATE '2001-1-22'", true);
        this.assertFunction("DATE '2001-1-22' <= DATE '2001-1-23'", true);
        this.assertFunction("DATE '2001-1-22' <= DATE '2001-1-20'", false);
    }

    @Test
    public void testGreaterThan() throws Exception {
        this.assertFunction("DATE '2001-1-22' > DATE '2001-1-11'", true);
        this.assertFunction("DATE '2001-1-22' > DATE '2001-1-22'", false);
        this.assertFunction("DATE '2001-1-22' > DATE '2001-1-23'", false);
    }

    @Test
    public void testGreaterThanOrEqual() throws Exception {
        this.assertFunction("DATE '2001-1-22' >= DATE '2001-1-22'", true);
        this.assertFunction("DATE '2001-1-22' >= DATE '2001-1-11'", true);
        this.assertFunction("DATE '2001-1-22' >= DATE '2001-1-23'", false);
    }

    @Test
    public void testBetween() throws Exception {
        this.assertFunction("DATE '2001-1-22' between DATE '2001-1-11' and DATE '2001-1-23'", true);
        this.assertFunction("DATE '2001-1-22' between DATE '2001-1-11' and DATE '2001-1-22'", true);
        this.assertFunction("DATE '2001-1-22' between DATE '2001-1-22' and DATE '2001-1-23'", true);
        this.assertFunction("DATE '2001-1-22' between DATE '2001-1-22' and DATE '2001-1-22'", true);
        this.assertFunction("DATE '2001-1-22' between DATE '2001-1-11' and DATE '2001-1-12'", false);
        this.assertFunction("DATE '2001-1-22' between DATE '2001-1-23' and DATE '2001-1-24'", false);
        this.assertFunction("DATE '2001-1-22' between DATE '2001-1-23' and DATE '2001-1-11'", false);
    }

    @Test
    public void testCastToTimestamp() throws Exception {
        this.assertFunction("cast(DATE '2001-1-22' as timestamp)", new SqlTimestamp(new DateTime(2001, 1, 22, 0, 0, 0, 0, DATE_TIME_ZONE).getMillis(), TIME_ZONE_KEY));
    }

    @Test
    public void testCastToTimestampWithTimeZone() throws Exception {
        this.assertFunction("cast(DATE '2001-1-22' as timestamp with time zone)", new SqlTimestampWithTimeZone(new DateTime(2001, 1, 22, 0, 0, 0, 0, DATE_TIME_ZONE).getMillis(), TIME_ZONE_KEY));
    }

    @Test
    public void testCastToSlice() throws Exception {
        this.assertFunction("cast(DATE '2001-1-22' as varchar)", "2001-01-22");
    }

    @Test
    public void testCastFromSlice() throws Exception {
        this.assertFunction("cast('2001-1-22' as date) = Date '2001-1-22'", true);
    }

    @Test
    public void testGreatest() throws Exception {
        int days = (int)TimeUnit.MILLISECONDS.toDays(new DateTime(2013, 3, 30, 0, 0, DateTimeZone.UTC).getMillis());
        this.assertFunction("greatest(DATE '2013-03-30', DATE '2012-05-23')", new SqlDate(days));
        this.assertFunction("greatest(DATE '2013-03-30', DATE '2012-05-23', DATE '2012-06-01')", new SqlDate(days));
    }

    @Test
    public void testLeast() throws Exception {
        int days = (int)TimeUnit.MILLISECONDS.toDays(new DateTime(2012, 5, 23, 0, 0, DateTimeZone.UTC).getMillis());
        this.assertFunction("least(DATE '2013-03-30', DATE '2012-05-23')", new SqlDate(days));
        this.assertFunction("least(DATE '2013-03-30', DATE '2012-05-23', DATE '2012-06-01')", new SqlDate(days));
    }
}

