/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.spi.type.SqlIntervalDayTime;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestIntervalDayTime {
    private FunctionAssertions functionAssertions;

    @BeforeClass
    public void setUp() {
        this.functionAssertions = new FunctionAssertions();
    }

    private void assertFunction(String projection, Object expected) {
        this.functionAssertions.assertFunction(projection, expected);
    }

    @Test
    public void testLiteral() throws Exception {
        this.assertFunction("INTERVAL '12 10:45:32.123' DAY TO SECOND", new SqlIntervalDayTime(12, 10, 45, 32, 123));
        this.assertFunction("INTERVAL '12 10:45:32.12' DAY TO SECOND", new SqlIntervalDayTime(12, 10, 45, 32, 120));
        this.assertFunction("INTERVAL '12 10:45:32' DAY TO SECOND", new SqlIntervalDayTime(12, 10, 45, 32, 0));
        this.assertFunction("INTERVAL '12 10:45' DAY TO SECOND", new SqlIntervalDayTime(12, 10, 45, 0, 0));
        this.assertFunction("INTERVAL '12 10' DAY TO SECOND", new SqlIntervalDayTime(12, 10, 0, 0, 0));
        this.assertFunction("INTERVAL '12' DAY TO SECOND", new SqlIntervalDayTime(12, 0, 0, 0, 0));
        this.assertFunction("INTERVAL '12 10:45' DAY TO MINUTE", new SqlIntervalDayTime(12, 10, 45, 0, 0));
        this.assertFunction("INTERVAL '12 10' DAY TO MINUTE", new SqlIntervalDayTime(12, 10, 0, 0, 0));
        this.assertFunction("INTERVAL '12' DAY TO MINUTE", new SqlIntervalDayTime(12, 0, 0, 0, 0));
        this.assertFunction("INTERVAL '12 10' DAY TO HOUR", new SqlIntervalDayTime(12, 10, 0, 0, 0));
        this.assertFunction("INTERVAL '12' DAY TO HOUR", new SqlIntervalDayTime(12, 0, 0, 0, 0));
        this.assertFunction("INTERVAL '12' DAY", new SqlIntervalDayTime(12, 0, 0, 0, 0));
        this.assertFunction("INTERVAL '10:45:32.123' HOUR TO SECOND", new SqlIntervalDayTime(0, 10, 45, 32, 123));
        this.assertFunction("INTERVAL '10:45:32.12' HOUR TO SECOND", new SqlIntervalDayTime(0, 10, 45, 32, 120));
        this.assertFunction("INTERVAL '10:45:32' HOUR TO SECOND", new SqlIntervalDayTime(0, 10, 45, 32, 0));
        this.assertFunction("INTERVAL '10:45' HOUR TO SECOND", new SqlIntervalDayTime(0, 10, 45, 0, 0));
        this.assertFunction("INTERVAL '10' HOUR TO SECOND", new SqlIntervalDayTime(0, 10, 0, 0, 0));
        this.assertFunction("INTERVAL '10:45' HOUR TO MINUTE", new SqlIntervalDayTime(0, 10, 45, 0, 0));
        this.assertFunction("INTERVAL '10' HOUR TO MINUTE", new SqlIntervalDayTime(0, 10, 0, 0, 0));
        this.assertFunction("INTERVAL '10' HOUR", new SqlIntervalDayTime(0, 10, 0, 0, 0));
        this.assertFunction("INTERVAL '45:32.123' MINUTE TO SECOND", new SqlIntervalDayTime(0, 0, 45, 32, 123));
        this.assertFunction("INTERVAL '45:32.12' MINUTE TO SECOND", new SqlIntervalDayTime(0, 0, 45, 32, 120));
        this.assertFunction("INTERVAL '45:32' MINUTE TO SECOND", new SqlIntervalDayTime(0, 0, 45, 32, 0));
        this.assertFunction("INTERVAL '45' MINUTE TO SECOND", new SqlIntervalDayTime(0, 0, 45, 0, 0));
        this.assertFunction("INTERVAL '45' MINUTE", new SqlIntervalDayTime(0, 0, 45, 0, 0));
        this.assertFunction("INTERVAL '32.123' SECOND", new SqlIntervalDayTime(0, 0, 0, 32, 123));
        this.assertFunction("INTERVAL '32.12' SECOND", new SqlIntervalDayTime(0, 0, 0, 32, 120));
        this.assertFunction("INTERVAL '32' SECOND", new SqlIntervalDayTime(0, 0, 0, 32, 0));
    }

    @Test
    public void testAdd() throws Exception {
        this.assertFunction("INTERVAL '3' SECOND + INTERVAL '3' SECOND", new SqlIntervalDayTime(6000L));
        this.assertFunction("INTERVAL '6' DAY + INTERVAL '6' DAY", new SqlIntervalDayTime(1036800000L));
        this.assertFunction("INTERVAL '3' SECOND + INTERVAL '6' DAY", new SqlIntervalDayTime(518403000L));
    }

    @Test
    public void testSubtract() throws Exception {
        this.assertFunction("INTERVAL '6' SECOND - INTERVAL '3' SECOND", new SqlIntervalDayTime(3000L));
        this.assertFunction("INTERVAL '9' DAY - INTERVAL '6' DAY", new SqlIntervalDayTime(259200000L));
        this.assertFunction("INTERVAL '3' SECOND - INTERVAL '6' DAY", new SqlIntervalDayTime(-518397000L));
    }

    @Test
    public void testMultiply() throws Exception {
        this.assertFunction("INTERVAL '6' SECOND * 2", new SqlIntervalDayTime(12000L));
        this.assertFunction("2 * INTERVAL '6' SECOND", new SqlIntervalDayTime(12000L));
        this.assertFunction("INTERVAL '1' SECOND * 2.5", new SqlIntervalDayTime(2500L));
        this.assertFunction("2.5 * INTERVAL '1' SECOND", new SqlIntervalDayTime(2500L));
        this.assertFunction("INTERVAL '6' DAY * 2", new SqlIntervalDayTime(1036800000L));
        this.assertFunction("2 * INTERVAL '6' DAY", new SqlIntervalDayTime(1036800000L));
        this.assertFunction("INTERVAL '1' DAY * 2.5", new SqlIntervalDayTime(216000000L));
        this.assertFunction("2.5 * INTERVAL '1' DAY", new SqlIntervalDayTime(216000000L));
    }

    @Test
    public void testDivide() throws Exception {
        this.assertFunction("INTERVAL '3' SECOND / 2", new SqlIntervalDayTime(1500L));
        this.assertFunction("INTERVAL '6' SECOND / 2.5", new SqlIntervalDayTime(2400L));
        this.assertFunction("INTERVAL '3' DAY / 2", new SqlIntervalDayTime(129600000L));
        this.assertFunction("INTERVAL '4' DAY / 2.5", new SqlIntervalDayTime(138240000L));
    }

    @Test
    public void testNegation() throws Exception {
        this.assertFunction("- INTERVAL '3' SECOND", new SqlIntervalDayTime(-3000L));
        this.assertFunction("- INTERVAL '6' DAY", new SqlIntervalDayTime(-518400000L));
    }

    @Test
    public void testEqual() throws Exception {
        this.assertFunction("INTERVAL '3' SECOND = INTERVAL '3' SECOND", true);
        this.assertFunction("INTERVAL '6' DAY = INTERVAL '6' DAY", true);
        this.assertFunction("INTERVAL '3' SECOND = INTERVAL '4' SECOND", false);
        this.assertFunction("INTERVAL '7' DAY = INTERVAL '6' DAY", false);
    }

    @Test
    public void testNotEqual() throws Exception {
        this.assertFunction("INTERVAL '3' SECOND <> INTERVAL '4' SECOND", true);
        this.assertFunction("INTERVAL '6' DAY <> INTERVAL '7' DAY", true);
        this.assertFunction("INTERVAL '3' SECOND <> INTERVAL '3' SECOND", false);
        this.assertFunction("INTERVAL '6' DAY <> INTERVAL '6' DAY", false);
    }

    @Test
    public void testLessThan() throws Exception {
        this.assertFunction("INTERVAL '3' SECOND < INTERVAL '4' SECOND", true);
        this.assertFunction("INTERVAL '6' DAY < INTERVAL '7' DAY", true);
        this.assertFunction("INTERVAL '3' SECOND < INTERVAL '3' SECOND", false);
        this.assertFunction("INTERVAL '3' SECOND < INTERVAL '2' SECOND", false);
        this.assertFunction("INTERVAL '6' DAY < INTERVAL '6' DAY", false);
        this.assertFunction("INTERVAL '6' DAY < INTERVAL '5' DAY", false);
    }

    @Test
    public void testLessThanOrEqual() throws Exception {
        this.assertFunction("INTERVAL '3' SECOND <= INTERVAL '4' SECOND", true);
        this.assertFunction("INTERVAL '3' SECOND <= INTERVAL '3' SECOND", true);
        this.assertFunction("INTERVAL '6' DAY <= INTERVAL '6' DAY", true);
        this.assertFunction("INTERVAL '6' DAY <= INTERVAL '7' DAY", true);
        this.assertFunction("INTERVAL '3' SECOND <= INTERVAL '2' SECOND", false);
        this.assertFunction("INTERVAL '6' DAY <= INTERVAL '5' DAY", false);
    }

    @Test
    public void testGreaterThan() throws Exception {
        this.assertFunction("INTERVAL '3' SECOND > INTERVAL '2' SECOND", true);
        this.assertFunction("INTERVAL '6' DAY > INTERVAL '5' DAY", true);
        this.assertFunction("INTERVAL '3' SECOND > INTERVAL '3' SECOND", false);
        this.assertFunction("INTERVAL '3' SECOND > INTERVAL '4' SECOND", false);
        this.assertFunction("INTERVAL '6' DAY > INTERVAL '6' DAY", false);
        this.assertFunction("INTERVAL '6' DAY > INTERVAL '7' DAY", false);
    }

    @Test
    public void testGreaterThanOrEqual() throws Exception {
        this.assertFunction("INTERVAL '3' SECOND >= INTERVAL '2' SECOND", true);
        this.assertFunction("INTERVAL '3' SECOND >= INTERVAL '3' SECOND", true);
        this.assertFunction("INTERVAL '6' DAY >= INTERVAL '5' DAY", true);
        this.assertFunction("INTERVAL '6' DAY >= INTERVAL '6' DAY", true);
        this.assertFunction("INTERVAL '3' SECOND >= INTERVAL '4' SECOND", false);
        this.assertFunction("INTERVAL '6' DAY >= INTERVAL '7' DAY", false);
    }

    @Test
    public void testBetween() throws Exception {
        this.assertFunction("INTERVAL '3' SECOND between INTERVAL '2' SECOND and INTERVAL '4' SECOND", true);
        this.assertFunction("INTERVAL '3' SECOND between INTERVAL '3' SECOND and INTERVAL '4' SECOND", true);
        this.assertFunction("INTERVAL '3' SECOND between INTERVAL '2' SECOND and INTERVAL '3' SECOND", true);
        this.assertFunction("INTERVAL '3' SECOND between INTERVAL '3' SECOND and INTERVAL '3' SECOND", true);
        this.assertFunction("INTERVAL '3' SECOND between INTERVAL '4' SECOND and INTERVAL '5' SECOND", false);
        this.assertFunction("INTERVAL '3' SECOND between INTERVAL '1' SECOND and INTERVAL '2' SECOND", false);
        this.assertFunction("INTERVAL '3' SECOND between INTERVAL '4' SECOND and INTERVAL '2' SECOND", false);
    }

    @Test
    public void testCastToSlice() throws Exception {
        this.assertFunction("cast(INTERVAL '12 10:45:32.123' DAY TO SECOND as varchar)", "12 10:45:32.123");
        this.assertFunction("cast(INTERVAL '12 10:45:32.123' DAY TO SECOND as varchar)", new SqlIntervalDayTime(12, 10, 45, 32, 123).toString());
        this.assertFunction("cast(INTERVAL '12 10:45:32.12' DAY TO SECOND as varchar)", new SqlIntervalDayTime(12, 10, 45, 32, 120).toString());
        this.assertFunction("cast(INTERVAL '12 10:45:32' DAY TO SECOND as varchar)", new SqlIntervalDayTime(12, 10, 45, 32, 0).toString());
        this.assertFunction("cast(INTERVAL '12 10:45' DAY TO SECOND as varchar)", new SqlIntervalDayTime(12, 10, 45, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '12 10' DAY TO SECOND as varchar)", new SqlIntervalDayTime(12, 10, 0, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '12' DAY TO SECOND as varchar)", new SqlIntervalDayTime(12, 0, 0, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '12 10:45' DAY TO MINUTE as varchar)", new SqlIntervalDayTime(12, 10, 45, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '12 10' DAY TO MINUTE as varchar)", new SqlIntervalDayTime(12, 10, 0, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '12' DAY TO MINUTE as varchar)", new SqlIntervalDayTime(12, 0, 0, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '12 10' DAY TO HOUR as varchar)", new SqlIntervalDayTime(12, 10, 0, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '12' DAY TO HOUR as varchar)", new SqlIntervalDayTime(12, 0, 0, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '12' DAY as varchar)", new SqlIntervalDayTime(12, 0, 0, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '10:45:32.123' HOUR TO SECOND as varchar)", new SqlIntervalDayTime(0, 10, 45, 32, 123).toString());
        this.assertFunction("cast(INTERVAL '10:45:32.12' HOUR TO SECOND as varchar)", new SqlIntervalDayTime(0, 10, 45, 32, 120).toString());
        this.assertFunction("cast(INTERVAL '10:45:32' HOUR TO SECOND as varchar)", new SqlIntervalDayTime(0, 10, 45, 32, 0).toString());
        this.assertFunction("cast(INTERVAL '10:45' HOUR TO SECOND as varchar)", new SqlIntervalDayTime(0, 10, 45, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '10' HOUR TO SECOND as varchar)", new SqlIntervalDayTime(0, 10, 0, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '10:45' HOUR TO MINUTE as varchar)", new SqlIntervalDayTime(0, 10, 45, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '10' HOUR TO MINUTE as varchar)", new SqlIntervalDayTime(0, 10, 0, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '10' HOUR as varchar)", new SqlIntervalDayTime(0, 10, 0, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '45:32.123' MINUTE TO SECOND as varchar)", new SqlIntervalDayTime(0, 0, 45, 32, 123).toString());
        this.assertFunction("cast(INTERVAL '45:32.12' MINUTE TO SECOND as varchar)", new SqlIntervalDayTime(0, 0, 45, 32, 120).toString());
        this.assertFunction("cast(INTERVAL '45:32' MINUTE TO SECOND as varchar)", new SqlIntervalDayTime(0, 0, 45, 32, 0).toString());
        this.assertFunction("cast(INTERVAL '45' MINUTE TO SECOND as varchar)", new SqlIntervalDayTime(0, 0, 45, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '45' MINUTE as varchar)", new SqlIntervalDayTime(0, 0, 45, 0, 0).toString());
        this.assertFunction("cast(INTERVAL '32.123' SECOND as varchar)", new SqlIntervalDayTime(0, 0, 0, 32, 123).toString());
        this.assertFunction("cast(INTERVAL '32.12' SECOND as varchar)", new SqlIntervalDayTime(0, 0, 0, 32, 120).toString());
        this.assertFunction("cast(INTERVAL '32' SECOND as varchar)", new SqlIntervalDayTime(0, 0, 0, 32, 0).toString());
    }
}

