/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.operator.scalar.FunctionAssertions;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestVarcharOperators {
    private FunctionAssertions functionAssertions;

    @BeforeClass
    public void setUp() {
        this.functionAssertions = new FunctionAssertions();
    }

    private void assertFunction(String projection, Object expected) {
        this.functionAssertions.assertFunction(projection, expected);
    }

    @Test
    public void testLiteral() throws Exception {
        this.assertFunction("'foo'", "foo");
        this.assertFunction("'bar'", "bar");
        this.assertFunction("''", "");
    }

    @Test
    public void testAdd() throws Exception {
        this.assertFunction("'foo' || 'foo'", "foofoo");
        this.assertFunction("'foo' || 'bar'", "foobar");
        this.assertFunction("'bar' || 'foo'", "barfoo");
        this.assertFunction("'bar' || 'bar'", "barbar");
    }

    @Test
    public void testEqual() throws Exception {
        this.assertFunction("'foo' = 'foo'", true);
        this.assertFunction("'foo' = 'bar'", false);
        this.assertFunction("'bar' = 'foo'", false);
        this.assertFunction("'bar' = 'bar'", true);
    }

    @Test
    public void testNotEqual() throws Exception {
        this.assertFunction("'foo' <> 'foo'", false);
        this.assertFunction("'foo' <> 'bar'", true);
        this.assertFunction("'bar' <> 'foo'", true);
        this.assertFunction("'bar' <> 'bar'", false);
    }

    @Test
    public void testLessThan() throws Exception {
        this.assertFunction("'foo' < 'foo'", false);
        this.assertFunction("'foo' < 'bar'", false);
        this.assertFunction("'bar' < 'foo'", true);
        this.assertFunction("'bar' < 'bar'", false);
    }

    @Test
    public void testLessThanOrEqual() throws Exception {
        this.assertFunction("'foo' <= 'foo'", true);
        this.assertFunction("'foo' <= 'bar'", false);
        this.assertFunction("'bar' <= 'foo'", true);
        this.assertFunction("'bar' <= 'bar'", true);
    }

    @Test
    public void testGreaterThan() throws Exception {
        this.assertFunction("'foo' > 'foo'", false);
        this.assertFunction("'foo' > 'bar'", true);
        this.assertFunction("'bar' > 'foo'", false);
        this.assertFunction("'bar' > 'bar'", false);
    }

    @Test
    public void testGreaterThanOrEqual() throws Exception {
        this.assertFunction("'foo' >= 'foo'", true);
        this.assertFunction("'foo' >= 'bar'", true);
        this.assertFunction("'bar' >= 'foo'", false);
        this.assertFunction("'bar' >= 'bar'", true);
    }

    @Test
    public void testBetween() throws Exception {
        this.assertFunction("'foo' BETWEEN 'foo' AND 'foo'", true);
        this.assertFunction("'foo' BETWEEN 'foo' AND 'bar'", false);
        this.assertFunction("'foo' BETWEEN 'bar' AND 'foo'", true);
        this.assertFunction("'foo' BETWEEN 'bar' AND 'bar'", false);
        this.assertFunction("'bar' BETWEEN 'foo' AND 'foo'", false);
        this.assertFunction("'bar' BETWEEN 'foo' AND 'bar'", false);
        this.assertFunction("'bar' BETWEEN 'bar' AND 'foo'", true);
        this.assertFunction("'bar' BETWEEN 'bar' AND 'bar'", true);
    }
}

