/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.type.VarbinaryType;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.util.Arrays;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public abstract class AbstractTestBlock {
    protected static void assertBlock(Block block, Slice[] expectedValues) {
        AbstractTestBlock.assertBlockPositions(block, expectedValues);
        AbstractTestBlock.assertBlockPositions(AbstractTestBlock.copyBlock(block), expectedValues);
        try {
            block.isNull(-1);
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            block.isNull(block.getPositionCount());
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static void assertBlockPositions(Block block, Slice[] expectedValues) {
        Assert.assertEquals((int)block.getPositionCount(), (int)expectedValues.length);
        for (int position = 0; position < block.getPositionCount(); ++position) {
            AbstractTestBlock.assertBlockPosition(block, position, expectedValues[position]);
        }
    }

    private static void assertBlockPosition(Block block, int position, Slice expectedValue) {
        AbstractTestBlock.assertPositionValue(block, position, expectedValue);
        AbstractTestBlock.assertPositionValue(block.getSingleValueBlock(position), 0, expectedValue);
        AbstractTestBlock.assertPositionValue(block.getRegion(position, 1), 0, expectedValue);
        AbstractTestBlock.assertPositionValue(block.getRegion(0, position + 1), position, expectedValue);
        AbstractTestBlock.assertPositionValue(block.getRegion(position, block.getPositionCount() - position), 0, expectedValue);
    }

    private static void assertPositionValue(Block block, int position, Slice expectedValue) {
        int offset;
        if (expectedValue == null) {
            Assert.assertTrue((boolean)block.isNull(position));
            return;
        }
        Assert.assertFalse((boolean)block.isNull(position));
        int length = block.getLength(position);
        Assert.assertEquals((int)length, (int)expectedValue.length());
        for (offset = 0; offset <= length - 1; ++offset) {
            Assert.assertEquals((byte)block.getByte(position, offset), (byte)expectedValue.getByte(offset));
        }
        for (offset = 0; offset <= length - 2; ++offset) {
            Assert.assertEquals((short)block.getShort(position, offset), (short)expectedValue.getShort(offset));
        }
        for (offset = 0; offset <= length - 4; ++offset) {
            Assert.assertEquals((int)block.getInt(position, offset), (int)expectedValue.getInt(offset));
        }
        for (offset = 0; offset <= length - 8; ++offset) {
            Assert.assertEquals((long)block.getLong(position, offset), (long)expectedValue.getLong(offset));
        }
        for (offset = 0; offset <= length - 4; ++offset) {
            Assert.assertEquals((int)Float.floatToIntBits(block.getFloat(position, offset)), (int)Float.floatToIntBits(expectedValue.getFloat(offset)));
        }
        for (offset = 0; offset <= length - 8; ++offset) {
            Assert.assertEquals((long)Double.doubleToLongBits(block.getDouble(position, offset)), (long)Double.doubleToLongBits(expectedValue.getDouble(offset)));
        }
        Block expectedBlock = AbstractTestBlock.toSingeValuedBlock(expectedValue);
        for (int offset2 = 0; offset2 < length - 3; ++offset2) {
            Assert.assertEquals((Object)block.getSlice(position, offset2, 3), (Object)expectedValue.slice(offset2, 3));
            Assert.assertEquals((int)block.hash(position, offset2, 3), (int)expectedValue.hashCode(offset2, 3));
            Assert.assertTrue((boolean)block.bytesEqual(position, offset2, expectedValue, offset2, 3));
            Assert.assertFalse((boolean)block.bytesEqual(position, offset2, Slices.utf8Slice((String)"XXX"), 0, 3));
            Assert.assertEquals((int)block.bytesCompare(position, offset2, 3, expectedValue, offset2, 3), (int)0);
            Assert.assertTrue((block.bytesCompare(position, offset2, 3, expectedValue, offset2, 2) > 0 ? 1 : 0) != 0);
            Slice greaterSlice = AbstractTestBlock.createGreaterValue(expectedValue, offset2, 3);
            Assert.assertTrue((block.bytesCompare(position, offset2, 3, greaterSlice, 0, greaterSlice.length()) < 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)block.equals(position, offset2, expectedBlock, 0, offset2, 3));
            Assert.assertEquals((int)block.compareTo(position, offset2, 3, expectedBlock, 0, offset2, 3), (int)0);
            BlockBuilder blockBuilder = VarbinaryType.VARBINARY.createBlockBuilder(new BlockBuilderStatus());
            block.writeBytesTo(position, offset2, 3, blockBuilder);
            blockBuilder.closeEntry();
            Block segment = blockBuilder.build();
            Assert.assertTrue((boolean)block.equals(position, offset2, segment, 0, 0, 3));
        }
    }

    private static Block copyBlock(Block block) {
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1024);
        BlockEncoding blockEncoding = block.getEncoding();
        blockEncoding.writeBlock((SliceOutput)sliceOutput, block);
        return blockEncoding.readBlock((SliceInput)sliceOutput.slice().getInput());
    }

    private static Block toSingeValuedBlock(Slice expectedValue) {
        BlockBuilder blockBuilder = VarbinaryType.VARBINARY.createBlockBuilder(new BlockBuilderStatus());
        VarbinaryType.VARBINARY.writeSlice(blockBuilder, expectedValue);
        return blockBuilder.build();
    }

    private static Slice createGreaterValue(Slice expectedValue, int offset, int length) {
        DynamicSliceOutput greaterOutput = new DynamicSliceOutput(length + 1);
        greaterOutput.writeBytes(expectedValue, offset, length);
        greaterOutput.writeByte(95);
        return greaterOutput.slice();
    }

    protected static Slice createExpectedValue(int length) {
        DynamicSliceOutput dynamicSliceOutput = new DynamicSliceOutput(16);
        for (int index = 0; index < length; ++index) {
            dynamicSliceOutput.writeByte(length * (index + 1));
        }
        return dynamicSliceOutput.slice();
    }

    protected static Object[] alternatingNullValues(Object[] slices) {
        Object[] slicesWithNulls = Arrays.copyOf(slices, slices.length * 2);
        for (int i = 0; i < slices.length; ++i) {
            slicesWithNulls[i * 2] = slices[i];
            slicesWithNulls[i * 2 + 1] = null;
        }
        return slicesWithNulls;
    }
}

